/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.ui.xul.samples;

import java.util.Vector;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.components.XulTreeCell;
import org.pentaho.ui.xul.containers.XulTree;
import org.pentaho.ui.xul.containers.XulTreeRow;
import org.pentaho.ui.xul.impl.AbstractXulEventHandler;

public class TableEventHandler
extends AbstractXulEventHandler {
    XulTree tree;

    public void setup() {
        this.tree = (XulTree)this.document.getElementById("testTable");
    }

    public void printTable() {
        Object[][] data = this.tree.getValues();
        for (int i = 0; i < data.length; ++i) {
            for (int z = 0; z < data[i].length; ++z) {
                System.out.print(data[i][z] + ",");
            }
            System.out.println("");
        }
    }

    public void printRow() {
        int[] coords = this.tree.getSelectedRows();
        String selectionType = this.tree.getSeltype();
        Object[][] data = this.tree.getValues();
        if (selectionType.equalsIgnoreCase("single")) {
            for (int z = 0; z < data[coords[0]].length; ++z) {
                System.out.print(data[coords[0]][z] + ",");
            }
            System.out.println("");
        } else if (selectionType.equalsIgnoreCase("multiple")) {
            for (int i = 0; i < coords.length; ++i) {
                int idx = coords[i];
                for (int z = 0; z < data[idx].length; ++z) {
                    System.out.print(data[idx][z] + ",");
                }
                System.out.println("");
            }
            System.out.println("");
        } else {
            int[] cellPos = this.tree.getActiveCellCoordinates();
            System.out.println(data[cellPos[1]][cellPos[0]]);
        }
    }

    public void removeRow() {
        this.tree.removeTreeRows(this.tree.getSelectedRows());
    }

    public void newRow() {
        try {
            XulTreeRow row = this.tree.getRootChildren().addNewRow();
            row.addCellText(0, "false");
            row.addCellText(1, "test");
            row.addCellText(2, "fool");
            row.addCellText(3, "foo, bar, baz");
            row.addCellText(4, "fool");
            XulTreeRow newRow = (XulTreeRow)this.document.createElement("treerow");
            XulTreeCell newCell = (XulTreeCell)this.document.createElement("treecell");
            newCell.setValue(Boolean.FALSE);
            newRow.addCell(newCell);
            newCell = (XulTreeCell)this.document.createElement("treecell");
            newCell.setLabel("testing");
            newRow.addCell(newCell);
            newCell = (XulTreeCell)this.document.createElement("treecell");
            newCell.setLabel("testing 2");
            newRow.addCell(newCell);
            newCell = (XulTreeCell)this.document.createElement("treecell");
            Vector<String> vec = new Vector<String>();
            vec.add("foo");
            vec.add("bar");
            vec.add("baz");
            newCell.setValue(vec);
            newRow.addCell(newCell);
            newCell = (XulTreeCell)this.document.createElement("treecell");
            newCell.setLabel("testing 4");
            newRow.addCell(newCell);
            this.tree.addTreeRow(newRow);
        }
        catch (XulException e) {
            System.out.println("Error creating new row: " + e.getMessage());
            e.printStackTrace(System.out);
        }
    }

    @Override
    public Object getData() {
        return null;
    }

    @Override
    public void setData(Object data) {
    }
}

