/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mondrian.olap.Exp;
import mondrian.olap.ExpBase;
import mondrian.olap.OlapElement;
import mondrian.olap.Query;
import mondrian.olap.QueryPart;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;

public class DrillThrough
extends QueryPart {
    private final Query query;
    private final int maxRowCount;
    private final int firstRowOrdinal;
    private final List<OlapElement> returnList;

    DrillThrough(Query query, int maxRowCount, int firstRowOrdinal, List<Exp> returnList) {
        this.query = query;
        this.maxRowCount = maxRowCount;
        this.firstRowOrdinal = firstRowOrdinal;
        this.returnList = Collections.unmodifiableList(this.resolveReturnList(returnList));
    }

    @Override
    public void unparse(PrintWriter pw) {
        pw.print("DRILLTHROUGH");
        if (this.maxRowCount >= 0) {
            pw.print(" MAXROWS ");
            pw.print(this.maxRowCount);
        }
        if (this.firstRowOrdinal >= 0) {
            pw.print(" FIRSTROWSET ");
            pw.print(this.firstRowOrdinal);
        }
        pw.print(" ");
        this.query.unparse(pw);
        if (this.returnList != null) {
            ExpBase.unparseList(pw, this.returnList.toArray(new Exp[this.returnList.size()]), " RETURN ", ", ", "");
        }
    }

    @Override
    public Object[] getChildren() {
        return new Object[]{this.maxRowCount, this.firstRowOrdinal, this.query, this.returnList};
    }

    public Query getQuery() {
        return this.query;
    }

    public int getMaxRowCount() {
        return this.maxRowCount;
    }

    public int getFirstRowOrdinal() {
        return this.firstRowOrdinal;
    }

    public List<OlapElement> getReturnList() {
        return this.returnList;
    }

    private List<OlapElement> resolveReturnList(List<Exp> returnList) {
        if (returnList == null) {
            return Collections.emptyList();
        }
        ArrayList<OlapElement> returnClauseElements = new ArrayList<OlapElement>();
        SchemaReader reader = this.query.getSchemaReader(true);
        for (Exp exp : returnList) {
            OlapElement olapElement = reader.lookupCompound(this.query.getCube(), Util.parseIdentifier(exp.toString()), true, 0);
            if (!(olapElement instanceof OlapElement)) continue;
            returnClauseElements.add(olapElement);
        }
        return returnClauseElements;
    }
}

