/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.ref.Reference;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.RandomAccess;
import java.util.Set;
import java.util.SortedSet;
import java.util.Timer;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mondrian.mdx.DimensionExpr;
import mondrian.mdx.HierarchyExpr;
import mondrian.mdx.LevelExpr;
import mondrian.mdx.MemberExpr;
import mondrian.mdx.NamedSetExpr;
import mondrian.mdx.ParameterExpr;
import mondrian.mdx.QueryPrintWriter;
import mondrian.mdx.UnresolvedFunCall;
import mondrian.olap.Access;
import mondrian.olap.Category;
import mondrian.olap.Cube;
import mondrian.olap.Dimension;
import mondrian.olap.Exp;
import mondrian.olap.Formula;
import mondrian.olap.FunDef;
import mondrian.olap.FunTable;
import mondrian.olap.Hierarchy;
import mondrian.olap.Id;
import mondrian.olap.Level;
import mondrian.olap.MatchType;
import mondrian.olap.Member;
import mondrian.olap.MemberProperty;
import mondrian.olap.MondrianProperties;
import mondrian.olap.NamedSet;
import mondrian.olap.OlapElement;
import mondrian.olap.Parameter;
import mondrian.olap.Property;
import mondrian.olap.Query;
import mondrian.olap.QueryAxis;
import mondrian.olap.Role;
import mondrian.olap.RoleImpl;
import mondrian.olap.Schema;
import mondrian.olap.SchemaReader;
import mondrian.olap.Syntax;
import mondrian.olap.Validator;
import mondrian.olap.fun.FunUtil;
import mondrian.olap.fun.Resolver;
import mondrian.olap.fun.sort.Sorter;
import mondrian.olap.type.Type;
import mondrian.resource.MondrianResource;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapCubeDimension;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapUtil;
import mondrian.spi.UserDefinedFunction;
import mondrian.util.ArraySortedSet;
import mondrian.util.ConcatenableList;
import mondrian.util.Pair;
import mondrian.util.UtilCompatible;
import mondrian.util.UtilCompatibleJdk16;
import org.apache.commons.collections.keyvalue.AbstractMapEntry;
import org.apache.commons.io.IOUtils;
import org.apache.commons.vfs2.FileContent;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.VFS;
import org.apache.commons.vfs2.provider.http.HttpFileObject;
import org.apache.log4j.Logger;
import org.eigenbase.xom.XOMUtil;
import org.olap4j.impl.IdentifierParser;
import org.olap4j.impl.Olap4jUtil;
import org.olap4j.mdx.IdentifierNode;
import org.olap4j.mdx.IdentifierSegment;
import org.olap4j.mdx.KeySegment;
import org.olap4j.mdx.NameSegment;
import org.olap4j.mdx.Quoting;

public class Util
extends XOMUtil {
    public static final String nl = System.getProperty("line.separator");
    private static final Logger LOGGER = Logger.getLogger(Util.class);
    public static final Object nullValue = new Double(1.2345E-8);
    public static final Object EmptyValue = new Double(-1.2345E-8);
    private static long databaseMillis = 0L;
    private static final Random metaRandom = Util.createRandom(MondrianProperties.instance().TestSeed.get());
    public static final UUID JVM_INSTANCE_UUID = UUID.randomUUID();
    public static final boolean IBM_JVM = System.getProperties().getProperty("java.vendor").equals("IBM Corporation");
    public static final int JdbcVersion = System.getProperty("java.version").compareTo("1.7") >= 0 ? 1025 : (System.getProperty("java.version").compareTo("1.6") >= 0 ? 1024 : 768);
    public static final boolean Retrowoven = Access.class.getSuperclass().getName().equals("net.sourceforge.retroweaver.runtime.java.lang.Enum");
    private static final UtilCompatible compatible = new UtilCompatibleJdk16();
    public static final boolean DEBUG = false;
    private static final Map<String, String> TIME_UNITS = Olap4jUtil.mapOf((Object)"ns", (Object)"NANOSECONDS", (Object[])new Object[]{"us", "MICROSECONDS", "ms", "MILLISECONDS", "s", "SECONDS", "m", "MINUTES", "h", "HOURS", "d", "DAYS"});
    private static final Functor1 IDENTITY_FUNCTOR = new Functor1<Object, Object>(){

        @Override
        public Object apply(Object param) {
            return param;
        }
    };
    private static final Functor1 TRUE_FUNCTOR = new Functor1<Boolean, Object>(){

        @Override
        public Boolean apply(Object param) {
            return true;
        }
    };
    private static final Functor1 FALSE_FUNCTOR = new Functor1<Boolean, Object>(){

        @Override
        public Boolean apply(Object param) {
            return false;
        }
    };

    public static boolean isNull(Object o) {
        return o == null || o == nullValue;
    }

    public static <T> boolean isSorted(List<T> list) {
        Object prev = null;
        for (T t : list) {
            if (prev != null && ((Comparable)prev).compareTo(t) >= 0) {
                return false;
            }
            prev = t;
        }
        return true;
    }

    public static byte[] digestSha256(String value) {
        MessageDigest algorithm;
        try {
            algorithm = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        return algorithm.digest(value.getBytes());
    }

    public static byte[] digestMd5(String value) {
        MessageDigest algorithm;
        try {
            algorithm = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        return algorithm.digest(value.getBytes());
    }

    public static ExecutorService getExecutorService(int maximumPoolSize, int corePoolSize, long keepAliveTime, final String name, RejectedExecutionHandler rejectionPolicy) {
        ThreadFactory factory = new ThreadFactory(){
            private final AtomicInteger counter = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                Thread t = Executors.defaultThreadFactory().newThread(r);
                t.setDaemon(true);
                t.setName(name + '_' + this.counter.incrementAndGet());
                return t;
            }
        };
        ThreadPoolExecutor executor = new ThreadPoolExecutor(corePoolSize, maximumPoolSize > 0 ? maximumPoolSize : Integer.MAX_VALUE, keepAliveTime, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), factory);
        if (rejectionPolicy != null) {
            executor.setRejectedExecutionHandler(rejectionPolicy);
        }
        return executor;
    }

    public static ScheduledExecutorService getScheduledExecutorService(int maxNbThreads, final String name) {
        return Executors.newScheduledThreadPool(maxNbThreads, new ThreadFactory(){
            final AtomicInteger counter = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = Executors.defaultThreadFactory().newThread(r);
                thread.setDaemon(true);
                thread.setName(name + '_' + this.counter.incrementAndGet());
                return thread;
            }
        });
    }

    public static String mdxEncodeString(String st) {
        StringBuilder retString = new StringBuilder(st.length() + 20);
        for (int i = 0; i < st.length(); ++i) {
            char c = st.charAt(i);
            if (c == ']' && i + 1 < st.length() && st.charAt(i + 1) != '.') {
                retString.append(']');
            }
            retString.append(c);
        }
        return retString.toString();
    }

    public static String quoteForMdx(String val) {
        StringBuilder buf = new StringBuilder(val.length() + 20);
        Util.quoteForMdx(buf, val);
        return buf.toString();
    }

    public static StringBuilder quoteForMdx(StringBuilder buf, String val) {
        buf.append("\"");
        String s0 = Util.replace(val, "\"", "\"\"");
        buf.append(s0);
        buf.append("\"");
        return buf;
    }

    public static String quoteMdxIdentifier(String id) {
        StringBuilder buf = new StringBuilder(id.length() + 20);
        Util.quoteMdxIdentifier(id, buf);
        return buf.toString();
    }

    public static void quoteMdxIdentifier(String id, StringBuilder buf) {
        buf.append('[');
        int start = buf.length();
        buf.append(id);
        Util.replace(buf, start, "]", "]]");
        buf.append(']');
    }

    public static String quoteMdxIdentifier(List<Id.Segment> ids) {
        StringBuilder sb = new StringBuilder(64);
        Util.quoteMdxIdentifier(ids, sb);
        return sb.toString();
    }

    public static void quoteMdxIdentifier(List<Id.Segment> ids, StringBuilder sb) {
        for (int i = 0; i < ids.size(); ++i) {
            if (i > 0) {
                sb.append('.');
            }
            ids.get(i).toString(sb);
        }
    }

    public static String quoteJavaString(String s) {
        return s == null ? "null" : "\"" + s.replaceAll("\\\\", "\\\\\\\\").replaceAll("\\\"", "\\\\\"") + "\"";
    }

    public static boolean equals(Object s, Object t) {
        if (s == t) {
            return true;
        }
        if (s == null || t == null) {
            return false;
        }
        return s.equals(t);
    }

    public static boolean equals(String s, String t) {
        return Util.equals((Object)s, (Object)t);
    }

    public static boolean equalName(String s, String t) {
        if (s == null) {
            return t == null;
        }
        boolean caseSensitive = MondrianProperties.instance().CaseSensitive.get();
        return caseSensitive ? s.equals(t) : s.equalsIgnoreCase(t);
    }

    public static boolean equal(String s, String t, boolean matchCase) {
        return matchCase ? s.equals(t) : s.equalsIgnoreCase(t);
    }

    public static int caseSensitiveCompareName(String s, String t) {
        boolean caseSensitive = MondrianProperties.instance().CaseSensitive.get();
        if (caseSensitive) {
            return s.compareTo(t);
        }
        int v = s.compareToIgnoreCase(t);
        return v == 0 ? s.compareTo(t) : v;
    }

    public static int compareName(String s, String t) {
        boolean caseSensitive = MondrianProperties.instance().CaseSensitive.get();
        return caseSensitive ? s.compareTo(t) : s.compareToIgnoreCase(t);
    }

    public static String normalizeName(String s) {
        return MondrianProperties.instance().CaseSensitive.get() ? s : s.toUpperCase();
    }

    public static int compareKey(Object k1, Object k2) {
        if (k1 instanceof Boolean) {
            k1 = k1.toString();
            k2 = k2.toString();
        }
        return ((Comparable)k1).compareTo(k2);
    }

    public static int compare(int i0, int i1) {
        return i0 < i1 ? -1 : (i0 == i1 ? 0 : 1);
    }

    public static String replace(String s, String find, String replace) {
        int found = s.indexOf(find);
        if (found == -1) {
            return s;
        }
        StringBuilder sb = new StringBuilder(s.length() + 20);
        int start = 0;
        char[] chars = s.toCharArray();
        int step = find.length();
        if (step == 0) {
            sb.append(s);
            Util.replace(sb, 0, find, replace);
        } else {
            while (true) {
                sb.append(chars, start, found - start);
                if (found == s.length()) break;
                sb.append(replace);
                start = found + step;
                if ((found = s.indexOf(find, start)) != -1) continue;
                found = s.length();
            }
        }
        return sb.toString();
    }

    public static StringBuilder replace(StringBuilder buf, int start, String find, String replace) {
        int i;
        int findLength = find.length();
        if (findLength == 0) {
            for (int j = buf.length(); j >= 0; --j) {
                buf.insert(j, replace);
            }
            return buf;
        }
        int k = buf.length();
        while (k > 0 && (i = buf.lastIndexOf(find, k)) >= start) {
            buf.replace(i, i + find.length(), replace);
            k = i - findLength;
        }
        return buf;
    }

    public static List<Id.Segment> parseIdentifier(String s) {
        return Util.convert(IdentifierParser.parseIdentifier((String)s));
    }

    public static String implode(List<Id.Segment> names) {
        StringBuilder sb = new StringBuilder(64);
        for (int i = 0; i < names.size(); ++i) {
            if (i > 0) {
                sb.append(".");
            }
            Id.Segment segment = names.get(i);
            switch (segment.getQuoting()) {
                case UNQUOTED: {
                    segment = new Id.NameSegment(((Id.NameSegment)segment).name);
                }
            }
            segment.toString(sb);
        }
        return sb.toString();
    }

    public static String makeFqName(String name) {
        return Util.quoteMdxIdentifier(name);
    }

    public static String makeFqName(OlapElement parent, String name) {
        if (parent == null) {
            return Util.quoteMdxIdentifier(name);
        }
        StringBuilder buf = new StringBuilder(64);
        buf.append(parent.getUniqueName());
        buf.append('.');
        Util.quoteMdxIdentifier(name, buf);
        return buf.toString();
    }

    public static String makeFqName(String parentUniqueName, String name) {
        if (parentUniqueName == null) {
            return Util.quoteMdxIdentifier(name);
        }
        StringBuilder buf = new StringBuilder(64);
        buf.append(parentUniqueName);
        buf.append('.');
        Util.quoteMdxIdentifier(name, buf);
        return buf.toString();
    }

    public static OlapElement lookupCompound(SchemaReader schemaReader, OlapElement parent, List<Id.Segment> names, boolean failIfNotFound, int category) {
        return Util.lookupCompound(schemaReader, parent, names, failIfNotFound, category, MatchType.EXACT);
    }

    public static OlapElement lookupCompound(SchemaReader schemaReader, OlapElement parent, List<Id.Segment> names, boolean failIfNotFound, int category, MatchType matchType) {
        Util.assertPrecondition(parent != null, "parent != null");
        if (LOGGER.isDebugEnabled()) {
            StringBuilder buf = new StringBuilder(64);
            buf.append("Util.lookupCompound: ");
            buf.append("parent.name=");
            buf.append(parent.getName());
            buf.append(", category=");
            buf.append(Category.instance.getName(category));
            buf.append(", names=");
            Util.quoteMdxIdentifier(names, buf);
            LOGGER.debug((Object)buf.toString());
        }
        switch (category) {
            case 0: 
            case 6: {
                Member member = schemaReader.getCalculatedMember(names);
                if (member == null) break;
                return member;
            }
        }
        switch (category) {
            case 0: 
            case 8: {
                NamedSet namedSet = schemaReader.getNamedSet(names);
                if (namedSet == null) break;
                return namedSet;
            }
        }
        for (int i = 0; i < names.size(); ++i) {
            OlapElement child;
            Id.NameSegment name;
            if (names.get(i) instanceof Id.NameSegment) {
                name = (Id.NameSegment)names.get(i);
                child = schemaReader.getElementChild(parent, name, matchType);
            } else if (parent instanceof RolapLevel && names.get(i) instanceof Id.KeySegment && names.get(i).getKeyParts().size() == 1) {
                Id.KeySegment keySegment = (Id.KeySegment)names.get(i);
                name = keySegment.getKeyParts().get(0);
                List<Member> levelMembers = schemaReader.getLevelMembers((Level)parent, false);
                child = null;
                for (Member member : levelMembers) {
                    if (!((RolapMember)member).getKey().toString().equals(name.getName())) continue;
                    child = member;
                    break;
                }
            } else {
                name = null;
                child = schemaReader.getElementChild(parent, name, matchType);
            }
            if (child instanceof Member && !matchType.isExact() && !Util.equalName(child.getName(), name.getName())) {
                Member bestChild = (Member)child;
                for (int j = i + 1; j < names.size(); ++j) {
                    List<Member> childrenList = schemaReader.getMemberChildren(bestChild);
                    Sorter.hierarchizeMemberList(childrenList, false);
                    bestChild = matchType == MatchType.AFTER ? childrenList.get(0) : childrenList.get(childrenList.size() - 1);
                    if (bestChild != null) continue;
                    child = null;
                    break;
                }
                parent = bestChild;
                break;
            }
            if (child == null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Util.lookupCompound: parent.name=" + parent.getName() + " has no child with name=" + name));
                }
                if (!failIfNotFound) {
                    return null;
                }
                if (category == 6) {
                    throw MondrianResource.instance().MemberNotFound.ex(Util.quoteMdxIdentifier(names));
                }
                throw MondrianResource.instance().MdxChildObjectNotFound.ex(name.toString(), parent.getQualifiedName());
            }
            parent = child;
            if (matchType != MatchType.EXACT_SCHEMA) continue;
            matchType = MatchType.EXACT;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Util.lookupCompound: found child.name=" + parent.getName() + ", child.class=" + parent.getClass().getName()));
        }
        switch (category) {
            case 2: {
                if (parent instanceof Dimension) {
                    return parent;
                }
                if (parent instanceof Hierarchy) {
                    return parent.getDimension();
                }
                if (failIfNotFound) {
                    throw Util.newError("Can not find dimension '" + Util.implode(names) + "'");
                }
                return null;
            }
            case 3: {
                if (parent instanceof Hierarchy) {
                    return parent;
                }
                if (parent instanceof Dimension) {
                    return parent.getHierarchy();
                }
                if (failIfNotFound) {
                    throw Util.newError("Can not find hierarchy '" + Util.implode(names) + "'");
                }
                return null;
            }
            case 4: {
                if (parent instanceof Level) {
                    return parent;
                }
                if (failIfNotFound) {
                    throw Util.newError("Can not find level '" + Util.implode(names) + "'");
                }
                return null;
            }
            case 6: {
                if (parent instanceof Member) {
                    return parent;
                }
                if (failIfNotFound) {
                    throw MondrianResource.instance().MdxCantFindMember.ex(Util.implode(names));
                }
                return null;
            }
            case 0: {
                Util.assertPostcondition(parent != null, "return != null");
                return parent;
            }
        }
        throw Util.newInternal("Bad switch " + category);
    }

    public static OlapElement lookup(Query q, List<Id.Segment> nameParts) {
        Exp exp = Util.lookup(q, nameParts, false);
        if (exp instanceof MemberExpr) {
            MemberExpr memberExpr = (MemberExpr)exp;
            return memberExpr.getMember();
        }
        if (exp instanceof LevelExpr) {
            LevelExpr levelExpr = (LevelExpr)exp;
            return levelExpr.getLevel();
        }
        if (exp instanceof HierarchyExpr) {
            HierarchyExpr hierarchyExpr = (HierarchyExpr)exp;
            return hierarchyExpr.getHierarchy();
        }
        if (exp instanceof DimensionExpr) {
            DimensionExpr dimensionExpr = (DimensionExpr)exp;
            return dimensionExpr.getDimension();
        }
        throw Util.newInternal("Not an olap element: " + exp);
    }

    public static Exp lookup(Query q, List<Id.Segment> nameParts, boolean allowProp) {
        return Util.lookup(q, q.getSchemaReader(true), nameParts, allowProp);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Exp lookup(Query q, SchemaReader schemaReader, List<Id.Segment> segments, boolean allowProp) {
        Cube cube;
        String fullName = Util.quoteMdxIdentifier(segments);
        SchemaReader schemaReaderSansAc = schemaReader.withoutAccessControl().withLocus();
        OlapElement olapElement = schemaReaderSansAc.lookupCompound(cube = q.getCube(), segments, false, 0);
        if (olapElement != null) {
            Role role = schemaReader.getRole();
            if (!role.canAccess(olapElement)) {
                olapElement = null;
            }
            if (olapElement instanceof Member) {
                olapElement = schemaReader.substitute((Member)olapElement);
            }
        }
        if (olapElement == null) {
            if (allowProp && segments.size() > 1) {
                List<Id.Segment> segmentsButOne = segments.subList(0, segments.size() - 1);
                Id.Segment lastSegment = Util.last(segments);
                String propertyName = lastSegment instanceof Id.NameSegment ? ((Id.NameSegment)lastSegment).getName() : null;
                Member member = (Member)schemaReaderSansAc.lookupCompound(cube, segmentsButOne, false, 6);
                if (member != null && propertyName != null && Util.isValidProperty(propertyName, member.getLevel())) {
                    return new UnresolvedFunCall(propertyName, Syntax.Property, new Exp[]{Util.createExpr(member)});
                }
                Level level = (Level)schemaReaderSansAc.lookupCompound(cube, segmentsButOne, false, 4);
                if (level != null && propertyName != null && Util.isValidProperty(propertyName, level)) {
                    return new UnresolvedFunCall(propertyName, Syntax.Property, new Exp[]{Util.createExpr(level)});
                }
            }
            if (!q.ignoreInvalidMembers()) throw MondrianResource.instance().MdxChildObjectNotFound.ex(fullName, cube.getQualifiedName());
            olapElement = null;
            for (int nameLen = segments.size() - 1; nameLen > 0 && olapElement == null; --nameLen) {
                List<Id.Segment> partialName = segments.subList(0, nameLen);
                olapElement = schemaReaderSansAc.lookupCompound(cube, partialName, false, 0);
            }
            if (olapElement == null) throw MondrianResource.instance().MdxChildObjectNotFound.ex(fullName, cube.getQualifiedName());
            olapElement = olapElement.getHierarchy().getNullMember();
        }
        q.addMeasuresMembers(olapElement);
        return Util.createExpr(olapElement);
    }

    static Cube lookupCube(SchemaReader schemaReader, String cubeName, boolean fail) {
        for (Cube cube : schemaReader.getCubes()) {
            if (Util.compareName(cube.getName(), cubeName) != 0) continue;
            return cube;
        }
        if (fail) {
            throw MondrianResource.instance().MdxCubeNotFound.ex(cubeName);
        }
        return null;
    }

    public static Exp createExpr(OlapElement element) {
        if (element instanceof Member) {
            Member member = (Member)element;
            return new MemberExpr(member);
        }
        if (element instanceof Level) {
            Level level = (Level)element;
            return new LevelExpr(level);
        }
        if (element instanceof Hierarchy) {
            Hierarchy hierarchy = (Hierarchy)element;
            return new HierarchyExpr(hierarchy);
        }
        if (element instanceof Dimension) {
            Dimension dimension = (Dimension)element;
            return new DimensionExpr(dimension);
        }
        if (element instanceof NamedSet) {
            NamedSet namedSet = (NamedSet)element;
            return new NamedSetExpr(namedSet);
        }
        throw Util.newInternal("Unexpected element type: " + element);
    }

    public static Member lookupHierarchyRootMember(SchemaReader reader, Hierarchy hierarchy, Id.NameSegment memberName) {
        return Util.lookupHierarchyRootMember(reader, hierarchy, memberName, MatchType.EXACT);
    }

    public static Member lookupHierarchyRootMember(SchemaReader reader, Hierarchy hierarchy, Id.NameSegment memberName, MatchType matchType) {
        List<Member> rootMembers = reader.getHierarchyRootMembers(hierarchy);
        Member searchMember = null;
        if (!(matchType.isExact() || hierarchy.hasAll() || rootMembers.isEmpty())) {
            searchMember = hierarchy.createMember(null, rootMembers.get(0).getLevel(), memberName.name, null);
        }
        int bestMatch = -1;
        int k = -1;
        for (Member rootMember : rootMembers) {
            ++k;
            int rc = matchType.isExact() || hierarchy.hasAll() ? rootMember.getName().compareToIgnoreCase(memberName.name) : FunUtil.compareSiblingMembers(rootMember, searchMember);
            if (rc == 0) {
                return rootMember;
            }
            if (hierarchy.hasAll()) continue;
            if (matchType == MatchType.BEFORE) {
                if (rc >= 0 || bestMatch != -1 && FunUtil.compareSiblingMembers(rootMember, rootMembers.get(bestMatch)) <= 0) continue;
                bestMatch = k;
                continue;
            }
            if (matchType != MatchType.AFTER || rc <= 0 || bestMatch != -1 && FunUtil.compareSiblingMembers(rootMember, rootMembers.get(bestMatch)) >= 0) continue;
            bestMatch = k;
        }
        if (matchType == MatchType.EXACT_SCHEMA) {
            return null;
        }
        if (matchType != MatchType.EXACT && bestMatch != -1) {
            return rootMembers.get(bestMatch);
        }
        return rootMembers.size() > 0 && rootMembers.get(0).isAll() ? reader.lookupMemberChildByName(rootMembers.get(0), memberName, matchType) : null;
    }

    public static Level lookupHierarchyLevel(Hierarchy hierarchy, String s) {
        Level[] levels;
        for (Level level : levels = hierarchy.getLevels()) {
            if (!level.getName().equalsIgnoreCase(s)) continue;
            return level;
        }
        return null;
    }

    public static int getMemberOrdinalInParent(SchemaReader reader, Member member) {
        Member parent = member.getParentMember();
        List<Member> siblings = parent == null ? reader.getHierarchyRootMembers(member.getHierarchy()) : reader.getMemberChildren(parent);
        for (int i = 0; i < siblings.size(); ++i) {
            if (!siblings.get(i).equals(member)) continue;
            return i;
        }
        throw Util.newInternal("could not find member " + member + " amongst its siblings");
    }

    public static Member getFirstDescendantOnLevel(SchemaReader reader, Member parent, Level level) {
        Member m = parent;
        while (m.getLevel() != level) {
            List<Member> children = reader.getMemberChildren(m);
            m = children.get(0);
        }
        return m;
    }

    public static boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }

    public static String singleQuoteString(String val) {
        StringBuilder buf = new StringBuilder(64);
        Util.singleQuoteString(val, buf);
        return buf.toString();
    }

    public static void singleQuoteString(String val, StringBuilder buf) {
        buf.append('\'');
        String s0 = Util.replace(val, "'", "''");
        buf.append(s0);
        buf.append('\'');
    }

    public static Random createRandom(long seed) {
        if (seed == 0L) {
            seed = new Random().nextLong();
            System.out.println("random: seed=" + seed);
        } else if (seed == -1L && metaRandom != null) {
            seed = metaRandom.nextLong();
        }
        return new Random(seed);
    }

    public static boolean isValidProperty(String propertyName, Level level) {
        return Util.lookupProperty(level, propertyName) != null;
    }

    public static Property lookupProperty(Level level, String propertyName) {
        do {
            Property[] properties;
            for (Property property : properties = level.getProperties()) {
                if (!property.getName().equals(propertyName)) continue;
                return property;
            }
        } while ((level = level.getParentLevel()) != null);
        boolean caseSensitive = MondrianProperties.instance().CaseSensitive.get();
        Property property = Property.lookup(propertyName, caseSensitive);
        if (property != null && property.isMemberProperty() && property.isStandard()) {
            return property;
        }
        return null;
    }

    public static <T> T deprecated(T reason) {
        throw new UnsupportedOperationException(reason.toString());
    }

    public static <T> T deprecated(T reason, boolean fail) {
        if (fail) {
            throw new UnsupportedOperationException(reason.toString());
        }
        return reason;
    }

    public static List<Member> addLevelCalculatedMembers(SchemaReader reader, Level level, List<Member> members) {
        List<Member> calcMembers = reader.getCalculatedMembers(level.getHierarchy());
        ArrayList<Member> calcMembersInThisLevel = new ArrayList<Member>();
        for (Member calcMember : calcMembers) {
            if (!calcMember.getLevel().equals(level)) continue;
            calcMembersInThisLevel.add(calcMember);
        }
        if (!calcMembersInThisLevel.isEmpty()) {
            ConcatenableList<Member> newMemberList = new ConcatenableList<Member>();
            newMemberList.addAll(members);
            newMemberList.addAll(calcMembersInThisLevel);
            return newMemberList;
        }
        return members;
    }

    public static RuntimeException needToImplement(Object o) {
        throw new UnsupportedOperationException("need to implement " + o);
    }

    public static <T extends Enum<T>> RuntimeException badValue(Enum<T> anEnum) {
        return Util.newInternal("Was not expecting value '" + anEnum + "' for enumeration '" + anEnum.getDeclaringClass().getName() + "' in this context");
    }

    public static String wildcardToRegexp(List<String> wildcards) {
        StringBuilder buf = new StringBuilder();
        block0: for (String value : wildcards) {
            if (buf.length() > 0) {
                buf.append('|');
            }
            int i = 0;
            while (true) {
                int percent = value.indexOf(37, i);
                int underscore = value.indexOf(95, i);
                if (percent == -1 && underscore == -1) {
                    if (i >= value.length()) continue block0;
                    buf.append(Util.quotePattern(value.substring(i)));
                    continue block0;
                }
                if (underscore >= 0 && (underscore < percent || percent < 0)) {
                    if (i < underscore) {
                        buf.append(Util.quotePattern(value.substring(i, underscore)));
                    }
                    buf.append('.');
                    i = underscore + 1;
                    continue;
                }
                if (percent < 0 || percent >= underscore && underscore >= 0) break;
                if (i < percent) {
                    buf.append(Util.quotePattern(value.substring(i, percent)));
                }
                buf.append(".*");
                i = percent + 1;
            }
            throw new IllegalArgumentException();
        }
        return buf.toString();
    }

    public static String camelToUpper(String s) {
        StringBuilder buf = new StringBuilder(s.length() + 10);
        int prevUpper = -1;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (Character.isUpperCase(c)) {
                if (i > prevUpper + 1) {
                    buf.append('_');
                }
                prevUpper = i;
            } else {
                c = Character.toUpperCase(c);
            }
            buf.append(c);
        }
        return buf.toString();
    }

    public static List<String> parseCommaList(String nameCommaList) {
        String[] strings;
        if (nameCommaList.equals("")) {
            return Collections.emptyList();
        }
        if (nameCommaList.endsWith(",")) {
            String zzz = "zzz";
            List<String> list = Util.parseCommaList(nameCommaList + "zzz");
            String last = list.get(list.size() - 1);
            if (last.equals("zzz")) {
                list.remove(list.size() - 1);
            } else {
                list.set(list.size() - 1, last.substring(0, last.length() - "zzz".length()));
            }
            return list;
        }
        ArrayList<String> names = new ArrayList<String>();
        for (String string : strings = nameCommaList.split(",")) {
            int count = names.size();
            if (count > 0 && ((String)names.get(count - 1)).equals("")) {
                if (count == 1) {
                    if (string.equals("")) {
                        names.add("");
                        continue;
                    }
                    names.set(0, "," + string);
                    continue;
                }
                names.set(count - 2, (String)names.get(count - 2) + "," + string);
                names.remove(count - 1);
                continue;
            }
            names.add(string);
        }
        return names;
    }

    public static <T> T getAnnotation(Method method, String annotationClassName, T defaultValue) {
        return compatible.getAnnotation(method, annotationClassName, defaultValue);
    }

    public static void cancelStatement(Statement stmt) {
        compatible.cancelStatement(stmt);
    }

    public static MemoryInfo getMemoryInfo() {
        return compatible.getMemoryInfo();
    }

    public static <T> String commaList(String s, List<T> list) {
        StringBuilder buf = new StringBuilder(s);
        buf.append("(");
        int k = -1;
        for (T t : list) {
            if (++k > 0) {
                buf.append(", ");
            }
            buf.append(t);
        }
        buf.append(")");
        return buf.toString();
    }

    public static String uniquify(String name, int maxLength, Collection<String> nameList) {
        assert (name != null);
        if (name.length() > maxLength) {
            name = name.substring(0, maxLength);
        }
        if (nameList.contains(name)) {
            String aliasBase = name;
            int j = 0;
            while (true) {
                if ((name = aliasBase + j).length() > maxLength) {
                    aliasBase = aliasBase.substring(0, aliasBase.length() - 1);
                    continue;
                }
                if (!nameList.contains(name)) break;
                ++j;
            }
        }
        nameList.add(name);
        return name;
    }

    public static <T> boolean areOccurencesEqual(Collection<T> collection) {
        Iterator<T> it = collection.iterator();
        if (!it.hasNext()) {
            return false;
        }
        T first = it.next();
        while (it.hasNext()) {
            T t = it.next();
            if (t.equals(first)) continue;
            return false;
        }
        return true;
    }

    public static <T> List<T> flatList(T ... t) {
        return Util._flatList(t, false);
    }

    public static <T> List<T> flatListCopy(T ... t) {
        return Util._flatList(t, true);
    }

    private static <T> List<T> _flatList(T[] t, boolean copy) {
        switch (t.length) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(t[0]);
            }
            case 2: {
                return new Flat2List<T>(t[0], t[1]);
            }
            case 3: {
                return new Flat3List<T>(t[0], t[1], t[2]);
            }
        }
        if (copy) {
            return Arrays.asList((Object[])t.clone());
        }
        return Arrays.asList(t);
    }

    public static <T> List<T> flatList(List<T> t) {
        switch (t.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(t.get(0));
            }
            case 2: {
                return new Flat2List<T>(t.get(0), t.get(1));
            }
            case 3: {
                return new Flat3List<T>(t.get(0), t.get(1), t.get(2));
            }
        }
        return Arrays.asList(t.toArray());
    }

    public static Locale parseLocale(String localeString) {
        String[] strings = localeString.split("_");
        switch (strings.length) {
            case 1: {
                return new Locale(strings[0]);
            }
            case 2: {
                return new Locale(strings[0], strings[1]);
            }
            case 3: {
                return new Locale(strings[0], strings[1], strings[2]);
            }
        }
        throw Util.newInternal("bad locale string '" + localeString + "'");
    }

    public static Pair<Long, TimeUnit> parseInterval(String s, TimeUnit unit) throws NumberFormatException {
        String original = s;
        for (Map.Entry<String, String> entry : TIME_UNITS.entrySet()) {
            String abbrev = entry.getKey();
            if (!s.endsWith(abbrev)) continue;
            String full = entry.getValue();
            try {
                unit = TimeUnit.valueOf(full);
                s = s.substring(0, s.length() - abbrev.length());
                break;
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
        }
        if (unit == null) {
            throw new NumberFormatException("Invalid time interval '" + original + "'. Does not contain a time unit. (Suffix may be ns (nanoseconds), us (microseconds), ms (milliseconds), s (seconds), h (hours), d (days). For example, '20s' means 20 seconds.)");
        }
        try {
            return Pair.of(new BigDecimal(s).longValue(), unit);
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("Invalid time interval '" + original + "'");
        }
    }

    public static List<Id.Segment> convert(List<IdentifierSegment> olap4jSegmentList) {
        ArrayList<Id.Segment> list = new ArrayList<Id.Segment>();
        for (IdentifierSegment olap4jSegment : olap4jSegmentList) {
            list.add(Util.convert(olap4jSegment));
        }
        return list;
    }

    public static Id.Segment convert(IdentifierSegment olap4jSegment) {
        if (olap4jSegment instanceof NameSegment) {
            return Util.convert((NameSegment)olap4jSegment);
        }
        return Util.convert((KeySegment)olap4jSegment);
    }

    private static Id.KeySegment convert(final KeySegment keySegment) {
        return new Id.KeySegment((List<Id.NameSegment>)new AbstractList<Id.NameSegment>(){

            @Override
            public Id.NameSegment get(int index) {
                return Util.convert((NameSegment)keySegment.getKeyParts().get(index));
            }

            @Override
            public int size() {
                return keySegment.getKeyParts().size();
            }
        });
    }

    private static Id.NameSegment convert(NameSegment nameSegment) {
        return new Id.NameSegment(nameSegment.getName(), Util.convert(nameSegment.getQuoting()));
    }

    private static Id.Quoting convert(Quoting quoting) {
        switch (quoting) {
            case QUOTED: {
                return Id.Quoting.QUOTED;
            }
            case UNQUOTED: {
                return Id.Quoting.UNQUOTED;
            }
            case KEY: {
                return Id.Quoting.KEY;
            }
        }
        throw Util.unexpected((Enum)quoting);
    }

    public static <T> Iterable<T> filter(final Iterable<T> iterable, Functor1<Boolean, T> ... conds) {
        final Functor1[] conds2 = Util.optimizeConditions(conds);
        if (conds2.length == 0) {
            return iterable;
        }
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(){
                    final Iterator<T> iterator;
                    T next;
                    boolean hasNext;
                    {
                        this.iterator = iterable.iterator();
                        this.hasNext = this.moveToNext();
                    }

                    private boolean moveToNext() {
                        block0: while (this.iterator.hasNext()) {
                            this.next = this.iterator.next();
                            for (Functor1 cond : conds2) {
                                if (!((Boolean)cond.apply(this.next)).booleanValue()) continue block0;
                            }
                            return true;
                        }
                        return false;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.hasNext;
                    }

                    @Override
                    public T next() {
                        Object t = this.next;
                        this.hasNext = this.moveToNext();
                        return t;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    private static <T> Functor1<Boolean, T>[] optimizeConditions(Functor1<Boolean, T>[] conds) {
        ArrayList<Functor1<Boolean, Functor1>> functor1List = new ArrayList<Functor1<Boolean, Functor1>>(Arrays.asList(conds));
        Iterator funcIter = functor1List.iterator();
        while (funcIter.hasNext()) {
            Functor1 booleanTFunctor1 = (Functor1)funcIter.next();
            if (booleanTFunctor1 != Util.trueFunctor()) continue;
            funcIter.remove();
        }
        if (functor1List.size() < conds.length) {
            return functor1List.toArray(new Functor1[functor1List.size()]);
        }
        return conds;
    }

    public static <T extends Comparable> List<T> sort(Collection<T> collection) {
        Object[] a = collection.toArray(new Object[collection.size()]);
        Arrays.sort(a);
        return Util.cast(Arrays.asList(a));
    }

    public static <T> List<T> sort(Collection<T> collection, Comparator<T> comparator) {
        Object[] a = collection.toArray(new Object[collection.size()]);
        Arrays.sort(a, comparator);
        return Util.cast(Arrays.asList(a));
    }

    public static List<IdentifierSegment> toOlap4j(final List<Id.Segment> segments) {
        return new AbstractList<IdentifierSegment>(){

            @Override
            public IdentifierSegment get(int index) {
                return Util.toOlap4j((Id.Segment)segments.get(index));
            }

            @Override
            public int size() {
                return segments.size();
            }
        };
    }

    public static IdentifierSegment toOlap4j(Id.Segment segment) {
        switch (segment.quoting) {
            case KEY: {
                return Util.toOlap4j((Id.KeySegment)segment);
            }
        }
        return Util.toOlap4j((Id.NameSegment)segment);
    }

    private static KeySegment toOlap4j(final Id.KeySegment keySegment) {
        return new KeySegment((List)new AbstractList<NameSegment>(){

            @Override
            public NameSegment get(int index) {
                return Util.toOlap4j(keySegment.subSegmentList.get(index));
            }

            @Override
            public int size() {
                return keySegment.subSegmentList.size();
            }
        });
    }

    private static NameSegment toOlap4j(Id.NameSegment nameSegment) {
        return new NameSegment(null, nameSegment.name, Util.toOlap4j(nameSegment.quoting));
    }

    public static Quoting toOlap4j(Id.Quoting quoting) {
        return Quoting.valueOf((String)quoting.name());
    }

    public static boolean matches(IdentifierSegment segment, String name) {
        switch (segment.getQuoting()) {
            case KEY: {
                return false;
            }
            case QUOTED: {
                return Util.equalName(segment.getName(), name);
            }
            case UNQUOTED: {
                return segment.getName().equalsIgnoreCase(name);
            }
        }
        throw Util.unexpected((Enum)segment.getQuoting());
    }

    public static boolean matches(Member member, List<Id.Segment> nameParts) {
        if (Util.equalName(Util.implode(nameParts), member.getUniqueName())) {
            return true;
        }
        Id.Segment segment = nameParts.get(nameParts.size() - 1);
        while (member.getParentMember() != null) {
            if (!segment.matches(member.getName())) {
                return false;
            }
            member = member.getParentMember();
            nameParts = nameParts.subList(0, nameParts.size() - 1);
            segment = nameParts.get(nameParts.size() - 1);
        }
        if (segment.matches(member.getName())) {
            return Util.equalName(member.getHierarchy().getUniqueName(), Util.implode(nameParts.subList(0, nameParts.size() - 1)));
        }
        if (member.isAll()) {
            return Util.equalName(member.getHierarchy().getUniqueName(), Util.implode(nameParts));
        }
        return false;
    }

    public static RuntimeException newElementNotFoundException(int category, IdentifierNode identifierNode) {
        String type;
        switch (category) {
            case 6: {
                return MondrianResource.instance().MemberNotFound.ex(identifierNode.toString());
            }
            case 0: {
                type = "Element";
                break;
            }
            default: {
                type = Category.instance().getDescription(category);
            }
        }
        return Util.newError(type + " '" + identifierNode + "' not found");
    }

    public static <T> T safeGet(Future<T> future, String message) {
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            throw Util.newError(e, message);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw Util.newError(cause, message);
        }
    }

    public static <T> Set<T> newIdentityHashSetFake() {
        final HashMap map = new HashMap();
        return new Set<T>(){

            @Override
            public int size() {
                return map.size();
            }

            @Override
            public boolean isEmpty() {
                return map.isEmpty();
            }

            @Override
            public boolean contains(Object o) {
                return map.containsKey(o);
            }

            @Override
            public Iterator<T> iterator() {
                return map.keySet().iterator();
            }

            @Override
            public Object[] toArray() {
                return map.keySet().toArray();
            }

            @Override
            public <T> T[] toArray(T[] a) {
                return map.keySet().toArray(a);
            }

            @Override
            public boolean add(T t) {
                return map.put(t, Boolean.TRUE) == null;
            }

            @Override
            public boolean remove(Object o) {
                return map.remove(o) == Boolean.TRUE;
            }

            @Override
            public boolean containsAll(Collection<?> c) {
                return map.keySet().containsAll(c);
            }

            @Override
            public boolean addAll(Collection<? extends T> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean retainAll(Collection<?> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void clear() {
                map.clear();
            }
        };
    }

    public static Timer newTimer(String name, boolean isDaemon) {
        return compatible.newTimer(name, isDaemon);
    }

    public static <T extends Comparable<T>> int binarySearch(T[] ts, int start, int end, T t) {
        return compatible.binarySearch((Comparable[])ts, start, end, t);
    }

    public static <E extends Comparable> SortedSet<E> intersect(SortedSet<E> set1, SortedSet<E> set2) {
        if (set1.isEmpty()) {
            return set1;
        }
        if (set2.isEmpty()) {
            return set2;
        }
        if (!(set1 instanceof ArraySortedSet) || !(set2 instanceof ArraySortedSet)) {
            TreeSet<E> set = new TreeSet<E>(set1);
            set.retainAll(set2);
            return set;
        }
        Comparable[] result = new Comparable[Math.min(set1.size(), set2.size())];
        Iterator it1 = set1.iterator();
        Iterator it2 = set2.iterator();
        int i = 0;
        Comparable e1 = (Comparable)it1.next();
        Comparable e2 = (Comparable)it2.next();
        while (true) {
            int compare;
            if ((compare = e1.compareTo(e2)) == 0) {
                result[i++] = e1;
                if (!it1.hasNext() || !it2.hasNext()) break;
                e1 = (Comparable)it1.next();
                e2 = (Comparable)it2.next();
                continue;
            }
            if (compare == 1) {
                if (!it2.hasNext()) break;
                e2 = (Comparable)it2.next();
                continue;
            }
            if (!it1.hasNext()) break;
            e1 = (Comparable)it1.next();
        }
        return new ArraySortedSet(result, 0, i);
    }

    public static int compareIntegers(int i0, int i1) {
        return i0 < i1 ? -1 : (i0 == i1 ? 0 : 1);
    }

    public static <T> T last(List<T> list) {
        return list.get(list.size() - 1);
    }

    public static <T> T only(List<T> list) {
        if (list.size() != 1) {
            throw new IndexOutOfBoundsException("list " + list + " has " + list.size() + " elements, expected 1");
        }
        return list.get(0);
    }

    public static SQLException close(ResultSet resultSet, Statement statement, Connection connection) {
        SQLException firstException;
        block11: {
            block10: {
                firstException = null;
                if (resultSet != null) {
                    try {
                        if (statement == null) {
                            statement = resultSet.getStatement();
                        }
                        resultSet.close();
                    }
                    catch (Throwable t) {
                        firstException = new SQLException();
                        firstException.initCause(t);
                    }
                }
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (Throwable t) {
                        if (firstException != null) break block10;
                        firstException = new SQLException();
                        firstException.initCause(t);
                    }
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Throwable t) {
                    if (firstException != null) break block11;
                    firstException = new SQLException();
                    firstException.initCause(t);
                }
            }
        }
        return firstException;
    }

    public static BitSet bitSetBetween(int fromIndex, int toIndex) {
        BitSet bitSet = new BitSet();
        if (toIndex > fromIndex) {
            bitSet.set(fromIndex, toIndex);
        }
        return bitSet;
    }

    public static <T> T[] genericArray(Class<T> clazz, int size) {
        return (Object[])Array.newInstance(clazz, size);
    }

    public static void assertTrue(boolean b) {
        if (!b) {
            throw Util.newInternal("assert failed");
        }
    }

    public static void assertTrue(boolean b, String message) {
        if (!b) {
            throw Util.newInternal("assert failed: " + message);
        }
    }

    public static RuntimeException newInternal(String message) {
        return MondrianResource.instance().Internal.ex(message);
    }

    public static RuntimeException newInternal(Throwable e, String message) {
        return MondrianResource.instance().Internal.ex(message, e);
    }

    public static RuntimeException newError(String message) {
        return Util.newInternal(message);
    }

    public static RuntimeException newError(Throwable e, String message) {
        return Util.newInternal(e, message);
    }

    public static RuntimeException unexpected(Enum value) {
        return Util.newInternal("Was not expecting value '" + value + "' for enumeration '" + value.getClass().getName() + "' in this context");
    }

    public static void assertPrecondition(boolean b) {
        Util.assertTrue(b);
    }

    public static void assertPrecondition(boolean b, String condition) {
        Util.assertTrue(b, condition);
    }

    public static void assertPostcondition(boolean b) {
        Util.assertTrue(b);
    }

    public static void assertPostcondition(boolean b, String condition) {
        Util.assertTrue(b, condition);
    }

    public static String[] convertStackToString(Throwable e) {
        ArrayList<String> list = new ArrayList<String>();
        while (e != null) {
            String sMsg = Util.getErrorMessage(e);
            list.add(sMsg);
            e = e.getCause();
        }
        return list.toArray(new String[list.size()]);
    }

    public static String getErrorMessage(Throwable err) {
        boolean prependClassName = !(err instanceof SQLException) && err.getClass() != Exception.class;
        return Util.getErrorMessage(err, prependClassName);
    }

    public static String getErrorMessage(Throwable err, boolean prependClassName) {
        String errMsg = err.getMessage();
        if (errMsg == null || err instanceof RuntimeException) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            err.printStackTrace(pw);
            return sw.toString();
        }
        return prependClassName ? err.getClass().getName() + ": " + errMsg : errMsg;
    }

    public static <T extends Throwable> T getMatchingCause(Throwable e, Class<T> clazz) {
        while (!clazz.isInstance(e)) {
            Throwable cause = e.getCause();
            if (cause == null || cause == e) {
                return null;
            }
            e = cause;
        }
        return (T)((Throwable)clazz.cast(e));
    }

    public static String unparse(Exp exp) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        exp.unparse(pw);
        return sw.toString();
    }

    public static String unparse(Query query) {
        StringWriter sw = new StringWriter();
        QueryPrintWriter pw = new QueryPrintWriter(sw);
        query.unparse(pw);
        return sw.toString();
    }

    public static URL toURL(File file) throws MalformedURLException {
        String path = file.getAbsolutePath();
        String fs = System.getProperty("file.separator");
        if (fs.length() == 1) {
            char sep = fs.charAt(0);
            if (sep != '/') {
                path = path.replace(sep, '/');
            }
            if (path.charAt(0) != '/') {
                path = '/' + path;
            }
        }
        path = "file://" + path;
        return new URL(path);
    }

    public static PropertyList parseConnectString(String s) {
        return new ConnectStringParser(s).parse();
    }

    public static int hash(int i, int j) {
        return i << 4 ^ j;
    }

    public static int hash(int h, Object o) {
        int k = o == null ? 0 : o.hashCode();
        return (h << 4 | h) ^ k;
    }

    public static int hashArray(int h, Object[] a) {
        if (a == null) {
            return Util.hash(h, 19690429);
        }
        if (a.length == 0) {
            return Util.hash(h, 19690721);
        }
        for (Object anA : a) {
            h = Util.hash(h, anA);
        }
        return h;
    }

    public static <T> T[] appendArrays(T[] a0, T[] ... as) {
        int n = a0.length;
        for (T[] a : as) {
            n += a.length;
        }
        T[] copy = Util.copyOf(a0, n);
        n = a0.length;
        for (T[] a : as) {
            System.arraycopy(a, 0, copy, n, a.length);
            n += a.length;
        }
        return copy;
    }

    public static <T> T[] append(T[] a, T o) {
        T[] a2 = Util.copyOf(a, a.length + 1);
        a2[a.length] = o;
        return a2;
    }

    public static double[] copyOf(double[] original, int newLength) {
        double[] copy = new double[newLength];
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }

    public static int[] copyOf(int[] original, int newLength) {
        int[] copy = new int[newLength];
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }

    public static long[] copyOf(long[] original, int newLength) {
        long[] copy = new long[newLength];
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }

    public static <T> T[] copyOf(T[] original, int newLength) {
        return Util.copyOf(original, newLength, original.getClass());
    }

    public static <T, U> T[] copyOf(U[] original, int newLength, Class<? extends T[]> newType) {
        Object[] copy = newType == Object[].class ? new Object[newLength] : (Object[])Array.newInstance(newType.getComponentType(), newLength);
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }

    public static long dbTimeMillis() {
        return databaseMillis;
    }

    public static void addDatabaseTime(long millis) {
        databaseMillis += millis;
    }

    public static long nonDbTimeMillis() {
        long systemMillis = System.currentTimeMillis();
        return systemMillis - databaseMillis;
    }

    public static Validator createSimpleValidator(final FunTable funTable) {
        return new Validator(){

            @Override
            public Query getQuery() {
                return null;
            }

            @Override
            public SchemaReader getSchemaReader() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Exp validate(Exp exp, boolean scalar) {
                return exp;
            }

            @Override
            public void validate(ParameterExpr parameterExpr) {
            }

            @Override
            public void validate(MemberProperty memberProperty) {
            }

            @Override
            public void validate(QueryAxis axis) {
            }

            @Override
            public void validate(Formula formula) {
            }

            @Override
            public FunDef getDef(Exp[] args, String name, Syntax syntax) {
                List<Resolver> resolvers = funTable.getResolvers(name, syntax);
                Resolver resolver = resolvers.get(0);
                ArrayList<Resolver.Conversion> conversionList = new ArrayList<Resolver.Conversion>();
                FunDef def = resolver.resolve(args, this, conversionList);
                assert (conversionList.isEmpty());
                return def;
            }

            @Override
            public boolean alwaysResolveFunDef() {
                return false;
            }

            @Override
            public boolean canConvert(int ordinal, Exp fromExp, int to, List<Resolver.Conversion> conversions) {
                return true;
            }

            @Override
            public boolean requiresExpression() {
                return false;
            }

            @Override
            public FunTable getFunTable() {
                return funTable;
            }

            @Override
            public Parameter createOrLookupParam(boolean definition, String name, Type type, Exp defaultExp, String description) {
                return null;
            }
        };
    }

    public static String readFully(Reader rdr, int bufferSize) throws IOException {
        int len;
        if (bufferSize <= 0) {
            throw new IllegalArgumentException("Buffer size must be greater than 0");
        }
        char[] buffer = new char[bufferSize];
        StringBuilder buf = new StringBuilder(bufferSize);
        while ((len = rdr.read(buffer)) != -1) {
            buf.append(buffer, 0, len);
        }
        return buf.toString();
    }

    public static byte[] readFully(InputStream in, int bufferSize) throws IOException {
        int len;
        if (bufferSize <= 0) {
            throw new IllegalArgumentException("Buffer size must be greater than 0");
        }
        byte[] buffer = new byte[bufferSize];
        ByteArrayOutputStream baos = new ByteArrayOutputStream(bufferSize);
        while ((len = in.read(buffer)) != -1) {
            baos.write(buffer, 0, len);
        }
        return baos.toByteArray();
    }

    public static String readURL(String urlStr, Map<String, String> map) throws IOException {
        if (urlStr.startsWith("inline:")) {
            String content = urlStr.substring("inline:".length());
            if (map != null) {
                content = Util.replaceProperties(content, map);
            }
            return content;
        }
        URL url = new URL(urlStr);
        return Util.readURL(url, map);
    }

    public static String readURL(URL url) throws IOException {
        return Util.readURL(url, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readURL(URL url, Map<String, String> map) throws IOException {
        int BUF_SIZE = 8096;
        try (BufferedReader r = new BufferedReader(new InputStreamReader(url.openStream()));){
            String xmlCatalog = Util.readFully(r, 8096);
            String string = xmlCatalog = Util.replaceProperties(xmlCatalog, map);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream readVirtualFile(String url) throws FileSystemException {
        FileSystemManager fsManager = VFS.getManager();
        if (fsManager == null) {
            throw Util.newError("Cannot get virtual file system manager");
        }
        if (url.startsWith("file://localhost")) {
            url = url.substring("file://localhost".length());
        }
        if (url.startsWith("file:")) {
            url = url.substring("file:".length());
        }
        if (url.startsWith("http")) {
            try {
                return new URL(url).openStream();
            }
            catch (IOException e) {
                throw Util.newError("Could not read URL: " + url);
            }
        }
        File userDir = new File("").getAbsoluteFile();
        FileContent fileContent = null;
        try (FileObject file = fsManager.resolveFile(userDir, url);){
            file.refresh();
            if (file instanceof HttpFileObject && !file.getName().getURI().equals(url)) {
                fsManager.getFilesCache().removeFile(file.getFileSystem(), file.getName());
                file = fsManager.resolveFile(userDir, url);
            }
            if (!file.isReadable()) {
                throw Util.newError("Virtual file is not readable: " + url);
            }
            fileContent = file.getContent();
        }
        if (fileContent == null) {
            throw Util.newError("Cannot get virtual file content: " + url);
        }
        return fileContent.getInputStream();
    }

    public static String readVirtualFileAsString(String catalogUrl) throws IOException {
        InputStream in = Util.readVirtualFile(catalogUrl);
        try {
            String string = IOUtils.toString((InputStream)in);
            return string;
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    public static Map<String, String> toMap(final Properties properties) {
        return new AbstractMap<String, String>(){

            @Override
            public Set<Map.Entry<String, String>> entrySet() {
                return properties.entrySet();
            }
        };
    }

    public static String replaceProperties(String text, Map<String, String> env) {
        StringBuffer buf = new StringBuffer(text.length() + 200);
        Pattern pattern = Pattern.compile("\\$\\{([^${}]+)\\}");
        Matcher matcher = pattern.matcher(text);
        while (matcher.find()) {
            String varName = matcher.group(1);
            String varValue = env.get(varName);
            if (varValue != null) {
                matcher.appendReplacement(buf, varValue);
                continue;
            }
            matcher.appendReplacement(buf, "\\${$1}");
        }
        matcher.appendTail(buf);
        return buf.toString();
    }

    public static String printMemory() {
        return Util.printMemory(null);
    }

    public static String printMemory(String msg) {
        Runtime rt = Runtime.getRuntime();
        long freeMemory = rt.freeMemory();
        long totalMemory = rt.totalMemory();
        StringBuilder buf = new StringBuilder(64);
        buf.append("FREE_MEMORY:");
        if (msg != null) {
            buf.append(msg);
            buf.append(':');
        }
        buf.append(' ');
        buf.append(freeMemory / 1024L);
        buf.append("kb ");
        long hundredths = freeMemory * 10000L / totalMemory;
        buf.append(hundredths / 100L);
        if ((hundredths %= 100L) >= 10L) {
            buf.append('.');
        } else {
            buf.append(".0");
        }
        buf.append(hundredths);
        buf.append('%');
        return buf.toString();
    }

    public static <T> Set<T> cast(Set<?> set) {
        return set;
    }

    public static <T> List<T> cast(List<?> list) {
        return list;
    }

    public static <T> boolean canCast(Collection<?> collection, Class<T> clazz) {
        for (Object o : collection) {
            if (o == null || clazz.isInstance(o)) continue;
            return false;
        }
        return true;
    }

    public static <T> Iterable<T> castToIterable(final Object iterable) {
        if (Retrowoven && !(iterable instanceof Iterable)) {
            return new Iterable<T>(){

                @Override
                public Iterator<T> iterator() {
                    return ((Collection)iterable).iterator();
                }
            };
        }
        return (Iterable)iterable;
    }

    public static <E extends Enum<E>> E lookup(Class<E> clazz, String name) {
        return Util.lookup(clazz, name, null);
    }

    public static <E extends Enum<E>> E lookup(Class<E> clazz, String name, E defaultValue) {
        if (name == null) {
            return defaultValue;
        }
        try {
            return Enum.valueOf(clazz, name);
        }
        catch (IllegalArgumentException e) {
            return defaultValue;
        }
    }

    public static BigDecimal makeBigDecimalFromDouble(double d) {
        return compatible.makeBigDecimalFromDouble(d);
    }

    public static String quotePattern(String s) {
        return compatible.quotePattern(s);
    }

    public static String generateUuidString() {
        return compatible.generateUuidString();
    }

    public static <T> T compileScript(Class<T> iface, String script, String engineName) {
        return compatible.compileScript(iface, script, engineName);
    }

    public static <T> void threadLocalRemove(ThreadLocal<T> threadLocal) {
        compatible.threadLocalRemove(threadLocal);
    }

    public static <T> Set<T> newIdentityHashSet() {
        return compatible.newIdentityHashSet();
    }

    public static UserDefinedFunction createUdf(Class<? extends UserDefinedFunction> udfClass, String functionName) {
        UserDefinedFunction udf;
        Constructor<? extends UserDefinedFunction> constructor;
        String className = udfClass.getName();
        String functionNameOrEmpty = functionName == null ? "" : functionName;
        Object[] args = new Object[]{};
        if (!Modifier.isPublic(udfClass.getModifiers()) || udfClass.getEnclosingClass() != null && !Modifier.isStatic(udfClass.getModifiers())) {
            throw MondrianResource.instance().UdfClassMustBePublicAndStatic.ex(functionName, className);
        }
        try {
            constructor = udfClass.getConstructor(String.class);
            if (Modifier.isPublic(constructor.getModifiers())) {
                args = new Object[]{functionName};
            } else {
                constructor = null;
            }
        }
        catch (NoSuchMethodException e) {
            constructor = null;
        }
        if (constructor == null) {
            try {
                constructor = udfClass.getConstructor(new Class[0]);
                if (Modifier.isPublic(constructor.getModifiers())) {
                    args = new Object[]{};
                } else {
                    constructor = null;
                }
            }
            catch (NoSuchMethodException e) {
                constructor = null;
            }
        }
        if (constructor == null) {
            throw MondrianResource.instance().UdfClassWrongIface.ex(functionNameOrEmpty, className, UserDefinedFunction.class.getName());
        }
        try {
            udf = constructor.newInstance(args);
        }
        catch (InstantiationException e) {
            throw MondrianResource.instance().UdfClassWrongIface.ex(functionNameOrEmpty, className, UserDefinedFunction.class.getName());
        }
        catch (IllegalAccessException e) {
            throw MondrianResource.instance().UdfClassWrongIface.ex(functionName, className, UserDefinedFunction.class.getName());
        }
        catch (ClassCastException e) {
            throw MondrianResource.instance().UdfClassWrongIface.ex(functionNameOrEmpty, className, UserDefinedFunction.class.getName());
        }
        catch (InvocationTargetException e) {
            throw MondrianResource.instance().UdfClassWrongIface.ex(functionName, className, UserDefinedFunction.class.getName());
        }
        return udf;
    }

    public static void checkCJResultLimit(long resultSize) {
        int resultLimit = MondrianProperties.instance().ResultLimit.get();
        if (resultLimit > 0 && (long)resultLimit < resultSize) {
            throw MondrianResource.instance().LimitExceededDuringCrossjoin.ex(resultSize, resultLimit);
        }
        if (resultSize > Integer.MAX_VALUE) {
            throw MondrianResource.instance().LimitExceededDuringCrossjoin.ex(resultSize, Integer.MAX_VALUE);
        }
    }

    public static String convertOlap4jConnectStringToNativeMondrian(String url) {
        if (url.startsWith("jdbc:mondrian:")) {
            return "Provider=Mondrian; " + url.substring("jdbc:mondrian:".length());
        }
        return null;
    }

    public static boolean isBlank(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static Role createRootRole(Schema schema) {
        RoleImpl role = new RoleImpl();
        role.grant(schema, Access.ALL);
        role.makeImmutable();
        return role;
    }

    public static Cube getDimensionCube(Dimension dimension) {
        Cube[] cubes;
        for (Cube cube : cubes = dimension.getSchema().getCubes()) {
            for (Dimension dimension1 : cube.getDimensions()) {
                if (dimension == dimension1) {
                    return cube;
                }
                if (dimension instanceof RolapCubeDimension && dimension.equals(dimension1) && !((RolapCubeDimension)dimension1).getCube().equals(cube) || !(cube instanceof RolapCube) || !((RolapCube)cube).isVirtual() || !dimension.equals(dimension1)) continue;
                return cube;
            }
        }
        return null;
    }

    public static URL getClosestResource(ClassLoader classLoader, String name) {
        URL resource = null;
        try {
            Enumeration<URL> resourceCandidates = classLoader.getResources(name);
            while (resourceCandidates.hasMoreElements()) {
                resource = resourceCandidates.nextElement();
            }
        }
        catch (IOException ioe) {
            Util.discard((Object)ioe);
        }
        return resource;
    }

    public static <T> Functor1<T, T> identityFunctor() {
        return IDENTITY_FUNCTOR;
    }

    public static <PT> Functor1<Boolean, PT> trueFunctor() {
        return TRUE_FUNCTOR;
    }

    public static <PT> Functor1<Boolean, PT> falseFunctor() {
        return FALSE_FUNCTOR;
    }

    public static <K, V> Map<K, V> toNullValuesMap(List<K> list) {
        return new NullValuesMap(list);
    }

    private static class NullValuesMap<K, V>
    extends AbstractMap<K, V> {
        private final List<K> list;

        private NullValuesMap(List<K> list) {
            this.list = Collections.unmodifiableList(list);
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return new AbstractSet<Map.Entry<K, V>>(){

                @Override
                public Iterator<Map.Entry<K, V>> iterator() {
                    return new Iterator<Map.Entry<K, V>>(){
                        private int pt = -1;

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }

                        @Override
                        public Map.Entry<K, V> next() {
                            return new AbstractMapEntry(list.get(++this.pt), null){};
                        }

                        @Override
                        public boolean hasNext() {
                            return this.pt < list.size();
                        }
                    };
                }

                @Override
                public int size() {
                    return list.size();
                }

                @Override
                public boolean contains(Object o) {
                    return o instanceof Map.Entry && list.contains(((Map.Entry)o).getKey());
                }
            };
        }

        @Override
        public Set<K> keySet() {
            return new AbstractSet<K>(){

                @Override
                public Iterator<K> iterator() {
                    return new Iterator<K>(){
                        private int pt = -1;

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }

                        @Override
                        public K next() {
                            return list.get(++this.pt);
                        }

                        @Override
                        public boolean hasNext() {
                            return this.pt < list.size();
                        }
                    };
                }

                @Override
                public int size() {
                    return list.size();
                }

                @Override
                public boolean contains(Object o) {
                    return list.contains(o);
                }
            };
        }

        @Override
        public Collection<V> values() {
            return new AbstractList<V>(){

                @Override
                public V get(int index) {
                    return null;
                }

                @Override
                public int size() {
                    return list.size();
                }

                @Override
                public boolean contains(Object o) {
                    return o == null && this.size() > 0;
                }
            };
        }

        @Override
        public V get(Object key) {
            return null;
        }

        @Override
        public boolean containsKey(Object key) {
            return this.list.contains(key);
        }

        @Override
        public boolean containsValue(Object o) {
            return o == null && this.size() > 0;
        }
    }

    public static class ByteMatcher {
        private final int[] matcher;
        public final byte[] key;

        public ByteMatcher(byte[] key) {
            this.key = key;
            this.matcher = this.compile(key);
        }

        public int match(byte[] a) {
            int j = 0;
            for (int i = 0; i < a.length; ++i) {
                while (j > 0 && this.key[j] != a[i]) {
                    j = this.matcher[j - 1];
                }
                if (a[i] == this.key[j]) {
                    ++j;
                }
                if (this.key.length != j) continue;
                return i - this.key.length + 1;
            }
            return -1;
        }

        private int[] compile(byte[] key) {
            int[] matcher = new int[key.length];
            int j = 0;
            for (int i = 1; i < key.length; ++i) {
                while (j > 0 && key[j] != key[i]) {
                    j = matcher[j - 1];
                }
                if (key[i] == key[j]) {
                    // empty if block
                }
                matcher[i] = ++j;
            }
            return matcher;
        }
    }

    public static class SqlNullSafeComparator
    implements Comparator<Comparable> {
        public static final SqlNullSafeComparator instance = new SqlNullSafeComparator();

        private SqlNullSafeComparator() {
        }

        @Override
        public int compare(Comparable o1, Comparable o2) {
            if (o1 == RolapUtil.sqlNullValue) {
                return -1;
            }
            if (o2 == RolapUtil.sqlNullValue) {
                return 1;
            }
            return o1.compareTo(o2);
        }
    }

    public static interface MemoryInfo {
        public Usage get();

        public static interface Usage {
            public long getUsed();

            public long getCommitted();

            public long getMax();
        }
    }

    public static interface Functor1<RT, PT> {
        public RT apply(PT var1);
    }

    public static class GcIterator<T>
    implements Iterator<T> {
        private final Iterator<? extends Reference<T>> iterator;
        private boolean hasNext;
        private T next;

        public GcIterator(Iterator<? extends Reference<T>> iterator) {
            this.iterator = iterator;
            this.hasNext = true;
            this.moveToNext();
        }

        public static <T2> Iterable<T2> over(final Iterable<? extends Reference<T2>> referenceIterable) {
            return new Iterable<T2>(){

                @Override
                public Iterator<T2> iterator() {
                    return new GcIterator(referenceIterable.iterator());
                }
            };
        }

        private void moveToNext() {
            while (this.iterator.hasNext()) {
                Reference<T> ref = this.iterator.next();
                this.next = ref.get();
                if (this.next != null) {
                    return;
                }
                this.iterator.remove();
            }
            this.hasNext = false;
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public T next() {
            T next1 = this.next;
            this.moveToNext();
            return next1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    protected static class Flat3List<T>
    extends AbstractFlatList<T> {
        private final T t0;
        private final T t1;
        private final T t2;

        Flat3List(T t0, T t1, T t2) {
            this.t0 = t0;
            this.t1 = t1;
            this.t2 = t2;
            assert (t0 != null);
            assert (t1 != null);
            assert (t2 != null);
        }

        public String toString() {
            return "[" + this.t0 + ", " + this.t1 + ", " + this.t2 + "]";
        }

        @Override
        public T get(int index) {
            switch (index) {
                case 0: {
                    return this.t0;
                }
                case 1: {
                    return this.t1;
                }
                case 2: {
                    return this.t2;
                }
            }
            throw new IndexOutOfBoundsException("index " + index);
        }

        @Override
        public int size() {
            return 3;
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof Flat3List) {
                Flat3List that = (Flat3List)o;
                return Util.equals(this.t0, that.t0) && Util.equals(this.t1, that.t1) && Util.equals(this.t2, that.t2);
            }
            return o.equals(this);
        }

        @Override
        public int hashCode() {
            int h = 1;
            h = h * 31 + this.t0.hashCode();
            h = h * 31 + this.t1.hashCode();
            h = h * 31 + this.t2.hashCode();
            return h;
        }

        @Override
        public int indexOf(Object o) {
            if (this.t0.equals(o)) {
                return 0;
            }
            if (this.t1.equals(o)) {
                return 1;
            }
            if (this.t2.equals(o)) {
                return 2;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object o) {
            if (this.t2.equals(o)) {
                return 2;
            }
            if (this.t1.equals(o)) {
                return 1;
            }
            if (this.t0.equals(o)) {
                return 0;
            }
            return -1;
        }

        @Override
        public <T2> T2[] toArray(T2[] a) {
            a[0] = this.t0;
            a[1] = this.t1;
            a[2] = this.t2;
            return a;
        }

        @Override
        public Object[] toArray() {
            return new Object[]{this.t0, this.t1, this.t2};
        }
    }

    protected static class Flat2List<T>
    extends AbstractFlatList<T> {
        private final T t0;
        private final T t1;

        Flat2List(T t0, T t1) {
            this.t0 = t0;
            this.t1 = t1;
            assert (t0 != null);
            assert (t1 != null);
        }

        public String toString() {
            return "[" + this.t0 + ", " + this.t1 + "]";
        }

        @Override
        public T get(int index) {
            switch (index) {
                case 0: {
                    return this.t0;
                }
                case 1: {
                    return this.t1;
                }
            }
            throw new IndexOutOfBoundsException("index " + index);
        }

        @Override
        public int size() {
            return 2;
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof Flat2List) {
                Flat2List that = (Flat2List)o;
                return Util.equals(this.t0, that.t0) && Util.equals(this.t1, that.t1);
            }
            return Arrays.asList(this.t0, this.t1).equals(o);
        }

        @Override
        public int hashCode() {
            int h = 1;
            h = h * 31 + this.t0.hashCode();
            h = h * 31 + this.t1.hashCode();
            return h;
        }

        @Override
        public int indexOf(Object o) {
            if (this.t0.equals(o)) {
                return 0;
            }
            if (this.t1.equals(o)) {
                return 1;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object o) {
            if (this.t1.equals(o)) {
                return 1;
            }
            if (this.t0.equals(o)) {
                return 0;
            }
            return -1;
        }

        @Override
        public <T2> T2[] toArray(T2[] a) {
            a[0] = this.t0;
            a[1] = this.t1;
            return a;
        }

        @Override
        public Object[] toArray() {
            return new Object[]{this.t0, this.t1};
        }
    }

    public static abstract class AbstractFlatList<T>
    implements List<T>,
    RandomAccess {
        protected final List<T> asArrayList() {
            return Arrays.asList(this.toArray());
        }

        @Override
        public Iterator<T> iterator() {
            return this.asArrayList().iterator();
        }

        @Override
        public ListIterator<T> listIterator() {
            return this.asArrayList().listIterator();
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean add(Object t) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends T> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(int index, Collection<? extends T> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public T set(int index, Object element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(int index, Object element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public T remove(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ListIterator<T> listIterator(int index) {
            return this.asArrayList().listIterator(index);
        }

        @Override
        public List<T> subList(int fromIndex, int toIndex) {
            return this.asArrayList().subList(fromIndex, toIndex);
        }

        @Override
        public boolean contains(Object o) {
            return this.indexOf(o) >= 0;
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            Iterator<?> e = c.iterator();
            while (e.hasNext()) {
                if (this.contains(e.next())) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }
    }

    private static class ConnectStringParser {
        private final String s;
        private final int n;
        private int i;
        private final StringBuilder nameBuf;
        private final StringBuilder valueBuf;

        private ConnectStringParser(String s) {
            this.s = s;
            this.i = 0;
            this.n = s.length();
            this.nameBuf = new StringBuilder(64);
            this.valueBuf = new StringBuilder(64);
        }

        PropertyList parse() {
            PropertyList list = new PropertyList();
            while (this.i < this.n) {
                this.parsePair(list);
            }
            return list;
        }

        void parsePair(PropertyList list) {
            String value;
            String name = this.parseName();
            if (name == null) {
                return;
            }
            if (this.i >= this.n) {
                value = "";
            } else if (this.s.charAt(this.i) == ';') {
                ++this.i;
                value = "";
            } else {
                value = this.parseValue();
            }
            list.put(name, value);
        }

        String parseName() {
            this.nameBuf.setLength(0);
            block4: while (true) {
                char c = this.s.charAt(this.i);
                switch (c) {
                    case '=': {
                        ++this.i;
                        if (this.i < this.n && (c = this.s.charAt(this.i)) == '=') {
                            ++this.i;
                            this.nameBuf.append(c);
                            continue block4;
                        }
                        String name = this.nameBuf.toString();
                        name = name.trim();
                        return name;
                    }
                    case ' ': {
                        if (this.nameBuf.length() != 0) break;
                        ++this.i;
                        if (this.i < this.n) continue block4;
                        return null;
                    }
                }
                this.nameBuf.append(c);
                ++this.i;
                if (this.i >= this.n) break;
            }
            return this.nameBuf.toString().trim();
        }

        String parseValue() {
            String value;
            char c;
            while ((c = this.s.charAt(this.i)) == ' ') {
                ++this.i;
                if (this.i < this.n) continue;
                return "";
            }
            if (c == '\"' || c == '\'') {
                String value2 = this.parseQuoted(c);
                while (this.i < this.n && (c = this.s.charAt(this.i)) == ' ') {
                    ++this.i;
                }
                if (this.i >= this.n) {
                    return value2;
                }
                if (this.s.charAt(this.i) == ';') {
                    ++this.i;
                    return value2;
                }
                throw new RuntimeException("quoted value ended too soon, at position " + this.i + " in '" + this.s + "'");
            }
            int semi = this.s.indexOf(59, this.i);
            if (semi >= 0) {
                value = this.s.substring(this.i, semi);
                this.i = semi + 1;
            } else {
                value = this.s.substring(this.i);
                this.i = this.n;
            }
            return value.trim();
        }

        String parseQuoted(char q) {
            char c;
            Util.assertTrue((c = this.s.charAt(this.i++)) == q);
            this.valueBuf.setLength(0);
            while (this.i < this.n) {
                c = this.s.charAt(this.i);
                if (c == q) {
                    ++this.i;
                    if (this.i < this.n && (c = this.s.charAt(this.i)) == q) {
                        this.valueBuf.append(c);
                        ++this.i;
                        continue;
                    }
                    return this.valueBuf.toString();
                }
                this.valueBuf.append(c);
                ++this.i;
            }
            throw new RuntimeException("Connect string '" + this.s + "' contains unterminated quoted value '" + this.valueBuf.toString() + "'");
        }
    }

    public static class PropertyList
    implements Iterable<Pair<String, String>>,
    Serializable {
        List<Pair<String, String>> list = new ArrayList<Pair<String, String>>();

        public PropertyList() {
            this.list = new ArrayList<Pair<String, String>>();
        }

        private PropertyList(List<Pair<String, String>> list) {
            this.list = list;
        }

        public PropertyList clone() {
            return new PropertyList(new ArrayList<Pair<String, String>>(this.list));
        }

        public String get(String key) {
            return this.get(key, null);
        }

        public String get(String key, String defaultValue) {
            int n = this.list.size();
            for (int i = 0; i < n; ++i) {
                Pair<String, String> pair = this.list.get(i);
                if (!((String)pair.left).equalsIgnoreCase(key)) continue;
                return (String)pair.right;
            }
            return defaultValue;
        }

        public String put(String key, String value) {
            int n = this.list.size();
            for (int i = 0; i < n; ++i) {
                Pair<String, String> pair = this.list.get(i);
                if (!((String)pair.left).equalsIgnoreCase(key)) continue;
                String old = (String)pair.right;
                if (!key.equalsIgnoreCase("Provider")) {
                    pair.right = value;
                }
                return old;
            }
            this.list.add(new Pair<String, String>(key, value));
            return null;
        }

        public boolean remove(String key) {
            boolean found = false;
            for (int i = 0; i < this.list.size(); ++i) {
                Pair<String, String> pair = this.list.get(i);
                if (!pair.getKey().equalsIgnoreCase(key)) continue;
                this.list.remove(i);
                found = true;
                --i;
            }
            return found;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(64);
            int n = this.list.size();
            for (int i = 0; i < n; ++i) {
                Pair<String, String> pair = this.list.get(i);
                if (i > 0) {
                    sb.append("; ");
                }
                sb.append((String)pair.left);
                sb.append('=');
                String right = (String)pair.right;
                if (right == null) {
                    sb.append("'null'");
                    continue;
                }
                int needsQuote = right.indexOf(59);
                if (needsQuote >= 0) {
                    if (right.charAt(0) != '\'') {
                        sb.append("'");
                    }
                    sb.append(Util.replace(right, "'", "''"));
                    if (right.charAt(right.length() - 1) == '\'') continue;
                    sb.append("'");
                    continue;
                }
                sb.append(right);
            }
            return sb.toString();
        }

        @Override
        public Iterator<Pair<String, String>> iterator() {
            return this.list.iterator();
        }
    }

    public static class ErrorCellValue {
        public String toString() {
            return "#ERR";
        }
    }
}

