/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.pixie.wmf;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class Buffer {
    private byte[] bytes;
    private int length;

    protected Buffer() {
    }

    protected Buffer(int length) {
        this.setCapacity(length);
    }

    public final int getLength() {
        return this.length;
    }

    protected void setLength(int len) {
        if (len > this.bytes.length) {
            throw new IllegalArgumentException();
        }
        this.length = len;
    }

    protected void setCapacity(int capacity) {
        if (capacity < this.getLength()) {
            throw new IllegalArgumentException();
        }
        if (this.bytes == null || this.bytes.length == 0) {
            this.bytes = new byte[capacity];
        } else if (capacity != this.bytes.length) {
            byte[] old = this.bytes;
            this.bytes = new byte[capacity];
            System.arraycopy(old, 0, this.bytes, 0, Math.min(old.length, capacity));
        }
    }

    public void read(InputStream in, int offset, int len) throws IOException {
        if (this.bytes == null || offset + len > this.bytes.length) {
            this.setCapacity(offset + len);
        }
        while (len > 0) {
            int blockSize = in.read(this.bytes, offset, len);
            if (blockSize <= 0) {
                throw new EOFException();
            }
            len -= blockSize;
            this.setLength(offset += blockSize);
        }
    }

    protected void move(int sourceoffset, int length, int targetoffset) {
        System.arraycopy(this.bytes, sourceoffset, this.bytes, targetoffset, length);
    }

    public void setInt(int offset, int value) {
        if (offset > this.getLength() - 4) {
            throw new IndexOutOfBoundsException();
        }
        this.setShort(offset, value & 0xFFFF);
        this.setShort(offset + 2, value >> 16);
    }

    public int getInt(int offset) {
        if (offset > this.getLength() - 4) {
            throw new IndexOutOfBoundsException();
        }
        return this.getShort(offset) & 0xFFFF | this.getShort(offset + 2) << 16;
    }

    public void setShort(int offset, int shortval) {
        if (offset > this.getLength() - 2) {
            throw new IndexOutOfBoundsException();
        }
        this.bytes[offset] = (byte)(shortval & 0xFF);
        this.bytes[offset + 1] = (byte)(shortval >> 8);
    }

    public int getShort(int offset) {
        if (offset > this.getLength() - 2) {
            throw new IndexOutOfBoundsException("Offset " + offset + " is out of limit. Max length is " + (this.getLength() - 2));
        }
        return this.bytes[offset] & 0xFF | this.bytes[offset + 1] << 8;
    }

    public void setByte(int offset, int value) {
        if (offset > this.getLength() - 1) {
            throw new IndexOutOfBoundsException();
        }
        this.bytes[offset] = (byte)(value & 0xFF);
    }

    public int getByte(int offset) {
        if (offset > this.getLength() - 1) {
            throw new IndexOutOfBoundsException();
        }
        return this.bytes[offset] & 0xFF;
    }

    public void setString(int offset, String str) {
        if (offset + str.length() > this.getLength() - 1) {
            throw new IndexOutOfBoundsException();
        }
        byte[] b = str.getBytes();
        int len = this.getLength() - offset;
        for (int i = 0; i < len; ++i) {
            this.bytes[offset + i] = b[offset];
        }
        if (offset + len < this.getLength()) {
            this.bytes[offset + len] = 0;
        }
    }

    public String getString(int offset, int len) {
        int i;
        for (i = 0; i < len && this.bytes[offset + i] != 0; ++i) {
        }
        return new String(this.bytes, offset, i);
    }

    public InputStream getInputStream(int offset) {
        return new ByteArrayInputStream(this.bytes, offset, this.bytes.length - offset);
    }
}

