/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.pixie.wmf.records;

import java.awt.Color;
import org.pentaho.reporting.libraries.pixie.wmf.GDIColor;
import org.pentaho.reporting.libraries.pixie.wmf.MfLogPen;
import org.pentaho.reporting.libraries.pixie.wmf.MfRecord;
import org.pentaho.reporting.libraries.pixie.wmf.WmfFile;
import org.pentaho.reporting.libraries.pixie.wmf.records.MfCmd;

public class MfCmdCreatePen
extends MfCmd {
    private static final int RECORD_SIZE = 4;
    private static final int POS_STYLE = 0;
    private static final int POS_WIDTH = 1;
    private static final int POS_COLOR = 2;
    private int style;
    private Color color;
    private int width;
    private int scaled_width;

    @Override
    public void replay(WmfFile file) {
        MfLogPen lpen = new MfLogPen();
        lpen.setStyle(this.getStyle());
        lpen.setColor(this.getColor());
        lpen.setWidth(this.getScaledWidth());
        file.getCurrentState().setLogPen(lpen);
        file.storeObject(lpen);
    }

    @Override
    public MfCmd getInstance() {
        return new MfCmdCreatePen();
    }

    @Override
    public int getFunction() {
        return 762;
    }

    @Override
    public MfRecord getRecord() {
        MfRecord record = new MfRecord(4);
        record.setParam(0, this.getStyle());
        record.setParam(1, this.getWidth());
        record.setLongParam(2, GDIColor.translateColor(this.getColor()));
        return record;
    }

    @Override
    public void setRecord(MfRecord record) {
        int style = record.getParam(0);
        int width = record.getParam(1);
        int color = record.getLongParam(2);
        this.setStyle(style);
        this.setWidth(width);
        this.setColor(new GDIColor(color));
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("[CREATE_PEN] style=");
        b.append(this.getStyle());
        b.append(" width=");
        b.append(this.getWidth());
        b.append(" color=");
        b.append(this.getColor());
        return b.toString();
    }

    public int getStyle() {
        return this.style;
    }

    public void setStyle(int style) {
        this.style = style;
    }

    public int getScaledWidth() {
        return this.scaled_width;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
        this.scaleXChanged();
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color c) {
        this.color = c;
    }

    @Override
    protected void scaleYChanged() {
    }

    @Override
    protected void scaleXChanged() {
        this.scaled_width = this.getScaledX(this.width);
    }
}

