/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.localization;

import java.awt.IllegalComponentStateException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.SwingCommonModule;
import org.pentaho.reporting.libraries.base.util.Messages;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class JLabelLocaleUpdateHandler
implements PropertyChangeListener {
    private String resourceBundleName;
    private String resourceKey;
    private JLabel target;
    private Messages messages;

    public JLabelLocaleUpdateHandler(JLabel target, String resourceBundleName, String resourceKey) {
        this.target = target;
        this.resourceBundleName = resourceBundleName;
        this.resourceKey = resourceKey;
        this.messages = new Messages(target.getLocale(), "org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.messages.messages", ObjectUtilities.getClassLoader(SwingCommonModule.class));
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        try {
            Locale locale = this.target.getLocale();
            ResourceBundle bundle = ResourceBundle.getBundle(this.resourceBundleName, locale);
            String string = bundle.getString(this.resourceKey);
            this.target.setText(string);
        }
        catch (IllegalComponentStateException ice) {
            this.target.setText(this.messages.getString("USER_NO_PARENT_ERROR", (Object)this.resourceKey));
        }
        catch (MissingResourceException mre) {
            this.target.setText(this.messages.getString("USER_NO_PARENT_ERROR", (Object)this.resourceKey));
            this.target.setText(this.messages.getString("USER_MISSING_RESOURCE_ERROR", (Object)this.resourceKey));
        }
    }
}

