/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.database.dialect;

import org.pentaho.database.DatabaseDialectException;
import org.pentaho.database.IValueMeta;
import org.pentaho.database.dialect.AbstractDatabaseDialect;
import org.pentaho.database.model.DatabaseAccessType;
import org.pentaho.database.model.DatabaseType;
import org.pentaho.database.model.IDatabaseConnection;
import org.pentaho.database.model.IDatabaseType;

public class GoogleBigQueryDatabaseDialect
extends AbstractDatabaseDialect {
    private static final long serialVersionUID = -3736345602216241687L;
    private static final IDatabaseType DBTYPE = new DatabaseType("Google BigQuery", "GOOGLEBIGQUERY", DatabaseAccessType.getList(DatabaseAccessType.NATIVE, DatabaseAccessType.JNDI), 443, "https://cloud.google.com/bigquery/partners/simba-drivers/");

    @Override
    public IDatabaseType getDatabaseType() {
        return DBTYPE;
    }

    @Override
    public String getNativeDriver() {
        return "com.simba.googlebigquery.jdbc42.Driver";
    }

    @Override
    public String getNativeJdbcPre() {
        return "jdbc:bigquery://";
    }

    @Override
    public String[] getUsedLibraries() {
        return new String[]{"google-api-client-1.22.0.jar", "google-api-services-bigquery-v2-rev355-1.22.0.jar", "google-http-client-1.22.0.jar", "google-http-client-jackson2-1.22.0.jar", "google-oauth-client-1.22.0.jar", "GoogleBigQueryJDBC42.jar", "jackson-core-2.1.3.jar"};
    }

    @Override
    public String getLimitClause(int nrRows) {
        return " LIMIT " + nrRows;
    }

    @Override
    public String getSQLQueryFields(String tableName) {
        return "SELECT * FROM " + tableName + " LIMIT 0";
    }

    @Override
    public String getSQLTableExists(String tablename) {
        return this.getSQLQueryFields(tablename);
    }

    @Override
    public String getSQLColumnExists(String columnname, String tablename) {
        return this.getSQLQueryColumnFields(columnname, tablename);
    }

    public String getSQLQueryColumnFields(String columnname, String tableName) {
        return "SELECT " + columnname + " FROM " + tableName + " LIMIT 0";
    }

    @Override
    public String getURL(IDatabaseConnection connection) throws DatabaseDialectException {
        return "jdbc:bigquery://" + connection.getHostname() + ":" + (GoogleBigQueryDatabaseDialect.isEmpty(connection.getDatabasePort()) ? "443" : connection.getDatabasePort()) + ";" + (GoogleBigQueryDatabaseDialect.isEmpty(connection.getDatabaseName()) ? "" : "ProjectId=" + connection.getDatabaseName()) + ";";
    }

    @Override
    public String getAddColumnStatement(String tablename, IValueMeta v, String tk, boolean use_autoinc, String pk, boolean semicolon) {
        return null;
    }

    @Override
    public String getModifyColumnStatement(String tablename, IValueMeta v, String tk, boolean use_autoinc, String pk, boolean semicolon) {
        return null;
    }

    @Override
    public String getFieldDefinition(IValueMeta v, String tk, String pk, boolean use_autoinc, boolean add_fieldname, boolean add_cr) {
        String retval = "";
        String fieldname = v.getName();
        int precision = v.getPrecision();
        if (add_fieldname) {
            retval = retval + fieldname + " ";
        }
        int type = v.getType();
        switch (type) {
            case 3: {
                retval = retval + "DATE";
                break;
            }
            case 4: {
                retval = retval + "BOOL";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                retval = precision == 0 ? retval + "INT64" : retval + "FLOAT64";
                if (!fieldname.equalsIgnoreCase(tk) && !fieldname.equalsIgnoreCase(pk)) break;
                retval = retval + " NOT NULL";
                break;
            }
            case 2: {
                retval = retval + "STRING";
                break;
            }
            case 8: {
                retval = retval + "BYTES";
                break;
            }
            default: {
                retval = retval + " UNKNOWN";
            }
        }
        if (add_cr) {
            retval = retval + " ";
        }
        return retval;
    }

    @Override
    public boolean supportsAutoInc() {
        return false;
    }

    @Override
    public boolean supportsTimeStampToDateConversion() {
        return false;
    }

    @Override
    public boolean supportsBooleanDataType() {
        return true;
    }

    @Override
    public boolean supportsBitmapIndex() {
        return false;
    }

    @Override
    public boolean supportsViews() {
        return false;
    }

    @Override
    public boolean supportsSynonyms() {
        return false;
    }

    @Override
    public boolean supportsTransactions() {
        return false;
    }

    @Override
    public boolean isRequiringTransactionsOnQueries() {
        return false;
    }

    @Override
    public String getExtraOptionSeparator() {
        return ";";
    }

    @Override
    public String getExtraOptionIndicator() {
        return "";
    }

    @Override
    public String getStartQuote() {
        return "`";
    }

    @Override
    public String getEndQuote() {
        return "`";
    }

    @Override
    public String[] getReservedWords() {
        return new String[]{"ALL", "AND", "ANY", "ARRAY", "AS", "ASC", "ASSERT_ROWS_MODIFIED", "AT", "BETWEEN", "COLLATE", "CONTAINS", "CREATE", "CROSS", "CUBE", "CURRENT", "DEFAULT", "DEFINE", "DESC", "DISTINCT", "ELSE", "END", "ENUM", "ESCAPE", "EXCEPT", "EXCLUDE", "EXISTS", "EXTRACT", "FALSE", "FETCH", "FOLLOWING", "FOR", "FROM", "FULL", "GROUP", "GROUPING", "GROUPS", "HASH", "HAVING", "IF", "IGNORE", "IN", "INNER", "INTERSECT", "INTERVAL", "INTO", "IS", "JOIN", "LATERAL", "LEFT", "LIKE", "LIMIT", "LOOKUP", "MERGE", "NATURAL", "NEW", "NO", "NOT", "NULL", "NULLS", "OF", "ON", "OR", "ORDER", "OUTER", "OVER", "PARTITION", "PRECEDING", "PROTO", "RANGE", "RECURSIVE", "RESPECT", "RIGHT", "ROLLUP", "ROWS", "SELECT", "SET", "SOME", "STRUCT", "TABLESAMPLE", "THEN", "TO", "TREAT", "TRUE", "UNBOUNDED", "UNION", "UNNEST", "USING", "WHEN", "WHERE", "WINDOW", "WITH", "WITHIN", "BY", "CASE", "CAST"};
    }
}

