/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.function;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class ExpressionCollection
implements Cloneable,
Serializable {
    private ArrayList<Expression> expressionList = new ArrayList();

    public ExpressionCollection() {
    }

    public ExpressionCollection(Collection expressions) {
        this();
        this.addAll(expressions);
    }

    public void addAll(Collection expressions) {
        if (expressions != null) {
            for (Expression f : expressions) {
                this.add(f);
            }
        }
    }

    public Expression get(String name) {
        int position = this.findExpressionByName(name);
        if (position == -1) {
            return null;
        }
        return this.getExpression(position);
    }

    private int findExpressionByName(String name) {
        for (int i = 0; i < this.expressionList.size(); ++i) {
            Expression expression = this.expressionList.get(i);
            if (!ObjectUtilities.equal((Object)name, (Object)expression.getName())) continue;
            return i;
        }
        return -1;
    }

    public void add(Expression e) {
        if (e == null) {
            throw new NullPointerException("Expression is null");
        }
        this.expressionList.add(e);
    }

    public void add(int index, Expression e) {
        if (e == null) {
            throw new NullPointerException("Expression is null");
        }
        this.expressionList.add(index, e);
    }

    public boolean removeExpression(Expression e) {
        if (e == null) {
            throw new NullPointerException();
        }
        return this.expressionList.remove(e);
    }

    public void removeExpression(int index) {
        this.expressionList.remove(index);
    }

    public int size() {
        return this.expressionList.size();
    }

    public Expression getExpression(int pos) {
        return this.expressionList.get(pos);
    }

    public int indexOf(Expression element) {
        if (element == null) {
            throw new NullPointerException();
        }
        return this.expressionList.indexOf(element);
    }

    public Expression set(int index, Expression element) {
        if (element == null) {
            throw new NullPointerException();
        }
        return this.expressionList.set(index, element);
    }

    public ExpressionCollection clone() {
        try {
            ExpressionCollection col = (ExpressionCollection)super.clone();
            col.expressionList = (ArrayList)this.expressionList.clone();
            col.expressionList.clear();
            for (Expression ex : this.expressionList) {
                col.expressionList.add(ex.getInstance());
            }
            return col;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Unable to clone an expression: ", e);
        }
    }

    public Expression[] getExpressions() {
        return this.expressionList.toArray(new Expression[this.expressionList.size()]);
    }

    public boolean contains(Expression expression) {
        if (expression == null) {
            throw new NullPointerException();
        }
        return this.expressionList.contains(expression);
    }
}

