/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.process.util;

import org.pentaho.reporting.engine.classic.core.layout.model.ParagraphRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.process.util.StackedObjectPool;
import org.pentaho.reporting.engine.classic.core.layout.process.util.StaticChunkWidthUpdate;
import org.pentaho.reporting.engine.classic.core.layout.process.util.StaticHorizontalChunkWidthUpdate;
import org.pentaho.reporting.engine.classic.core.layout.process.util.StaticInlineBoxChunkWidthUpdate;
import org.pentaho.reporting.engine.classic.core.layout.process.util.StaticParagraphChunkWidthUpdate;
import org.pentaho.reporting.engine.classic.core.layout.process.util.StaticVerticalChunkWidthUpdate;

public class StaticChunkWidthUpdatePool {
    private HorizontalPool horizontalPool = new HorizontalPool();
    private VerticalPool verticalPool = new VerticalPool();
    private InlinePool inlinePool = new InlinePool();
    private ParagraphPool paragraphPool = new ParagraphPool();

    public StaticChunkWidthUpdate createHorizontal(StaticChunkWidthUpdate parent, RenderBox box) {
        return this.horizontalPool.get(parent, box);
    }

    public StaticChunkWidthUpdate createVertical(StaticChunkWidthUpdate parent, RenderBox box) {
        return this.verticalPool.get(parent, box);
    }

    public StaticChunkWidthUpdate createInline(StaticChunkWidthUpdate parent, RenderBox box) {
        return this.inlinePool.get(parent, box);
    }

    public StaticChunkWidthUpdate createParagraph(StaticChunkWidthUpdate parent, ParagraphRenderBox box) {
        return this.paragraphPool.get(parent, box);
    }

    private static class ParagraphPool
    extends StackedObjectPool<StaticParagraphChunkWidthUpdate> {
        private ParagraphPool() {
        }

        @Override
        public StaticParagraphChunkWidthUpdate create() {
            return new StaticParagraphChunkWidthUpdate(this);
        }

        public StaticParagraphChunkWidthUpdate get(StaticChunkWidthUpdate parent, ParagraphRenderBox box) {
            StaticParagraphChunkWidthUpdate chunkWidthUpdate = (StaticParagraphChunkWidthUpdate)super.get();
            chunkWidthUpdate.reuse(parent, box);
            return chunkWidthUpdate;
        }
    }

    private static class InlinePool
    extends StackedObjectPool<StaticInlineBoxChunkWidthUpdate> {
        private InlinePool() {
        }

        @Override
        public StaticInlineBoxChunkWidthUpdate create() {
            return new StaticInlineBoxChunkWidthUpdate(this);
        }

        public StaticInlineBoxChunkWidthUpdate get(StaticChunkWidthUpdate parent, RenderBox box) {
            StaticInlineBoxChunkWidthUpdate chunkWidthUpdate = (StaticInlineBoxChunkWidthUpdate)super.get();
            chunkWidthUpdate.reuse(parent, box);
            return chunkWidthUpdate;
        }
    }

    private static class VerticalPool
    extends StackedObjectPool<StaticVerticalChunkWidthUpdate> {
        private VerticalPool() {
        }

        @Override
        public StaticVerticalChunkWidthUpdate create() {
            return new StaticVerticalChunkWidthUpdate(this);
        }

        public StaticVerticalChunkWidthUpdate get(StaticChunkWidthUpdate parent, RenderBox box) {
            StaticVerticalChunkWidthUpdate chunkWidthUpdate = (StaticVerticalChunkWidthUpdate)super.get();
            chunkWidthUpdate.reuse(parent, box);
            return chunkWidthUpdate;
        }
    }

    private static class HorizontalPool
    extends StackedObjectPool<StaticHorizontalChunkWidthUpdate> {
        private HorizontalPool() {
        }

        @Override
        public StaticHorizontalChunkWidthUpdate create() {
            return new StaticHorizontalChunkWidthUpdate(this);
        }

        public StaticHorizontalChunkWidthUpdate get(StaticChunkWidthUpdate parent, RenderBox box) {
            StaticHorizontalChunkWidthUpdate chunkWidthUpdate = (StaticHorizontalChunkWidthUpdate)super.get();
            chunkWidthUpdate.reuse(parent, box);
            return chunkWidthUpdate;
        }
    }
}

