/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.metadata.propertyeditors;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import org.pentaho.reporting.engine.classic.core.style.TextRotation;
import org.pentaho.reporting.engine.classic.core.util.beans.BeanException;
import org.pentaho.reporting.engine.classic.core.util.beans.TextRotationValueConverter;
import org.pentaho.reporting.libraries.base.util.StringUtils;

public class RotationPropertyEditor
implements PropertyEditor {
    private TextRotationValueConverter valueConverter;
    private TextRotation value;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public RotationPropertyEditor() {
        this.valueConverter = new TextRotationValueConverter();
    }

    @Override
    public void setValue(Object value) {
        TextRotation oldValue = this.value;
        this.value = TextRotation.D_90.equals(value) ? TextRotation.D_90 : (TextRotation.D_270.equals(value) ? TextRotation.D_270 : null);
        this.propertyChangeSupport.firePropertyChange(null, oldValue, this.value);
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public boolean isPaintable() {
        return false;
    }

    @Override
    public void paintValue(Graphics gfx, Rectangle box) {
    }

    @Override
    public String getJavaInitializationString() {
        if (TextRotation.D_90.equals(this.value)) {
            return TextRotation.class.getName() + ".D_90";
        }
        if (TextRotation.D_270.equals(this.value)) {
            return TextRotation.class.getName() + ".D_270";
        }
        return "null";
    }

    @Override
    public String getAsText() {
        if (this.value == null) {
            return null;
        }
        try {
            return this.valueConverter.toAttributeValue(this.value);
        }
        catch (BeanException e) {
            return null;
        }
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        if (StringUtils.isEmpty((String)text)) {
            this.setValue(null);
            return;
        }
        try {
            this.setValue(this.valueConverter.toPropertyValue(text));
        }
        catch (BeanException e) {
            throw new IllegalArgumentException("This is not a valid property-value");
        }
    }

    @Override
    public String[] getTags() {
        return new String[]{TextRotation.D_90.toString(), TextRotation.D_270.toString()};
    }

    @Override
    public Component getCustomEditor() {
        return null;
    }

    @Override
    public boolean supportsCustomEditor() {
        return false;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }
}

