/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.table.html;

import java.io.IOException;
import org.pentaho.reporting.engine.classic.core.InvalidReportStateException;
import org.pentaho.reporting.engine.classic.core.ReportAttributeMap;
import org.pentaho.reporting.engine.classic.core.layout.model.BlockRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.CanvasRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.InlineRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.ParagraphRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderableComplexText;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderableReplacedContent;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderableReplacedContentBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderableText;
import org.pentaho.reporting.engine.classic.core.layout.model.SpacerRenderNode;
import org.pentaho.reporting.engine.classic.core.layout.model.context.BoxDefinition;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.layout.process.text.RichTextSpec;
import org.pentaho.reporting.engine.classic.core.layout.text.GlyphList;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.DefaultTextExtractor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.HtmlContentGenerator;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.helper.HtmlOutputProcessingException;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.helper.HtmlTagHelper;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.helper.HtmlTextExtractorHelper;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.helper.HtmlTextExtractorState;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.helper.StyleBuilder;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.StyleSheet;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;
import org.pentaho.reporting.libraries.repository.ContentIOException;
import org.pentaho.reporting.libraries.xmlns.common.AttributeList;
import org.pentaho.reporting.libraries.xmlns.writer.CharacterEntityParser;
import org.pentaho.reporting.libraries.xmlns.writer.HtmlCharacterEntities;
import org.pentaho.reporting.libraries.xmlns.writer.XmlWriter;

public class HtmlTextExtractor
extends DefaultTextExtractor {
    private static final String DIV_TAG = "div";
    private static final String BR_TAG = "br";
    private XmlWriter xmlWriter;
    private StyleBuilder styleBuilder;
    private CharacterEntityParser characterEntityParser;
    private boolean result;
    private HtmlTextExtractorState processStack;
    private HtmlTextExtractorHelper textExtractorHelper;

    public HtmlTextExtractor(OutputProcessorMetaData metaData, XmlWriter xmlWriter, HtmlContentGenerator contentGenerator, HtmlTagHelper tagHelper) {
        super(metaData);
        if (xmlWriter == null) {
            throw new NullPointerException();
        }
        if (contentGenerator == null) {
            throw new NullPointerException();
        }
        this.xmlWriter = xmlWriter;
        this.styleBuilder = tagHelper.getStyleBuilder();
        this.characterEntityParser = HtmlCharacterEntities.getEntityParser();
        this.textExtractorHelper = new HtmlTextExtractorHelper(tagHelper, xmlWriter, metaData, contentGenerator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean performOutput(RenderBox content, StyleBuilder.StyleCarrier[] cellStyle) throws IOException {
        this.styleBuilder.clear();
        this.clearText();
        this.setRawResult(null);
        this.result = false;
        this.processStack = new HtmlTextExtractorState(null, false, cellStyle);
        this.textExtractorHelper.setFirstElement(content.getInstanceId(), this.processStack);
        try {
            int nodeType = content.getNodeType();
            if (nodeType == 274) {
                this.processInitialBox((ParagraphRenderBox)content);
            } else if (nodeType == 258) {
                this.processRenderableContent((RenderableReplacedContentBox)content);
            } else {
                this.processBoxChilds(content);
            }
        }
        finally {
            this.processStack = null;
        }
        return this.result;
    }

    @Override
    protected boolean startCanvasBox(CanvasRenderBox box) {
        if (!box.getStaticBoxLayoutProperties().isVisible()) {
            return false;
        }
        return this.textExtractorHelper.startBox(box.getInstanceId(), box.getAttributes(), box.getStyleSheet(), box.getBoxDefinition(), false);
    }

    @Override
    protected void finishCanvasBox(CanvasRenderBox box) {
        if (!box.getStaticBoxLayoutProperties().isVisible()) {
            return;
        }
        this.textExtractorHelper.finishBox(box.getInstanceId(), box.getAttributes());
    }

    protected void processInitialBox(ParagraphRenderBox box) throws IOException {
        if (!box.getStaticBoxLayoutProperties().isVisible()) {
            return;
        }
        StyleSheet styleSheet = box.getStyleSheet();
        String target = (String)styleSheet.getStyleProperty(ElementStyleKeys.HREF_TARGET);
        if (target != null) {
            this.textExtractorHelper.handleLinkOnElement(styleSheet, target);
            this.processStack = new HtmlTextExtractorState(this.processStack, true);
        } else {
            this.processStack = new HtmlTextExtractorState(this.processStack, false);
        }
        if (!Boolean.TRUE.equals(box.getAttributes().getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/html", "surpress-content"))) {
            this.processParagraphChilds(box);
        }
        if (this.processStack.isWrittenTag()) {
            this.xmlWriter.writeCloseTag();
        }
        this.processStack = this.processStack.getParent();
    }

    @Override
    protected void addEmptyBreak() {
        try {
            this.xmlWriter.writeText("\u200b");
        }
        catch (IOException e) {
            throw new HtmlOutputProcessingException("Failed to perform IO", e);
        }
    }

    @Override
    protected void addSoftBreak() {
        try {
            this.xmlWriter.writeText(" ");
        }
        catch (IOException e) {
            throw new HtmlOutputProcessingException("Failed to perform IO", e);
        }
    }

    @Override
    protected void addLinebreak() {
        try {
            this.result = true;
            this.xmlWriter.writeTag("http://www.w3.org/1999/xhtml", BR_TAG, true);
        }
        catch (IOException e) {
            throw new HtmlOutputProcessingException("Failed to perform IO", e);
        }
    }

    @Override
    protected boolean startBlockBox(BlockRenderBox box) {
        if (!box.getStaticBoxLayoutProperties().isVisible()) {
            return false;
        }
        return this.textExtractorHelper.startBox(box.getInstanceId(), box.getAttributes(), box.getStyleSheet(), box.getBoxDefinition(), true);
    }

    @Override
    protected void finishBlockBox(BlockRenderBox box) {
        if (!box.getStaticBoxLayoutProperties().isVisible()) {
            return;
        }
        this.textExtractorHelper.finishBox(box.getInstanceId(), box.getAttributes());
    }

    @Override
    protected boolean startRowBox(RenderBox box) {
        if (!box.getStaticBoxLayoutProperties().isVisible()) {
            return false;
        }
        return this.textExtractorHelper.startBox(box.getInstanceId(), box.getAttributes(), box.getStyleSheet(), box.getBoxDefinition(), true);
    }

    @Override
    protected void finishRowBox(RenderBox box) {
        if (!box.getStaticBoxLayoutProperties().isVisible()) {
            return;
        }
        this.textExtractorHelper.finishBox(box.getInstanceId(), box.getAttributes());
    }

    @Override
    protected boolean startInlineBox(InlineRenderBox box) {
        if (!box.getStaticBoxLayoutProperties().isVisible()) {
            return false;
        }
        return this.textExtractorHelper.startInlineBox(box.getInstanceId(), box.getAttributes(), box.getStyleSheet(), box.getBoxDefinition());
    }

    @Override
    protected void finishInlineBox(InlineRenderBox box) {
        if (!box.getStaticBoxLayoutProperties().isVisible()) {
            return;
        }
        this.textExtractorHelper.finishBox(box.getInstanceId(), box.getAttributes());
    }

    @Override
    protected void processOtherNode(RenderNode node) {
        try {
            int nodeType = node.getNodeType();
            if (nodeType == 17 || nodeType == 273) {
                super.processOtherNode(node);
                return;
            }
            if (node.isVirtualNode()) {
                return;
            }
            if (nodeType == 65) {
                SpacerRenderNode spacer = (SpacerRenderNode)node;
                int count = Math.max(1, spacer.getSpaceCount());
                for (int i = 0; i < count; ++i) {
                    this.xmlWriter.writeText(" ");
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed", e);
        }
    }

    @Override
    protected void processRenderableContent(RenderableReplacedContentBox node) {
        try {
            ReportAttributeMap<Object> map = node.getAttributes();
            AttributeList attrs = new AttributeList();
            HtmlTagHelper.applyHtmlAttributes(map, attrs);
            if (!attrs.isEmpty()) {
                this.xmlWriter.writeTag("http://www.w3.org/1999/xhtml", DIV_TAG, attrs, false);
            }
            this.textExtractorHelper.writeLocalAnchor(node.getStyleSheet());
            StyleSheet styleSheet = node.getStyleSheet();
            String target = (String)styleSheet.getStyleProperty(ElementStyleKeys.HREF_TARGET);
            if (target != null) {
                this.textExtractorHelper.handleLinkOnElement(styleSheet, target);
            }
            this.processReplacedContent(node);
            if (target != null) {
                this.xmlWriter.writeCloseTag();
            }
            if (!attrs.isEmpty()) {
                this.xmlWriter.writeCloseTag();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed", e);
        }
        catch (ContentIOException e) {
            throw new RuntimeException("Failed", e);
        }
    }

    private void processReplacedContent(RenderableReplacedContentBox node) throws IOException, ContentIOException {
        Object rawObject;
        RenderableReplacedContent rc = node.getContent();
        ReportAttributeMap<Object> attrs = node.getAttributes();
        long width = node.getWidth();
        long height = node.getHeight();
        long contentWidth = rc.getContentWidth();
        long contentHeight = rc.getContentHeight();
        StyleSheet styleSheet = node.getStyleSheet();
        if (this.textExtractorHelper.processRenderableReplacedContent(attrs, styleSheet, width, height, contentWidth, contentHeight, rawObject = rc.getRawObject())) {
            this.result = true;
        }
    }

    @Override
    protected void drawText(RenderableText renderableText, long contentX2) {
        try {
            if (renderableText.getLength() == 0) {
                return;
            }
            if (!renderableText.isNodeVisible(this.getParagraphBounds(), this.isOverflowX(), this.isOverflowY())) {
                return;
            }
            GlyphList gs = renderableText.getGlyphs();
            int maxLength = renderableText.computeMaximumTextSize(contentX2);
            String text = gs.getText(renderableText.getOffset(), maxLength, this.getCodePointBuffer());
            if (text.length() > 0) {
                this.xmlWriter.writeText(this.characterEntityParser.encodeEntities(text));
                if (text.trim().length() > 0) {
                    this.result = true;
                }
                this.clearText();
            }
        }
        catch (IOException ioe) {
            throw new InvalidReportStateException("Failed to write text", ioe);
        }
    }

    @Override
    protected void drawComplexText(RenderableComplexText renderableComplexText) {
        try {
            if (renderableComplexText.getRichText().isEmpty()) {
                return;
            }
            if (!renderableComplexText.isNodeVisible(this.getParagraphBounds(), this.isOverflowX(), this.isOverflowY())) {
                return;
            }
            for (RichTextSpec.StyledChunk styledChunk : renderableComplexText.getRichText().getStyleChunks()) {
                RenderNode node = styledChunk.getOriginatingTextNode();
                InstanceID dummy = node.getInstanceId();
                this.textExtractorHelper.startInlineBox(dummy, styledChunk.getOriginalAttributes(), styledChunk.getStyleSheet(), BoxDefinition.EMPTY);
                if (node instanceof RenderableReplacedContentBox) {
                    this.processRenderableContent((RenderableReplacedContentBox)node);
                    this.result = true;
                } else {
                    String text = styledChunk.getText();
                    this.xmlWriter.writeText(this.characterEntityParser.encodeEntities(text));
                    if (text.trim().length() > 0) {
                        this.result = true;
                    }
                }
                this.textExtractorHelper.finishBox(dummy, styledChunk.getOriginalAttributes());
                this.clearText();
            }
        }
        catch (IOException ioe) {
            throw new InvalidReportStateException("Failed to write text", ioe);
        }
    }
}

