/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.states;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.states.GroupSizeRecorder;
import org.pentaho.reporting.engine.classic.core.util.IntList;
import org.pentaho.reporting.libraries.base.util.FastStack;

public class DefaultGroupSizeRecorder
implements GroupSizeRecorder {
    private static final Log logger = LogFactory.getLog(DefaultGroupSizeRecorder.class);
    private Map<GroupKey, Integer> counts = new HashMap<GroupKey, Integer>();
    private FastStack<GroupKey> keys;
    private IntList groupCounts = new IntList(100);
    private int currentGroupIndex;

    public DefaultGroupSizeRecorder() {
        this.groupCounts.add(0);
        this.currentGroupIndex = -1;
        this.keys = new FastStack();
    }

    @Override
    public Object clone() {
        try {
            DefaultGroupSizeRecorder rec = (DefaultGroupSizeRecorder)super.clone();
            rec.groupCounts = (IntList)this.groupCounts.clone();
            rec.keys = this.keys.clone();
            return rec;
        }
        catch (CloneNotSupportedException cse) {
            throw new IllegalStateException(cse);
        }
    }

    @Override
    public void enterGroup() {
        ++this.currentGroupIndex;
        this.groupCounts.set(this.currentGroupIndex, this.groupCounts.get(this.currentGroupIndex) + 1);
        GroupKey key = new GroupKey(this.groupCounts.toArray(), false);
        this.keys.push((Object)key);
        this.groupCounts.add(0);
    }

    @Override
    public void enterItems() {
        ++this.currentGroupIndex;
    }

    @Override
    public void advanceItems() {
        this.groupCounts.set(this.currentGroupIndex, this.groupCounts.get(this.currentGroupIndex) + 1);
    }

    @Override
    public void leaveItems() {
        --this.currentGroupIndex;
    }

    @Override
    public void leaveGroup() {
        Integer i = this.groupCounts.pop();
        GroupKey k = (GroupKey)this.keys.pop();
        this.counts.put(k, i);
        --this.currentGroupIndex;
    }

    @Override
    public void reset() {
        this.groupCounts.clear();
        this.keys.clear();
        this.groupCounts.add(0);
        this.currentGroupIndex = -1;
    }

    public int getCurrentGroupIndex() {
        return this.currentGroupIndex;
    }

    public int[] getGroupCounts() {
        return this.groupCounts.toArray();
    }

    @Override
    public Integer getPredictedStateCount() {
        if (this.groupCounts.size() == 0) {
            logger.debug((Object)"Outside of any group: Unable to predict results");
            return null;
        }
        Integer prediction = this.counts.get(this.keys.peek());
        return prediction;
    }

    private static class GroupKey
    implements Comparable<GroupKey> {
        private int[] keys;
        private boolean itemKey;

        private GroupKey(int[] keys, boolean itemKey) {
            if (keys == null) {
                throw new NullPointerException();
            }
            this.itemKey = itemKey;
            this.keys = keys;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("GroupKey");
            sb.append("{keys=");
            for (int i = 0; i < this.keys.length; ++i) {
                sb.append(i == 0 ? "" : ", ");
                sb.append(this.keys[i]);
            }
            sb.append('}');
            return sb.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GroupKey groupKey = (GroupKey)o;
            if (this.itemKey != groupKey.itemKey) {
                return false;
            }
            return Arrays.equals(this.keys, groupKey.keys);
        }

        public int hashCode() {
            int hashCode = this.itemKey ? 1 : 0;
            hashCode = hashCode * 31 + Arrays.hashCode(this.keys);
            return hashCode;
        }

        @Override
        public int compareTo(GroupKey o) {
            return -this.toString().compareTo(o.toString());
        }
    }
}

