/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.database;

import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.BaseDatabaseMeta;
import org.pentaho.di.core.database.DatabaseInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.util.StringUtil;
import org.pentaho.di.i18n.BaseMessages;

public class GoogleBigQueryDatabaseMeta
extends BaseDatabaseMeta
implements DatabaseInterface {
    private static Class<?> PKG = GoogleBigQueryDatabaseMeta.class;

    @Override
    public int[] getAccessTypeList() {
        return new int[]{0, 4};
    }

    @Override
    public String[] getUsedLibraries() {
        return new String[]{"google-api-client-1.22.0.jar", "google-api-services-bigquery-v2-rev355-1.22.0.jar", "google-http-client-1.22.0.jar", "google-http-client-jackson2-1.22.0.jar", "google-oauth-client-1.22.0.jar", "GoogleBigQueryJDBC42.jar", "jackson-core-2.1.3.jar"};
    }

    @Override
    public String getDriverClass() {
        return "com.simba.googlebigquery.jdbc42.Driver";
    }

    @Override
    public String getURL(String hostname, String port, String databaseName) {
        return "jdbc:bigquery://" + hostname + ":" + (StringUtil.isEmpty(port) ? "443" : port) + ";" + (StringUtil.isEmpty(databaseName) ? "" : "ProjectId=" + databaseName) + ";";
    }

    @Override
    public String getExtraOptionsHelpText() {
        return "https://cloud.google.com/bigquery/partners/simba-drivers/";
    }

    @Override
    public String getFieldDefinition(ValueMetaInterface v, String tk, String pk, boolean useAutoinc, boolean addFieldName, boolean addCr) {
        String retval = "";
        String fieldname = v.getName();
        int precision = v.getPrecision();
        if (addFieldName) {
            retval = retval + fieldname + " ";
        }
        int type = v.getType();
        switch (type) {
            case 9: {
                retval = retval + "TIMESTAMP";
                break;
            }
            case 3: {
                retval = retval + "DATE";
                break;
            }
            case 4: {
                retval = retval + "BOOL";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                retval = precision == 0 ? retval + "INT64" : retval + "FLOAT64";
                if (!fieldname.equalsIgnoreCase(tk) && !fieldname.equalsIgnoreCase(pk)) break;
                retval = retval + " NOT NULL";
                break;
            }
            case 2: {
                retval = retval + "STRING";
                break;
            }
            case 8: {
                retval = retval + "BYTES";
                break;
            }
            default: {
                retval = retval + " UNKNOWN";
            }
        }
        if (addCr) {
            retval = retval + Const.CR;
        }
        return retval;
    }

    @Override
    public String getAddColumnStatement(String tablename, ValueMetaInterface v, String tk, boolean useAutoinc, String pk, boolean semicolon) {
        return null;
    }

    @Override
    public String getModifyColumnStatement(String tablename, ValueMetaInterface v, String tk, boolean useAutoinc, String pk, boolean semicolon) {
        return null;
    }

    @Override
    public String getLimitClause(int nrRows) {
        return " LIMIT " + nrRows;
    }

    @Override
    public String getSQLQueryFields(String tableName) {
        return "SELECT * FROM " + tableName + " LIMIT 0";
    }

    @Override
    public String getSQLTableExists(String tablename) {
        return this.getSQLQueryFields(tablename);
    }

    @Override
    public String getSQLColumnExists(String columnname, String tablename) {
        return this.getSQLQueryColumnFields(columnname, tablename);
    }

    public String getSQLQueryColumnFields(String columnname, String tableName) {
        return "SELECT " + columnname + " FROM " + tableName + " LIMIT 0";
    }

    @Override
    public boolean supportsAutoInc() {
        return false;
    }

    @Override
    public boolean supportsAutoGeneratedKeys() {
        return false;
    }

    @Override
    public boolean supportsTimeStampToDateConversion() {
        return false;
    }

    @Override
    public boolean supportsBooleanDataType() {
        return true;
    }

    @Override
    public boolean isRequiringTransactionsOnQueries() {
        return false;
    }

    @Override
    public String getExtraOptionSeparator() {
        return ";";
    }

    @Override
    public String getExtraOptionIndicator() {
        return "";
    }

    @Override
    public String getStartQuote() {
        return "`";
    }

    @Override
    public String getEndQuote() {
        return "`";
    }

    @Override
    public boolean supportsBitmapIndex() {
        return false;
    }

    @Override
    public boolean supportsViews() {
        return true;
    }

    @Override
    public boolean supportsSynonyms() {
        return false;
    }

    @Override
    public String[] getReservedWords() {
        return new String[]{"ALL", "AND", "ANY", "ARRAY", "AS", "ASC", "ASSERT_ROWS_MODIFIED", "AT", "BETWEEN", "COLLATE", "CONTAINS", "CREATE", "CROSS", "CUBE", "CURRENT", "DEFAULT", "DEFINE", "DESC", "DISTINCT", "ELSE", "END", "ENUM", "ESCAPE", "EXCEPT", "EXCLUDE", "EXISTS", "EXTRACT", "FALSE", "FETCH", "FOLLOWING", "FOR", "FROM", "FULL", "GROUP", "GROUPING", "GROUPS", "HASH", "HAVING", "IF", "IGNORE", "IN", "INNER", "INTERSECT", "INTERVAL", "INTO", "IS", "JOIN", "LATERAL", "LEFT", "LIKE", "LIMIT", "LOOKUP", "MERGE", "NATURAL", "NEW", "NO", "NOT", "NULL", "NULLS", "OF", "ON", "OR", "ORDER", "OUTER", "OVER", "PARTITION", "PRECEDING", "PROTO", "RANGE", "RECURSIVE", "RESPECT", "RIGHT", "ROLLUP", "ROWS", "SELECT", "SET", "SOME", "STRUCT", "TABLESAMPLE", "THEN", "TO", "TREAT", "TRUE", "UNBOUNDED", "UNION", "UNNEST", "USING", "WHEN", "WHERE", "WINDOW", "WITH", "WITHIN", "BY", "CASE", "CAST"};
    }

    @Override
    public boolean supportsStandardTableOutput() {
        return false;
    }

    @Override
    public String getUnsupportedTableOutputMessage() {
        return BaseMessages.getString(PKG, "GoogleBigQueryDatabaseMeta.UnsupportedTableOutputMessage", new String[0]);
    }
}

