/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.ListCalc;
import mondrian.calc.TupleList;
import mondrian.calc.impl.AbstractDoubleCalc;
import mondrian.calc.impl.ValueCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Evaluator;
import mondrian.olap.FunDef;
import mondrian.olap.Hierarchy;
import mondrian.olap.fun.AbstractAggregateFunDef;
import mondrian.olap.fun.FunUtil;
import mondrian.olap.fun.ReflectiveMultiResolver;

class StdevFunDef
extends AbstractAggregateFunDef {
    static final ReflectiveMultiResolver StdevResolver = new ReflectiveMultiResolver("Stdev", "Stdev(<Set>[, <Numeric Expression>])", "Returns the standard deviation of a numeric expression evaluated over a set (unbiased).", new String[]{"fnx", "fnxn"}, StdevFunDef.class);
    static final ReflectiveMultiResolver StddevResolver = new ReflectiveMultiResolver("Stddev", "Stddev(<Set>[, <Numeric Expression>])", "Alias for Stdev.", new String[]{"fnx", "fnxn"}, StdevFunDef.class);

    public StdevFunDef(FunDef dummyFunDef) {
        super(dummyFunDef);
    }

    @Override
    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        final ListCalc listCalc = compiler.compileList(call.getArg(0));
        final ValueCalc calc = call.getArgCount() > 1 ? compiler.compileScalar(call.getArg(1), true) : new ValueCalc(call);
        return new AbstractDoubleCalc(call, new Calc[]{listCalc, calc}){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public double evaluateDouble(Evaluator evaluator) {
                TupleList memberList = AbstractAggregateFunDef.evaluateCurrentList(listCalc, evaluator);
                int savepoint = evaluator.savepoint();
                try {
                    double stdev;
                    evaluator.setNonEmpty(false);
                    double d = stdev = ((Double)FunUtil.stdev(evaluator, memberList, calc, false)).doubleValue();
                    return d;
                }
                finally {
                    evaluator.restore(savepoint);
                }
            }

            @Override
            public boolean dependsOn(Hierarchy hierarchy) {
                return 1.anyDependsButFirst(this.getCalcs(), hierarchy);
            }
        };
    }
}

