/*
 * Decompiled with CFR 0.152.
 */
package mondrian.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import mondrian.gui.I18n;
import mondrian.gui.JdbcMetaData;
import mondrian.gui.PreferencesDialog;

public class PreferencesSchemasDialog
extends JDialog {
    PreferencesDialog preferences = null;
    JdbcMetaData jdbcMetadata = null;
    String selectedSchemaString = null;
    boolean accepted = false;
    private JButton cancelButton;
    private JButton okButton;
    private JScrollPane jScrollPane1;
    private JTable jTable1;

    public PreferencesSchemasDialog() {
        this.initComponents();
    }

    public PreferencesSchemasDialog(PreferencesDialog preferences, JdbcMetaData jdbcMetadata) {
        this.preferences = preferences;
        this.jdbcMetadata = jdbcMetadata;
        this.initComponents();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                PreferencesSchemasDialog.this.closeDialog(evt);
            }
        });
        this.jTable1.setModel(this.getSchemaTableModel());
        this.jTable1.setRowSelectionAllowed(false);
        this.jScrollPane1.setViewportView(this.jTable1);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.cancelButton.setText(this.getResourceConverter().getString("preferences.cancelButton.title", "Cancel"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PreferencesSchemasDialog.this.closeDialog(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.cancelButton, gridBagConstraints);
        this.cancelButton.setText(this.getResourceConverter().getString("preferences.okButton.title", "OK"));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PreferencesSchemasDialog.this.acceptButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.okButton, gridBagConstraints);
        this.pack();
    }

    private void acceptButtonActionPerformed(ActionEvent evt) {
        TableModel tm = this.jTable1.getModel();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < tm.getRowCount(); ++i) {
            Boolean selected = (Boolean)tm.getValueAt(i, 0);
            if (!selected.booleanValue()) continue;
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append((String)tm.getValueAt(i, 1));
        }
        this.selectedSchemaString = sb.toString();
        this.accepted = true;
        this.setVisible(false);
        this.dispose();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void closeDialog(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    public boolean isAccepted() {
        return this.accepted;
    }

    public TableModel getSchemaTableModel() {
        int i;
        List<String> allSchemaNames = this.jdbcMetadata.listAllSchemas();
        String currentSchemas = this.preferences.getDatabaseSchema();
        boolean[] selectedSchemas = new boolean[allSchemaNames.size()];
        Arrays.fill(selectedSchemas, false);
        if (currentSchemas != null && currentSchemas.trim().length() > 0) {
            String[] schemasArray = currentSchemas.trim().split("[,;]");
            block0: for (i = 0; i < schemasArray.length; ++i) {
                String enteredSchemaName = schemasArray[i].trim();
                if (enteredSchemaName.length() <= 0) continue;
                for (int j = 0; j < allSchemaNames.size(); ++j) {
                    String actualSchemaName = allSchemaNames.get(j);
                    if (!actualSchemaName.equalsIgnoreCase(enteredSchemaName)) continue;
                    selectedSchemas[j] = true;
                    continue block0;
                }
            }
        }
        Object[][] table = new Object[allSchemaNames.size()][2];
        for (i = 0; i < allSchemaNames.size(); ++i) {
            table[i][0] = new Boolean(selectedSchemas[i]);
            table[i][1] = allSchemaNames.get(i);
        }
        return new DefaultTableModel(table, new String[]{"Select", "Schema"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Boolean.class, String.class};
                this.canEdit = new boolean[]{true, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        };
    }

    public I18n getResourceConverter() {
        return this.preferences.getResourceConverter();
    }
}

