/*
 * Decompiled with CFR 0.152.
 */
package mondrian.gui;

import java.awt.Component;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JTree;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreePath;
import mondrian.gui.MondrianGuiDef;
import mondrian.gui.Workbench;

public class SchemaTreeCellEditor
extends DefaultTreeCellEditor {
    private final ClassLoader myClassLoader;
    JComboBox listEditor;
    final List<CellEditorListener> listeners = new ArrayList<CellEditorListener>();

    public SchemaTreeCellEditor(Workbench workbench, JTree tree, DefaultTreeCellRenderer renderer, TreeCellEditor editor) {
        super(tree, renderer, editor);
        this.myClassLoader = this.getClass().getClassLoader();
    }

    @Override
    public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
        if (value instanceof MondrianGuiDef.RelationOrJoin) {
            String valueClass = value.getClass().getName();
            String[] simpleName = valueClass.split("[$.]", 0);
            return super.getTreeCellEditorComponent(tree, simpleName[simpleName.length - 1], isSelected, expanded, leaf, row);
        }
        return null;
    }

    @Override
    public boolean isCellEditable(EventObject event) {
        return false;
    }

    protected void fireEditingStopped() {
        ChangeEvent ce = new ChangeEvent(this);
        for (int i = this.listeners.size() - 1; i >= 0; --i) {
            this.listeners.get(i).editingStopped(ce);
        }
    }

    @Override
    public void addCellEditorListener(CellEditorListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener l) {
        this.listeners.remove(l);
    }

    public void setValueAt(JTree tree) {
        MondrianGuiDef.RelationOrJoin relationObj = null;
        String retValue = (String)this.getCellEditorValue();
        if (retValue.equals("Join")) {
            relationObj = new MondrianGuiDef.Join("", "", new MondrianGuiDef.Table("", "Table 1", "", null), "", "", new MondrianGuiDef.Table("", "Table 2", "", null));
        } else if (retValue.equals("Table")) {
            relationObj = new MondrianGuiDef.Table("", "Table", "", null);
        }
        TreePath tpath = tree.getSelectionPath();
        if (tpath != null) {
            Object value = tpath.getLastPathComponent();
            TreePath parentpath = tpath.getParentPath();
            if (parentpath != null) {
                Object parent = parentpath.getLastPathComponent();
                if (parent instanceof MondrianGuiDef.Hierarchy) {
                    ((MondrianGuiDef.Hierarchy)((Object)parent)).relation = relationObj;
                } else if (parent instanceof MondrianGuiDef.Closure) {
                    ((MondrianGuiDef.Closure)((Object)parent)).table = relationObj;
                } else if (parent instanceof MondrianGuiDef.Join) {
                    int indexOfChild = tree.getModel().getIndexOfChild(parent, value);
                    switch (indexOfChild) {
                        case 0: {
                            ((MondrianGuiDef.Join)((Object)parent)).left = relationObj;
                            break;
                        }
                        case 1: {
                            ((MondrianGuiDef.Join)((Object)parent)).right = relationObj;
                        }
                    }
                }
                tree.setSelectionPath(parentpath.pathByAddingChild((Object)relationObj));
            }
        }
    }

    @Override
    public boolean stopCellEditing() {
        this.setValueAt(this.tree);
        boolean retValue = super.stopCellEditing();
        return retValue;
    }
}

