/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.scheduler2.blockout;

import java.util.Date;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.action.IVarArgsAction;

public class BlockoutAction
implements IVarArgsAction {
    private static final Log logger = LogFactory.getLog(BlockoutAction.class);
    long duration;
    Date scheduledFireTime;

    public void execute() throws Exception {
        Date startDate = new Date();
        long effectiveDuration = this.duration - (startDate.getTime() - this.scheduledFireTime.getTime());
        if (effectiveDuration < 0L) {
            logger.warn((Object)("Blocking Scheduled for " + this.scheduledFireTime + " for " + this.duration + " milliseconds has already expired"));
        } else {
            logger.warn((Object)("Blocking Started at: " + startDate + " and will last: " + effectiveDuration + " milliseconds"));
            Thread.sleep(effectiveDuration);
            logger.warn((Object)("Blockout that started at: " + startDate + " has ended at: " + new Date()));
        }
    }

    public void setVarArgs(Map<String, Object> args) {
        if (args.containsKey("DURATION_PARAM")) {
            this.duration = ((Number)args.get("DURATION_PARAM")).longValue();
        }
        if (args.containsKey("scheduledFireTime")) {
            this.scheduledFireTime = (Date)args.get("scheduledFireTime");
        }
    }
}

