/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.scheduler2.blockout;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.pentaho.platform.api.scheduler2.ComplexJobTrigger;
import org.pentaho.platform.api.scheduler2.CronJobTrigger;
import org.pentaho.platform.api.scheduler2.IBlockoutManager;
import org.pentaho.platform.api.scheduler2.IJobTrigger;
import org.pentaho.platform.api.scheduler2.IScheduler;
import org.pentaho.platform.api.scheduler2.Job;
import org.pentaho.platform.api.scheduler2.SchedulerException;
import org.pentaho.platform.api.scheduler2.SimpleJobTrigger;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.scheduler2.quartz.QuartzJobKey;
import org.pentaho.platform.scheduler2.quartz.QuartzScheduler;
import org.quartz.Trigger;

public class BlockoutManagerUtil {
    public static boolean willFire(IJobTrigger jobTrigger, List<IJobTrigger> blockOutTriggers, IScheduler scheduler) {
        if (blockOutTriggers.isEmpty()) {
            return true;
        }
        List<Date> fireTimes = BlockoutManagerUtil.getFireTimes(jobTrigger, scheduler);
        for (IJobTrigger blockOutJobTrigger : blockOutTriggers) {
            if (!BlockoutManagerUtil.willBlockSchedule(jobTrigger, blockOutJobTrigger, scheduler)) continue;
            boolean isBlockoutComplex = BlockoutManagerUtil.isComplexTrigger(blockOutJobTrigger);
            if (!isBlockoutComplex && !BlockoutManagerUtil.isComplexTrigger(jobTrigger) && BlockoutManagerUtil.getRecurrenceInterval(blockOutJobTrigger) == BlockoutManagerUtil.getRecurrenceInterval(jobTrigger)) {
                return false;
            }
            List<Date> blockoutFireTimes = null;
            if (isBlockoutComplex) {
                blockoutFireTimes = BlockoutManagerUtil.getFireTimes(blockOutJobTrigger, scheduler);
            }
            boolean scheduleCompletelyBlocked = true;
            for (Date fireTime : fireTimes) {
                scheduleCompletelyBlocked = isBlockoutComplex ? BlockoutManagerUtil.willComplexBlockOutTriggerBlockDate(blockOutJobTrigger, blockoutFireTimes, fireTime) : BlockoutManagerUtil.willBlockDate(blockOutJobTrigger, fireTime, scheduler);
                if (scheduleCompletelyBlocked) continue;
                break;
            }
            if (!scheduleCompletelyBlocked) continue;
            return false;
        }
        return true;
    }

    public static boolean willBlockSchedule(IJobTrigger scheduleTrigger, IJobTrigger blockOutJobTrigger, IScheduler scheduler) {
        boolean isScheduleTriggerComplex = BlockoutManagerUtil.isComplexTrigger(scheduleTrigger);
        boolean isBlockOutTriggerComplex = BlockoutManagerUtil.isComplexTrigger(blockOutJobTrigger);
        if (isScheduleTriggerComplex && isBlockOutTriggerComplex) {
            return BlockoutManagerUtil.willComplexBlockOutBlockComplexScheduleTrigger(blockOutJobTrigger, scheduleTrigger, scheduler);
        }
        if (isScheduleTriggerComplex) {
            return BlockoutManagerUtil.willBlockComplexScheduleTrigger(scheduleTrigger, blockOutJobTrigger, scheduler);
        }
        if (isBlockOutTriggerComplex) {
            return BlockoutManagerUtil.willComplexBlockOutTriggerBlockSchedule(blockOutJobTrigger, scheduleTrigger, scheduler);
        }
        long blockOutRecurrence = BlockoutManagerUtil.getRecurrenceInterval(blockOutJobTrigger);
        long scheduleRecurrence = BlockoutManagerUtil.getRecurrenceInterval(scheduleTrigger);
        for (int i = 0; i < 1000; ++i) {
            double x2;
            double shiftBy = (double)((blockOutRecurrence - scheduleRecurrence) * (long)i) / (double)scheduleRecurrence;
            double x1 = (double)(blockOutJobTrigger.getStartTime().getTime() - scheduleTrigger.getStartTime().getTime()) / (double)scheduleRecurrence + shiftBy;
            if (!BlockoutManagerUtil.hasIntBetween(x1, x2 = (double)(blockOutJobTrigger.getStartTime().getTime() + blockOutJobTrigger.getDuration() - scheduleTrigger.getStartTime().getTime()) / (double)scheduleRecurrence + shiftBy)) continue;
            int xShift = (int)Math.ceil(x1 < x2 ? x1 : x2);
            long scheduleDate = scheduleTrigger.getStartTime().getTime() + scheduleRecurrence * (long)(i + xShift);
            long blockOutStartDate = blockOutJobTrigger.getStartTime().getTime() + blockOutRecurrence * (long)i;
            if (scheduleTrigger.getStartTime().getTime() > scheduleDate || scheduleTrigger.getEndTime() != null && scheduleDate > scheduleTrigger.getEndTime().getTime() || blockOutJobTrigger.getStartTime().getTime() > blockOutStartDate || blockOutJobTrigger.getEndTime() != null && blockOutStartDate > blockOutJobTrigger.getEndTime().getTime()) continue;
            return true;
        }
        return false;
    }

    private static boolean willComplexBlockOutTriggerBlockSchedule(IJobTrigger blockOutJobTrigger, IJobTrigger scheduleTrigger, IScheduler scheduler) {
        if (blockOutJobTrigger.getEndTime() != null && scheduleTrigger.getStartTime().after(blockOutJobTrigger.getEndTime()) || scheduleTrigger.getEndTime() != null && blockOutJobTrigger.getStartTime().after(scheduleTrigger.getEndTime())) {
            return false;
        }
        long duration = blockOutJobTrigger.getDuration();
        for (Date blockOutStartDate : BlockoutManagerUtil.getFireTimes(blockOutJobTrigger, scheduler)) {
            Date blockOutEndDate;
            if (!BlockoutManagerUtil.willBlockOutRangeBlockSimpleTrigger(blockOutStartDate, blockOutEndDate = new Date(blockOutStartDate.getTime() + duration), scheduleTrigger, scheduler)) continue;
            return true;
        }
        return false;
    }

    private static boolean willBlockOutRangeBlockSimpleTrigger(Date startBlockOutRange, Date endBlockOutRange, IJobTrigger scheduleTrigger, IScheduler scheduler) {
        double recurrence = BlockoutManagerUtil.getRecurrenceInterval(scheduleTrigger);
        recurrence = recurrence != 0.0 ? recurrence : 1.0;
        double x1 = (double)(startBlockOutRange.getTime() - scheduleTrigger.getStartTime().getTime()) / recurrence;
        double x2 = (double)(endBlockOutRange.getTime() - scheduleTrigger.getStartTime().getTime()) / recurrence;
        return BlockoutManagerUtil.hasPositiveIntBetween(x1, x2);
    }

    private static boolean willBlockComplexScheduleTrigger(IJobTrigger trigger, IJobTrigger blockOut, IScheduler scheduler) {
        for (Date fireTime : BlockoutManagerUtil.getFireTimes(trigger, scheduler)) {
            if (!BlockoutManagerUtil.willBlockDate(blockOut, fireTime, scheduler)) continue;
            return true;
        }
        return false;
    }

    private static boolean willComplexBlockOutBlockComplexScheduleTrigger(IJobTrigger blockOutJobTrigger, IJobTrigger jobTrigger, IScheduler scheduler) {
        List<Date> blockOutFireTimes = BlockoutManagerUtil.getFireTimes(blockOutJobTrigger, scheduler);
        int iStart = 0;
        block0: for (Date scheduleFireTime : BlockoutManagerUtil.getFireTimes(jobTrigger, scheduler)) {
            for (int i = iStart; i < blockOutFireTimes.size(); ++i) {
                Date blockOutStartDate = blockOutFireTimes.get(i);
                if (blockOutStartDate.after(scheduleFireTime)) {
                    iStart = i;
                    continue block0;
                }
                Date blockOutEndDate = new Date(blockOutStartDate.getTime() + blockOutJobTrigger.getDuration());
                if (!BlockoutManagerUtil.isDateIncludedInRangeInclusive(blockOutStartDate, blockOutEndDate, scheduleFireTime)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean willBlockDate(IJobTrigger blockOutJobTrigger, Date date, IScheduler scheduler) {
        if (date.before(blockOutJobTrigger.getStartTime()) || blockOutJobTrigger.getEndTime() != null && date.after(blockOutJobTrigger.getEndTime())) {
            return false;
        }
        if (BlockoutManagerUtil.isComplexTrigger(blockOutJobTrigger)) {
            return BlockoutManagerUtil.willComplexBlockOutTriggerBlockDate(blockOutJobTrigger, BlockoutManagerUtil.getFireTimes(blockOutJobTrigger, scheduler), date);
        }
        long blockOutRecurrenceInterval = BlockoutManagerUtil.getRecurrenceInterval(blockOutJobTrigger);
        double x1 = (double)(date.getTime() - blockOutJobTrigger.getStartTime().getTime()) / (double)blockOutRecurrenceInterval;
        double x2 = (double)(date.getTime() - (blockOutJobTrigger.getStartTime().getTime() + blockOutJobTrigger.getDuration())) / (double)blockOutRecurrenceInterval;
        return BlockoutManagerUtil.hasPositiveIntBetween(x1, x2);
    }

    private static boolean willComplexBlockOutTriggerBlockDate(IJobTrigger blockOutJobTrigger, List<Date> blockOutDates, Date date) {
        if (date.before(blockOutJobTrigger.getStartTime()) || blockOutJobTrigger.getEndTime() != null && date.after(blockOutJobTrigger.getEndTime())) {
            return false;
        }
        long blockOutDuration = blockOutJobTrigger.getDuration();
        for (Date blockOutStartDate : blockOutDates) {
            if (blockOutStartDate.after(date)) break;
            Date blockOutEndDate = new Date(blockOutStartDate.getTime() + blockOutDuration);
            if (!BlockoutManagerUtil.isDateIncludedInRangeInclusive(blockOutStartDate, blockOutEndDate, date)) continue;
            return true;
        }
        return false;
    }

    public static boolean isComplexTrigger(IJobTrigger jobTrigger) {
        return jobTrigger instanceof ComplexJobTrigger || jobTrigger instanceof CronJobTrigger;
    }

    private static long getRecurrenceInterval(IJobTrigger jobTrigger) {
        if (!BlockoutManagerUtil.isComplexTrigger(jobTrigger)) {
            return ((SimpleJobTrigger)jobTrigger).getRepeatInterval() * 1000L;
        }
        throw new RuntimeException("Can not get recurrence interval from JobTriggers which are not SimpleJobTrigger");
    }

    public static List<Date> getFireTimes(IJobTrigger jobTrigger, IScheduler scheduler) {
        int n = 1000;
        Date startDate = new Date(System.currentTimeMillis());
        Date endDate = new Date(startDate.getTime() + 4L * TIME.YEAR.time);
        if (scheduler instanceof QuartzScheduler) {
            try {
                Date nextFireTime;
                ArrayList<Date> dates = new ArrayList<Date>();
                boolean endDateIsNull = jobTrigger.getEndTime() == null;
                Trigger trigger = QuartzScheduler.createQuartzTrigger(jobTrigger, new QuartzJobKey("test", "test"));
                IBlockoutManager manager = (IBlockoutManager)PentahoSystem.get(IBlockoutManager.class, (String)"IBlockoutManager", null);
                if (manager != null) {
                    List<Job> blockouts = manager.getBlockOutJobs();
                    for (Job blockout : blockouts) {
                        if (blockout.getLastRun() == null) continue;
                        dates.add(blockout.getLastRun());
                    }
                }
                for (int i = 0; !(i >= n || (nextFireTime = trigger.getFireTimeAfter(startDate)) == null || nextFireTime.after(endDate) || !endDateIsNull && nextFireTime.after(jobTrigger.getEndTime())); ++i) {
                    dates.add(nextFireTime);
                    startDate = nextFireTime;
                }
                return dates;
            }
            catch (SchedulerException e) {
                throw new RuntimeException(e);
            }
        }
        throw new RuntimeException("Can not calculate fire times for unsupported Scheduler Type: " + scheduler.getClass().getSimpleName());
    }

    public static boolean shouldFireNow(List<IJobTrigger> blockOutJobTriggers, IScheduler scheduler) {
        Date currentTime = new Date(System.currentTimeMillis());
        for (IJobTrigger blockOutJobTrigger : blockOutJobTriggers) {
            if (!BlockoutManagerUtil.willBlockDate(blockOutJobTrigger, currentTime, scheduler)) continue;
            return false;
        }
        return true;
    }

    public static boolean isPartiallyBlocked(IJobTrigger scheduleJobTrigger, List<IJobTrigger> blockOutJobTriggers, IScheduler scheduler) {
        for (IJobTrigger blockOut : blockOutJobTriggers) {
            if (!BlockoutManagerUtil.willBlockSchedule(scheduleJobTrigger, blockOut, scheduler)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasIntBetween(double x1, double x2) {
        double ceilX = Math.ceil(x1);
        double floorX = Math.floor(x2);
        if (x1 > x2) {
            ceilX = Math.ceil(x2);
            floorX = Math.floor(x1);
        }
        return floorX - ceilX >= 0.0;
    }

    private static boolean hasPositiveIntBetween(double x1, double x2) {
        return (x1 < x2 ? x2 >= 0.0 : x1 >= 0.0) && BlockoutManagerUtil.hasIntBetween(x1, x2);
    }

    private static boolean isDateIncludedInRangeInclusive(Date dateRangeStart, Date dateRangeEnd, Date date) {
        long dateTime = date.getTime();
        return dateRangeStart.getTime() <= dateTime && dateTime <= dateRangeEnd.getTime();
    }

    public static enum TIME {
        MILLISECOND(1L),
        SECOND(TIME.MILLISECOND.time * 1000L),
        MINUTE(TIME.SECOND.time * 60L),
        HOUR(TIME.MINUTE.time * 60L),
        DAY(TIME.HOUR.time * 24L),
        WEEK(TIME.DAY.time * 7L),
        YEAR(TIME.DAY.time * 365L);

        public long time;

        private TIME(long time) {
            this.time = time;
        }
    }
}

