/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.scheduler2.quartz;

import java.io.OutputStream;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.action.IAction;
import org.pentaho.platform.api.action.IStreamingAction;
import org.pentaho.platform.api.action.IVarArgsAction;
import org.pentaho.platform.api.engine.IPluginManager;
import org.pentaho.platform.api.engine.PluginBeanException;
import org.pentaho.platform.api.repository2.unified.ISourcesStreamEvents;
import org.pentaho.platform.api.repository2.unified.IStreamListener;
import org.pentaho.platform.api.repository2.unified.IUnifiedRepository;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.api.repository2.unified.data.simple.SimpleRepositoryFileData;
import org.pentaho.platform.api.scheduler2.IBackgroundExecutionStreamProvider;
import org.pentaho.platform.api.scheduler2.IJobTrigger;
import org.pentaho.platform.api.scheduler2.IScheduler;
import org.pentaho.platform.api.scheduler2.JobTrigger;
import org.pentaho.platform.api.scheduler2.SimpleJobTrigger;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.security.SecurityHelper;
import org.pentaho.platform.engine.services.solution.ActionSequenceCompatibilityFormatter;
import org.pentaho.platform.scheduler2.blockout.BlockoutAction;
import org.pentaho.platform.scheduler2.email.Emailer;
import org.pentaho.platform.scheduler2.messsages.Messages;
import org.pentaho.platform.scheduler2.quartz.QuartzJobKey;
import org.pentaho.platform.scheduler2.quartz.QuartzScheduler;
import org.pentaho.platform.scheduler2.quartz.SchedulerOutputPathResolver;
import org.pentaho.platform.util.beans.ActionHarness;
import org.pentaho.platform.util.beans.PropertyNameFormatter;
import org.pentaho.platform.util.messages.LocaleHelper;
import org.pentaho.platform.util.web.MimeHelper;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class ActionAdapterQuartzJob
implements Job {
    static final Log log = LogFactory.getLog(ActionAdapterQuartzJob.class);
    private static final long RETRY_COUNT = 6L;
    private static final long RETRY_SLEEP_AMOUNT = 10000L;
    private String outputFilePath = null;
    private Object lock = new Object();

    protected Class<?> resolveClass(JobDataMap jobDataMap) throws PluginBeanException, JobExecutionException {
        String actionClass = jobDataMap.getString("ActionAdapterQuartzJob-ActionClass");
        String actionId = jobDataMap.getString("ActionAdapterQuartzJob-ActionId");
        Class clazz = null;
        if (StringUtils.isEmpty((String)actionId) && StringUtils.isEmpty((String)actionClass)) {
            throw new LoggingJobExecutionException(Messages.getInstance().getErrorString("ActionAdapterQuartzJob.ERROR_0001_REQUIRED_PARAM_MISSING", new Object[]{"ActionAdapterQuartzJob-ActionClass", "ActionAdapterQuartzJob-ActionId"}));
        }
        int i = 0;
        while ((long)i < 6L) {
            try {
                if (!StringUtils.isEmpty((String)actionId)) {
                    IPluginManager pluginManager = (IPluginManager)PentahoSystem.get(IPluginManager.class);
                    clazz = pluginManager.loadClass(actionId);
                    return clazz;
                }
                if (!StringUtils.isEmpty((String)actionClass)) {
                    clazz = Class.forName(actionClass);
                    return clazz;
                }
            }
            catch (Throwable t) {
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ie) {
                    log.info((Object)ie.getMessage(), (Throwable)ie);
                }
            }
            ++i;
        }
        throw new LoggingJobExecutionException(Messages.getInstance().getErrorString("ActionAdapterQuartzJob.ERROR_0002_FAILED_TO_CREATE_ACTION", new Object[]{StringUtils.isEmpty((String)actionId) ? actionClass : actionId}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobExecutionContext context) throws JobExecutionException {
        Object bean;
        JobDataMap jobDataMap = context.getMergedJobDataMap();
        String actionUser = jobDataMap.getString("ActionAdapterQuartzJob-ActionUser");
        Class<?> actionClass = null;
        try {
            actionClass = this.resolveClass(jobDataMap);
            bean = actionClass.newInstance();
        }
        catch (Exception e) {
            throw new LoggingJobExecutionException(Messages.getInstance().getErrorString("ActionAdapterQuartzJob.ERROR_0002_FAILED_TO_CREATE_ACTION", new Object[]{actionClass == null ? "unknown" : actionClass.getName()}), e);
        }
        if (!(bean instanceof IAction)) {
            throw new LoggingJobExecutionException(Messages.getInstance().getErrorString("ActionAdapterQuartzJob.ERROR_0003_ACTION_WRONG_TYPE", new Object[]{actionClass.getName(), IAction.class.getName()}));
        }
        IAction actionBean = (IAction)bean;
        try {
            this.invokeAction(actionBean, actionUser, context, jobDataMap.getWrappedMap());
        }
        catch (Throwable t) {
            Object object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
            throw new LoggingJobExecutionException(Messages.getInstance().getErrorString("ActionAdapterQuartzJob.ERROR_0004_ACTION_FAILED", new Object[]{actionBean.getClass().getName()}), t);
        }
    }

    protected void invokeAction(final IAction actionBean, final String actionUser, final JobExecutionContext context, final Map<String, Serializable> params) throws Exception {
        final IScheduler scheduler = (IScheduler)PentahoSystem.getObjectFactory().get(IScheduler.class, "IScheduler2", null);
        final HashMap<String, Serializable> jobParams = new HashMap<String, Serializable>(params);
        params.remove("ActionAdapterQuartzJob-ActionClass");
        params.remove("ActionAdapterQuartzJob-ActionId");
        params.remove("ActionAdapterQuartzJob-ActionUser");
        final IBackgroundExecutionStreamProvider streamProvider = (IBackgroundExecutionStreamProvider)params.get("ActionAdapterQuartzJob-StreamProvider");
        params.remove("ActionAdapterQuartzJob-StreamProvider");
        params.remove("uiPassParam");
        if (actionBean instanceof BlockoutAction) {
            params.put("scheduledFireTime", context.getScheduledFireTime());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)MessageFormat.format("Scheduling system invoking action {0} as user {1} with params [ {2} ]", actionBean.getClass().getName(), actionUser, QuartzScheduler.prettyPrintMap(params)));
        }
        Callable<Boolean> actionBeanRunner = new Callable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean call() throws Exception {
                LocaleHelper.setLocaleOverride((Locale)((Locale)params.get("user_locale")));
                ActionHarness actionHarness = new ActionHarness(actionBean);
                boolean updateJob = false;
                HashMap<String, Object> actionParams = new HashMap<String, Object>();
                actionParams.putAll(params);
                if (streamProvider != null) {
                    actionParams.put("inputStream", streamProvider.getInputStream());
                }
                actionHarness.setValues(actionParams, new PropertyNameFormatter[]{new ActionSequenceCompatibilityFormatter()});
                if (actionBean instanceof IVarArgsAction) {
                    actionParams.remove("inputStream");
                    actionParams.remove("outputStream");
                    ((IVarArgsAction)actionBean).setVarArgs(actionParams);
                }
                boolean waitForFileCreated = false;
                OutputStream stream = null;
                if (streamProvider != null) {
                    actionParams.remove("inputStream");
                    if (actionBean instanceof IStreamingAction) {
                        streamProvider.setStreamingAction((IStreamingAction)actionBean);
                    }
                    SchedulerOutputPathResolver resolver = new SchedulerOutputPathResolver(streamProvider.getOutputPath(), actionUser);
                    String outputPath = resolver.resolveOutputFilePath();
                    actionParams.put("useJcr", Boolean.TRUE);
                    actionParams.put("jcrOutputPath", outputPath.substring(0, outputPath.lastIndexOf("/")));
                    if (!outputPath.equals(streamProvider.getOutputPath())) {
                        streamProvider.setOutputFilePath(outputPath);
                        updateJob = true;
                    }
                    if ((stream = streamProvider.getOutputStream()) instanceof ISourcesStreamEvents) {
                        ((ISourcesStreamEvents)stream).addListener(new IStreamListener(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void fileCreated(String filePath) {
                                Object object = ActionAdapterQuartzJob.this.lock;
                                synchronized (object) {
                                    ActionAdapterQuartzJob.this.outputFilePath = filePath;
                                    ActionAdapterQuartzJob.this.lock.notifyAll();
                                }
                            }
                        });
                        waitForFileCreated = true;
                    }
                    actionParams.put("outputStream", stream);
                    actionParams.remove("lineage-id");
                    actionHarness.setValues(actionParams);
                }
                actionBean.execute();
                if (stream != null) {
                    IOUtils.closeQuietly(stream);
                }
                if (waitForFileCreated) {
                    Object object = ActionAdapterQuartzJob.this.lock;
                    synchronized (object) {
                        if (ActionAdapterQuartzJob.this.outputFilePath == null) {
                            ActionAdapterQuartzJob.this.lock.wait();
                        }
                    }
                    ActionAdapterQuartzJob.this.sendEmail(actionParams, params, ActionAdapterQuartzJob.this.outputFilePath);
                }
                return updateJob;
            }
        };
        boolean requiresUpdate = false;
        if (actionUser == null || actionUser.equals("system session")) {
            requiresUpdate = (Boolean)SecurityHelper.getInstance().runAsAnonymous((Callable)actionBeanRunner);
        } else {
            try {
                requiresUpdate = (Boolean)SecurityHelper.getInstance().runAsUser(actionUser, (Callable)actionBeanRunner);
            }
            catch (Throwable t) {
                Object restartFlag = jobParams.get("ActionAdapterQuartzJob-Restart");
                if (restartFlag == null) {
                    final SimpleJobTrigger trigger = new SimpleJobTrigger(new Date(), null, 0, 0L);
                    final Class<?> iaction = actionBean.getClass();
                    SecurityHelper.getInstance().runAsUser(actionUser, (Callable)new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            if (streamProvider != null) {
                                streamProvider.setStreamingAction(null);
                            }
                            QuartzJobKey jobKey = QuartzJobKey.parse(context.getJobDetail().getName());
                            String jobName = jobKey.getJobName();
                            jobParams.put("ActionAdapterQuartzJob-Restart", Boolean.TRUE);
                            scheduler.createJob(jobName, iaction, (Map<String, Serializable>)jobParams, (IJobTrigger)trigger, streamProvider);
                            log.warn((Object)("New RunOnce job created for " + jobName + " -> possible startup synchronization error"));
                            return null;
                        }
                    });
                }
                log.warn((Object)"RunOnce already created, skipping");
                throw new Exception(t);
            }
        }
        scheduler.fireJobCompleted(actionBean, actionUser, params, streamProvider);
        if (requiresUpdate) {
            log.warn((Object)("Output path for job: " + context.getJobDetail().getName() + " has changed. Job requires update"));
            try {
                final JobTrigger trigger = scheduler.getJob(context.getJobDetail().getName()).getJobTrigger();
                final Class<?> iaction = actionBean.getClass();
                scheduler.removeJob(context.getJobDetail().getName());
                SecurityHelper.getInstance().runAsUser(actionUser, (Callable)new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        streamProvider.setStreamingAction(null);
                        QuartzJobKey jobKey = QuartzJobKey.parse(context.getJobDetail().getName());
                        String jobName = jobKey.getJobName();
                        org.pentaho.platform.api.scheduler2.Job j = scheduler.createJob(jobName, iaction, (Map<String, Serializable>)jobParams, trigger, streamProvider);
                        log.warn((Object)("New Job: " + j.getJobId() + " created"));
                        return null;
                    }
                });
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)MessageFormat.format("Scheduling system successfully invoked action {0} as user {1} with params [ {2} ]", actionBean.getClass().getName(), actionUser, QuartzScheduler.prettyPrintMap(params)));
        }
    }

    private void sendEmail(Map<String, Object> actionParams, Map<String, Serializable> params, String filePath) {
        try {
            String extension;
            String path;
            IUnifiedRepository repo = (IUnifiedRepository)PentahoSystem.get(IUnifiedRepository.class);
            RepositoryFile sourceFile = repo.getFile(filePath);
            Map metadata = repo.getFileMetadata(sourceFile.getId());
            String lineageId = (String)((Object)params.get("lineage-id"));
            metadata.put("lineage-id", lineageId);
            repo.setFileMetadata(sourceFile.getId(), metadata);
            SimpleRepositoryFileData data = (SimpleRepositoryFileData)repo.getDataForRead(sourceFile.getId(), SimpleRepositoryFileData.class);
            Emailer emailer = new Emailer();
            if (!emailer.setup()) {
                return;
            }
            String to = (String)actionParams.get("_SCH_EMAIL_TO");
            String cc = (String)actionParams.get("_SCH_EMAIL_CC");
            String bcc = (String)actionParams.get("_SCH_EMAIL_BCC");
            if (!(to != null && !"".equals(to) || cc != null && !"".equals(cc) || bcc != null && !"".equals(bcc))) {
                return;
            }
            emailer.setTo(to);
            emailer.setCc(cc);
            emailer.setBcc(bcc);
            emailer.setAttachment(data.getInputStream());
            emailer.setAttachmentName("attachment");
            String attachmentName = (String)actionParams.get("_SCH_EMAIL_ATTACHMENT_NAME");
            if (attachmentName != null && !"".equals(attachmentName)) {
                path = filePath;
                if (path.endsWith(".*")) {
                    path = path.replace(".*", "");
                }
                if ((extension = MimeHelper.getExtension((String)data.getMimeType())) == null) {
                    extension = ".bin";
                }
                if (!attachmentName.endsWith(extension)) {
                    emailer.setAttachmentName(attachmentName + extension);
                } else {
                    emailer.setAttachmentName(attachmentName);
                }
            } else if (data != null) {
                path = filePath;
                if (path.endsWith(".*")) {
                    path = path.replace(".*", "");
                }
                if ((extension = MimeHelper.getExtension((String)data.getMimeType())) == null) {
                    extension = ".bin";
                }
                if (!(path = path.substring(path.lastIndexOf("/") + 1, path.length())).endsWith(extension)) {
                    emailer.setAttachmentName(path + extension);
                } else {
                    emailer.setAttachmentName(path);
                }
            }
            if (data == null || data.getMimeType() == null || "".equals(data.getMimeType())) {
                emailer.setAttachmentMimeType("binary/octet-stream");
            } else {
                emailer.setAttachmentMimeType(data.getMimeType());
            }
            String subject = (String)actionParams.get("_SCH_EMAIL_SUBJECT");
            if (subject != null && !"".equals(subject)) {
                emailer.setSubject(subject);
            } else {
                emailer.setSubject("Pentaho Scheduler: " + emailer.getAttachmentName());
            }
            String message = (String)actionParams.get("_SCH_EMAIL_MESSAGE");
            if (subject != null && !"".equals(subject)) {
                emailer.setBody(message);
            }
            emailer.send();
        }
        catch (Exception e) {
            log.warn((Object)e.getMessage(), (Throwable)e);
        }
    }

    class LoggingJobExecutionException
    extends JobExecutionException {
        private static final long serialVersionUID = -4124907454208034326L;

        public LoggingJobExecutionException(String msg) {
            super(msg);
            log.error((Object)msg);
        }

        public LoggingJobExecutionException(String msg, Throwable t) {
            super(msg, t);
            log.error((Object)msg, t);
        }
    }
}

