/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.scheduler2.quartz;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.scheduler2.IBlockoutManager;
import org.pentaho.platform.scheduler2.blockout.BlockoutAction;
import org.pentaho.platform.scheduler2.blockout.PentahoBlockoutManager;
import org.pentaho.platform.scheduler2.quartz.ActionAdapterQuartzJob;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.SchedulerException;

public class BlockingQuartzJob
implements Job {
    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        try {
            if (this.getBlockoutManager().shouldFireNow() || this.isBlockoutAction(jobExecutionContext)) {
                this.createUnderlyingJob().execute(jobExecutionContext);
            } else {
                this.getLogger().warn((Object)("Job '" + jobExecutionContext.getJobDetail().getName() + "' attempted to run during a blockout period.  This job was not executed"));
            }
        }
        catch (SchedulerException e) {
            this.getLogger().warn((Object)("Got Exception retrieving the Blockout Manager for job '" + jobExecutionContext.getJobDetail().getName() + "'. Executing the underlying job anyway"), (Throwable)e);
            this.createUnderlyingJob().execute(jobExecutionContext);
        }
    }

    IBlockoutManager getBlockoutManager() throws SchedulerException {
        return new PentahoBlockoutManager();
    }

    Job createUnderlyingJob() {
        return new ActionAdapterQuartzJob();
    }

    Log getLogger() {
        return LogFactory.getLog(BlockingQuartzJob.class);
    }

    protected boolean isBlockoutAction(JobExecutionContext ctx) {
        try {
            String actionClass = ctx.getJobDetail().getJobDataMap().getString("ActionAdapterQuartzJob-ActionClass");
            return BlockoutAction.class.getName().equals(actionClass);
        }
        catch (Throwable t) {
            this.getLogger().warn((Object)t.getMessage(), t);
            return false;
        }
    }
}

