/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.scheduler2.quartz;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.data.DBDatasourceServiceException;
import org.pentaho.platform.api.data.IDBDatasourceService;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPentahoSystemListener;
import org.pentaho.platform.api.engine.ObjectFactoryException;
import org.pentaho.platform.api.scheduler2.IScheduler;
import org.pentaho.platform.api.scheduler2.SchedulerException;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.connection.datasource.dbcp.JndiDatasourceService;
import org.pentaho.platform.scheduler2.messsages.Messages;
import org.pentaho.platform.scheduler2.quartz.QuartzScheduler;
import org.quartz.SchedulerFactory;
import org.quartz.impl.StdSchedulerFactory;

public class EmbeddedQuartzSystemListener
implements IPentahoSystemListener {
    private static final String DEFAULT_QUARTZ_PROPERTIES_FILE = "quartz/quartz.properties";
    Properties quartzProperties;
    String quartzPropertiesFile = "quartz/quartz.properties";
    private static final Log logger = LogFactory.getLog(EmbeddedQuartzSystemListener.class);
    private static boolean useNewDatasourceService = false;

    public synchronized void setUseNewDatasourceService(boolean useNewService) {
        useNewDatasourceService = useNewService;
    }

    public boolean startup(IPentahoSession session) {
        boolean result = true;
        Properties quartzProps = null;
        if (this.quartzPropertiesFile != null) {
            quartzProps = PentahoSystem.getSystemSettings().getSystemSettingsProperties(this.quartzPropertiesFile);
        } else if (this.quartzProperties != null) {
            quartzProps = this.quartzProperties;
        }
        try {
            if (quartzProps == null) {
                quartzProps = this.findPropertiesInClasspath();
            }
            if (quartzProps == null) {
                result = false;
            } else {
                String dsName = quartzProps.getProperty("org.quartz.dataSource.myDS.jndiURL");
                if (dsName != null) {
                    IDBDatasourceService datasourceService = this.getQuartzDatasourceService(session);
                    String boundDsName = datasourceService.getDSBoundName(dsName);
                    if (boundDsName != null) {
                        quartzProps.setProperty("org.quartz.dataSource.myDS.jndiURL", boundDsName);
                    }
                    DataSource ds = datasourceService.getDataSource(dsName);
                    result = this.verifyQuartzIsConfigured(ds);
                }
                QuartzScheduler scheduler = (QuartzScheduler)PentahoSystem.get(IScheduler.class, (String)"IScheduler2", null);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Quartz configured with properties");
                    quartzProps.store(System.out, "debugging");
                }
                scheduler.setQuartzSchedulerFactory((SchedulerFactory)new StdSchedulerFactory(quartzProps));
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)scheduler.getQuartzScheduler().getSchedulerName());
                }
                scheduler.start();
            }
        }
        catch (IOException ex) {
            result = false;
            logger.error((Object)Messages.getInstance().getErrorString("EmbeddedQuartzSystemListener.ERROR_0004_LOAD_PROPERTIES_FROM_CLASSPATH"), (Throwable)ex);
        }
        catch (ObjectFactoryException objface) {
            logger.error((Object)Messages.getInstance().getErrorString("EmbeddedQuartzSystemListener.ERROR_0005_UNABLE_TO_INSTANTIATE_OBJECT", new Object[]{EmbeddedQuartzSystemListener.class.getName()}), (Throwable)objface);
            result = false;
        }
        catch (DBDatasourceServiceException dse) {
            logger.error((Object)Messages.getInstance().getErrorString("EmbeddedQuartzSystemListener.ERROR_0006_UNABLE_TO_GET_DATASOURCE", new Object[]{EmbeddedQuartzSystemListener.class.getName()}), (Throwable)dse);
            result = false;
        }
        catch (SQLException sqle) {
            logger.error((Object)"EmbeddedQuartzSystemListener.ERROR_0007_SQLERROR", (Throwable)sqle);
            result = false;
        }
        catch (org.quartz.SchedulerException e) {
            logger.error((Object)Messages.getInstance().getErrorString("EmbeddedQuartzSystemListener.ERROR_0001_Scheduler_Not_Initialized", new Object[]{EmbeddedQuartzSystemListener.class.getName()}), (Throwable)e);
            result = false;
        }
        catch (SchedulerException e) {
            logger.error((Object)Messages.getInstance().getErrorString("EmbeddedQuartzSystemListener.ERROR_0001_Scheduler_Not_Initialized", new Object[]{EmbeddedQuartzSystemListener.class.getName()}), (Throwable)e);
            result = false;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean verifyQuartzIsConfigured(DataSource ds) throws SQLException {
        boolean quartzIsConfigured = false;
        Connection conn = ds.getConnection();
        try {
            String quartzInitializationScriptPath;
            File f;
            ResultSet rs = conn.getMetaData().getTables(null, null, "%QRTZ%", null);
            try {
                quartzIsConfigured = rs.next();
            }
            finally {
                rs.close();
            }
            if (!quartzIsConfigured && (f = new File(quartzInitializationScriptPath = PentahoSystem.getApplicationContext().getSolutionPath("system/quartz/h2-quartz-schema-updated.sql").replace('\\', '/'))).exists()) {
                Statement stmt = conn.createStatement();
                stmt.executeUpdate("RUNSCRIPT FROM '" + quartzInitializationScriptPath + "'");
                quartzIsConfigured = true;
                stmt.close();
            }
        }
        finally {
            conn.close();
        }
        return quartzIsConfigured;
    }

    private IDBDatasourceService getQuartzDatasourceService(IPentahoSession session) throws ObjectFactoryException {
        if (!useNewDatasourceService) {
            return new JndiDatasourceService();
        }
        IDBDatasourceService datasourceService = (IDBDatasourceService)PentahoSystem.getObjectFactory().get(IDBDatasourceService.class, session);
        return datasourceService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties findPropertiesInClasspath() throws IOException {
        File propFile = new File("quartz.properties");
        if (!propFile.canRead()) {
            InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream("quartz.properties");
            if (in != null) {
                try {
                    Properties props = new Properties();
                    props.load(in);
                    Properties properties = props;
                    return properties;
                }
                finally {
                    in.close();
                }
            }
            return null;
        }
        BufferedInputStream iStream = new BufferedInputStream(new FileInputStream(propFile));
        try {
            Properties props = new Properties();
            props.load(iStream);
            Properties properties = props;
            return properties;
        }
        finally {
            try {
                ((InputStream)iStream).close();
            }
            catch (IOException ignored) {
                boolean ignore = true;
            }
        }
    }

    public void shutdown() {
        try {
            QuartzScheduler scheduler = (QuartzScheduler)PentahoSystem.get(IScheduler.class, (String)"IScheduler2", null);
            scheduler.getQuartzScheduler().shutdown();
        }
        catch (org.quartz.SchedulerException e) {
            e.printStackTrace();
        }
    }

    public Properties getQuartzProperties() {
        return this.quartzProperties;
    }

    public void setQuartzProperties(Properties quartzProperties) {
        this.quartzProperties = quartzProperties;
        if (quartzProperties != null) {
            this.quartzPropertiesFile = null;
        }
    }

    public String getQuartzPropertiesFile() {
        return this.quartzPropertiesFile;
    }

    public void setQuartzPropertiesFile(String quartzPropertiesFile) {
        this.quartzPropertiesFile = quartzPropertiesFile;
        if (quartzPropertiesFile != null) {
            this.quartzProperties = null;
        }
    }
}

