/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.scheduler2.quartz;

import org.pentaho.platform.api.scheduler2.ComplexJobTrigger;
import org.pentaho.platform.api.scheduler2.recur.ITimeRecurrence;
import org.pentaho.platform.api.scheduler2.wrappers.ITimeWrapper;
import org.pentaho.platform.scheduler2.recur.IncrementalRecurrence;
import org.pentaho.platform.scheduler2.recur.QualifiedDayOfMonth;
import org.pentaho.platform.scheduler2.recur.QualifiedDayOfWeek;
import org.pentaho.platform.scheduler2.recur.RecurrenceList;
import org.pentaho.platform.scheduler2.recur.SequentialRecurrence;

public class QuartzCronStringFactory {
    public static String createCronString(ComplexJobTrigger jobTrigger) {
        StringBuffer stringBuffer = new StringBuffer();
        String secondRecurrence = QuartzCronStringFactory.getRecurrenceString(jobTrigger.getSecondRecurrences(), "*");
        String minuteRecurrence = QuartzCronStringFactory.getRecurrenceString(jobTrigger.getMinuteRecurrences(), "*");
        String hourlyRecurrence = QuartzCronStringFactory.getRecurrenceString(jobTrigger.getHourlyRecurrences(), "*");
        String dayOfMonthRecurrence = QuartzCronStringFactory.getRecurrenceString(jobTrigger.getDayOfMonthRecurrences(), "*");
        String monthlyRecurrence = QuartzCronStringFactory.getRecurrenceString(jobTrigger.getMonthlyRecurrences(), "*");
        String dayOfWeekRecurrence = QuartzCronStringFactory.getRecurrenceString(jobTrigger.getDayOfWeekRecurrences(), "*");
        String yearlyRecurrence = QuartzCronStringFactory.getRecurrenceString(jobTrigger.getYearlyRecurrences(), "*");
        if (dayOfWeekRecurrence.equals("*") && dayOfMonthRecurrence.equals("*")) {
            dayOfWeekRecurrence = "?";
        } else if (!dayOfMonthRecurrence.equals("*")) {
            dayOfWeekRecurrence = "?";
        } else if (!dayOfWeekRecurrence.equals("*")) {
            dayOfMonthRecurrence = "?";
        }
        stringBuffer.append(secondRecurrence);
        stringBuffer.append(" ");
        stringBuffer.append(minuteRecurrence);
        stringBuffer.append(" ");
        stringBuffer.append(hourlyRecurrence);
        stringBuffer.append(" ");
        stringBuffer.append(dayOfMonthRecurrence);
        stringBuffer.append(" ");
        stringBuffer.append(monthlyRecurrence);
        stringBuffer.append(" ");
        stringBuffer.append(dayOfWeekRecurrence);
        stringBuffer.append(" ");
        stringBuffer.append(yearlyRecurrence);
        return stringBuffer.toString();
    }

    private static String getRecurrenceString(ITimeWrapper recurrences, String defaultString) {
        String aString = "";
        StringBuffer stringBuffer = new StringBuffer();
        for (ITimeRecurrence recurrence : recurrences.getRecurrences()) {
            if (recurrence instanceof RecurrenceList) {
                aString = QuartzCronStringFactory.getRecurrenceString((RecurrenceList)recurrence);
            } else if (recurrence instanceof SequentialRecurrence) {
                aString = QuartzCronStringFactory.getRecurrenceString((SequentialRecurrence)recurrence);
            } else if (recurrence instanceof IncrementalRecurrence) {
                aString = QuartzCronStringFactory.getRecurrenceString((IncrementalRecurrence)recurrence);
            } else if (recurrence instanceof QualifiedDayOfWeek) {
                aString = QuartzCronStringFactory.getRecurrenceString((QualifiedDayOfWeek)recurrence);
            } else if (recurrence instanceof QualifiedDayOfMonth) {
                aString = QuartzCronStringFactory.getRecurrenceString((QualifiedDayOfMonth)recurrence);
            }
            if (aString.length() <= 0) continue;
            stringBuffer.append(aString).append(",");
        }
        if (stringBuffer.length() != 0) {
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        } else {
            stringBuffer.append(defaultString);
        }
        return stringBuffer.toString();
    }

    private static String getRecurrenceString(QualifiedDayOfWeek qualifiedDayOfWeek) {
        String aString = "";
        if (qualifiedDayOfWeek.getQualifier() != null && qualifiedDayOfWeek.getDayOfWeek() != null) {
            aString = qualifiedDayOfWeek.getQualifier() == QualifiedDayOfWeek.DayOfWeekQualifier.LAST ? Integer.toString(qualifiedDayOfWeek.getDayOfWeek().ordinal() + 1) + "L" : Integer.toString(qualifiedDayOfWeek.getDayOfWeek().ordinal() + 1) + "#" + (qualifiedDayOfWeek.getQualifier().ordinal() + 1);
        }
        return aString;
    }

    private static String getRecurrenceString(QualifiedDayOfMonth qualifiedDayOfMonth) {
        return qualifiedDayOfMonth.toString();
    }

    private static String getRecurrenceString(RecurrenceList recurrenceList) {
        StringBuffer stringBuffer = new StringBuffer();
        if (recurrenceList.getValues().size() > 0) {
            for (Integer recurrence : recurrenceList.getValues()) {
                if (recurrence == null) continue;
                stringBuffer.append(recurrence.toString()).append(",");
            }
        }
        if (stringBuffer.length() != 0) {
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }

    private static String getRecurrenceString(SequentialRecurrence sequentialRecurrence) {
        String aString = "";
        if (sequentialRecurrence.getFirstValue() != null && sequentialRecurrence.getLastValue() != null) {
            aString = sequentialRecurrence.getFirstValue().toString() + "-" + sequentialRecurrence.getLastValue();
        } else if (sequentialRecurrence.getFirstValue() != null) {
            aString = sequentialRecurrence.getFirstValue().toString();
        } else if (sequentialRecurrence.getLastValue() != null) {
            aString = sequentialRecurrence.getLastValue().toString();
        }
        return aString;
    }

    private static String getRecurrenceString(IncrementalRecurrence incrementalRecurrence) {
        String aString = "";
        if (incrementalRecurrence.getStartingValue() != null && incrementalRecurrence.getIncrement() != null) {
            aString = incrementalRecurrence.getStartingValue().toString() + "/" + incrementalRecurrence.getIncrement();
        } else if (incrementalRecurrence.getStartingValue() != null) {
            aString = incrementalRecurrence.getStartingValue().toString();
        }
        return aString;
    }
}

