/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.scheduler2.quartz;

import java.text.MessageFormat;
import org.apache.commons.lang.StringUtils;
import org.pentaho.platform.api.scheduler2.SchedulerException;
import org.pentaho.platform.scheduler2.messsages.Messages;

public class QuartzJobKey {
    private String userName;
    private String jobName;
    private long timeInMillis;

    public QuartzJobKey(String jobName, String username) throws SchedulerException {
        if (StringUtils.isEmpty((String)jobName)) {
            throw new SchedulerException(Messages.getInstance().getErrorString("QuartzJobKey.ERROR_0000"));
        }
        if (StringUtils.isEmpty((String)username)) {
            throw new SchedulerException(Messages.getInstance().getErrorString("QuartzJobKey.ERROR_0001"));
        }
        this.userName = username;
        this.jobName = jobName;
        this.timeInMillis = System.currentTimeMillis();
    }

    private QuartzJobKey() {
    }

    public static QuartzJobKey parse(String jobId) throws SchedulerException {
        String delimiter = jobId.contains("\t") || jobId.isEmpty() ? "\t" : ":";
        String[] elements = jobId.split(delimiter);
        if (elements == null || elements.length < 3) {
            throw new SchedulerException(MessageFormat.format(Messages.getInstance().getErrorString("QuartzJobKey.ERROR_0002"), jobId));
        }
        QuartzJobKey key = new QuartzJobKey();
        key.userName = elements[0];
        key.jobName = elements[1];
        try {
            key.timeInMillis = Long.parseLong(elements[2]);
        }
        catch (NumberFormatException ex) {
            throw new SchedulerException(MessageFormat.format(Messages.getInstance().getErrorString("QuartzJobKey.ERROR_0002"), jobId));
        }
        return key;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getJobName() {
        return this.jobName;
    }

    public String toString() {
        return this.userName + "\t" + this.jobName + "\t" + this.timeInMillis;
    }
}

