/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.scheduler2.quartz;

import java.io.Serializable;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.action.IAction;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.scheduler2.ComplexJobTrigger;
import org.pentaho.platform.api.scheduler2.IBackgroundExecutionStreamProvider;
import org.pentaho.platform.api.scheduler2.IJobFilter;
import org.pentaho.platform.api.scheduler2.IJobResult;
import org.pentaho.platform.api.scheduler2.IJobTrigger;
import org.pentaho.platform.api.scheduler2.IScheduleSubject;
import org.pentaho.platform.api.scheduler2.IScheduler;
import org.pentaho.platform.api.scheduler2.ISchedulerListener;
import org.pentaho.platform.api.scheduler2.Job;
import org.pentaho.platform.api.scheduler2.JobTrigger;
import org.pentaho.platform.api.scheduler2.SchedulerException;
import org.pentaho.platform.api.scheduler2.SimpleJobTrigger;
import org.pentaho.platform.api.scheduler2.recur.ITimeRecurrence;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.security.SecurityHelper;
import org.pentaho.platform.scheduler2.messsages.Messages;
import org.pentaho.platform.scheduler2.quartz.BlockingQuartzJob;
import org.pentaho.platform.scheduler2.quartz.QuartzCronStringFactory;
import org.pentaho.platform.scheduler2.quartz.QuartzJobKey;
import org.pentaho.platform.scheduler2.quartz.QuartzSchedulerAvailability;
import org.pentaho.platform.scheduler2.recur.IncrementalRecurrence;
import org.pentaho.platform.scheduler2.recur.QualifiedDayOfMonth;
import org.pentaho.platform.scheduler2.recur.QualifiedDayOfWeek;
import org.pentaho.platform.scheduler2.recur.RecurrenceList;
import org.pentaho.platform.scheduler2.recur.SequentialRecurrence;
import org.quartz.Calendar;
import org.quartz.CronTrigger;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerFactory;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.impl.StdSchedulerFactory;
import org.springframework.security.Authentication;

public class QuartzScheduler
implements IScheduler {
    public static final String RESERVEDMAPKEY_ACTIONCLASS = "ActionAdapterQuartzJob-ActionClass";
    public static final String RESERVEDMAPKEY_ACTIONUSER = "ActionAdapterQuartzJob-ActionUser";
    public static final String RESERVEDMAPKEY_ACTIONID = "ActionAdapterQuartzJob-ActionId";
    public static final String RESERVEDMAPKEY_STREAMPROVIDER = "ActionAdapterQuartzJob-StreamProvider";
    public static final String RESERVEDMAPKEY_UIPASSPARAM = "uiPassParam";
    public static final String RESERVEDMAPKEY_LINEAGE_ID = "lineage-id";
    public static final String RESERVEDMAPKEY_RESTART_FLAG = "ActionAdapterQuartzJob-Restart";
    private static final Log logger = LogFactory.getLog(QuartzScheduler.class);
    private SchedulerFactory quartzSchedulerFactory;
    private Scheduler quartzScheduler;
    private ArrayList<ISchedulerListener> listeners = new ArrayList();
    private static final Pattern listPattern = Pattern.compile("\\d+");
    private static final Pattern dayOfWeekRangePattern = Pattern.compile(".*\\-.*");
    private static final Pattern sequencePattern = Pattern.compile("\\d+\\-\\d+");
    private static final Pattern intervalPattern = Pattern.compile("\\d+/\\d+");
    private static final Pattern qualifiedDayPattern = Pattern.compile("\\d+#\\d+");
    private static final Pattern lastDayPattern = Pattern.compile("\\d+L");

    public QuartzScheduler(SchedulerFactory schedulerFactory) {
        this.quartzSchedulerFactory = schedulerFactory;
    }

    public QuartzScheduler() {
        this.quartzSchedulerFactory = new StdSchedulerFactory();
    }

    public void setQuartzSchedulerFactory(SchedulerFactory quartzSchedulerFactory) throws SchedulerException {
        this.quartzSchedulerFactory = quartzSchedulerFactory;
        if (this.quartzScheduler != null) {
            this.shutdown();
            this.quartzScheduler = null;
        }
    }

    public Scheduler getQuartzScheduler() throws org.quartz.SchedulerException {
        if (this.quartzScheduler == null) {
            this.quartzScheduler = this.quartzSchedulerFactory.getScheduler();
        }
        logger.debug((Object)("Using quartz scheduler " + this.quartzScheduler));
        return this.quartzScheduler;
    }

    @Override
    public Job createJob(String jobName, String actionId, Map<String, Serializable> jobParams, IJobTrigger trigger) throws SchedulerException {
        return this.createJob(jobName, actionId, jobParams, trigger, null);
    }

    @Override
    public Job createJob(String jobName, Class<? extends IAction> action, Map<String, Serializable> jobParams, IJobTrigger trigger) throws SchedulerException {
        return this.createJob(jobName, action, jobParams, trigger, null);
    }

    @Override
    public Job createJob(String jobName, Class<? extends IAction> action, Map<String, Serializable> jobParams, IJobTrigger trigger, IBackgroundExecutionStreamProvider outputStreamProvider) throws SchedulerException {
        if (action == null) {
            throw new SchedulerException(Messages.getInstance().getString("QuartzScheduler.ERROR_0003_ACTION_IS_NULL"));
        }
        if (jobParams == null) {
            jobParams = new HashMap<String, Serializable>();
        }
        jobParams.put(RESERVEDMAPKEY_ACTIONCLASS, (Serializable)((Object)action.getName()));
        Job ret = this.createJob(jobName, jobParams, trigger, outputStreamProvider);
        ret.setSchedulableClass(action.getName());
        return ret;
    }

    @Override
    public Job createJob(String jobName, String actionId, Map<String, Serializable> jobParams, IJobTrigger trigger, IBackgroundExecutionStreamProvider outputStreamProvider) throws SchedulerException {
        if (StringUtils.isEmpty((String)actionId)) {
            throw new SchedulerException(Messages.getInstance().getString("QuartzScheduler.ERROR_0003_ACTION_IS_NULL"));
        }
        if (jobParams == null) {
            jobParams = new HashMap<String, Serializable>();
        }
        jobParams.put(RESERVEDMAPKEY_ACTIONID, (Serializable)((Object)actionId));
        Job ret = this.createJob(jobName, jobParams, trigger, outputStreamProvider);
        ret.setSchedulableClass("");
        return ret;
    }

    public static Trigger createQuartzTrigger(IJobTrigger jobTrigger, QuartzJobKey jobId) throws SchedulerException {
        CronTrigger quartzTrigger = null;
        if (jobTrigger instanceof ComplexJobTrigger) {
            try {
                quartzTrigger = new CronTrigger(jobId.toString(), jobId.getUserName(), jobTrigger.getCronString() != null ? jobTrigger.getCronString() : QuartzCronStringFactory.createCronString((ComplexJobTrigger)jobTrigger));
            }
            catch (ParseException e) {
                throw new SchedulerException(Messages.getInstance().getString("QuartzScheduler.ERROR_0001_FAILED_TO_SCHEDULE_JOB", new Object[]{jobId.getJobName()}), e);
            }
        } else if (jobTrigger instanceof SimpleJobTrigger) {
            SimpleJobTrigger simpleTrigger = (SimpleJobTrigger)jobTrigger;
            long interval = simpleTrigger.getRepeatInterval();
            if (interval > 0L) {
                interval *= 1000L;
            }
            int repeatCount = simpleTrigger.getRepeatCount() < 0 ? -1 : simpleTrigger.getRepeatCount();
            quartzTrigger = new SimpleTrigger(jobId.toString(), jobId.getUserName(), simpleTrigger.getStartTime(), simpleTrigger.getEndTime(), repeatCount, interval);
        } else {
            throw new SchedulerException(Messages.getInstance().getString("QuartzScheduler.ERROR_0002_TRIGGER_WRONG_TYPE"));
        }
        if (quartzTrigger instanceof SimpleTrigger) {
            quartzTrigger.setMisfireInstruction(4);
        } else {
            quartzTrigger.setMisfireInstruction(1);
        }
        return quartzTrigger;
    }

    private JobDetail createJobDetails(QuartzJobKey jobId, Map<String, Serializable> jobParams) {
        JobDetail jobDetail = new JobDetail(jobId.toString(), jobId.getUserName(), BlockingQuartzJob.class);
        jobParams.put(RESERVEDMAPKEY_ACTIONUSER, (Serializable)((Object)jobId.getUserName()));
        JobDataMap jobDataMap = new JobDataMap(jobParams);
        jobDetail.setJobDataMap(jobDataMap);
        return jobDetail;
    }

    private Calendar createQuartzCalendar(ComplexJobTrigger complexJobTrigger) {
        QuartzSchedulerAvailability triggerCalendar = null;
        if (complexJobTrigger.getStartTime() != null || complexJobTrigger.getEndTime() != null) {
            triggerCalendar = new QuartzSchedulerAvailability(complexJobTrigger.getStartTime(), complexJobTrigger.getEndTime());
        }
        return triggerCalendar;
    }

    protected Job createJob(String jobName, Map<String, Serializable> jobParams, IJobTrigger trigger, IBackgroundExecutionStreamProvider outputStreamProvider) throws SchedulerException {
        Calendar triggerCalendar;
        String curUser = this.getCurrentUser();
        QuartzJobKey jobId = new QuartzJobKey(jobName, curUser);
        Trigger quartzTrigger = QuartzScheduler.createQuartzTrigger(trigger, jobId);
        Calendar calendar = triggerCalendar = quartzTrigger instanceof CronTrigger ? this.createQuartzCalendar((ComplexJobTrigger)trigger) : null;
        if (outputStreamProvider != null) {
            jobParams.put(RESERVEDMAPKEY_STREAMPROVIDER, outputStreamProvider);
        }
        if (trigger.getUiPassParam() != null) {
            jobParams.put(RESERVEDMAPKEY_UIPASSPARAM, (Serializable)((Object)trigger.getUiPassParam()));
        }
        if (!jobParams.containsKey(RESERVEDMAPKEY_LINEAGE_ID)) {
            String uuid = UUID.randomUUID().toString();
            jobParams.put(RESERVEDMAPKEY_LINEAGE_ID, (Serializable)((Object)uuid));
        }
        JobDetail jobDetail = this.createJobDetails(jobId, jobParams);
        try {
            Scheduler scheduler = this.getQuartzScheduler();
            if (triggerCalendar != null) {
                scheduler.addCalendar(jobId.toString(), triggerCalendar, false, false);
                quartzTrigger.setCalendarName(jobId.toString());
            }
            logger.debug((Object)MessageFormat.format("Scheduling job {0} with trigger {1} and job parameters [ {2} ]", jobId.toString(), trigger, QuartzScheduler.prettyPrintMap(jobParams)));
            scheduler.scheduleJob(jobDetail, quartzTrigger);
        }
        catch (org.quartz.SchedulerException e) {
            throw new SchedulerException(Messages.getInstance().getString("QuartzScheduler.ERROR_0001_FAILED_TO_SCHEDULE_JOB", new Object[]{jobName}), e);
        }
        Job job = new Job();
        job.setJobParams(jobParams);
        job.setJobTrigger((JobTrigger)trigger);
        job.setNextRun(quartzTrigger.getNextFireTime());
        job.setLastRun(quartzTrigger.getPreviousFireTime());
        job.setJobId(jobId.toString());
        job.setJobName(jobName);
        job.setUserName(curUser);
        job.setState(Job.JobState.NORMAL);
        return job;
    }

    @Override
    public void updateJob(String jobId, Map<String, Serializable> jobParams, IJobTrigger trigger) throws SchedulerException {
        QuartzJobKey jobKey = QuartzJobKey.parse(jobId);
        Trigger quartzTrigger = QuartzScheduler.createQuartzTrigger(trigger, jobKey);
        quartzTrigger.setJobName(jobId);
        quartzTrigger.setJobGroup(jobKey.getUserName());
        Calendar triggerCalendar = quartzTrigger instanceof CronTrigger ? this.createQuartzCalendar((ComplexJobTrigger)trigger) : null;
        try {
            Scheduler scheduler = this.getQuartzScheduler();
            JobDetail origJobDetail = scheduler.getJobDetail(jobId, jobKey.getUserName());
            if (origJobDetail.getJobDataMap().containsKey((Object)RESERVEDMAPKEY_ACTIONCLASS)) {
                jobParams.put(RESERVEDMAPKEY_ACTIONCLASS, (Serializable)((Object)origJobDetail.getJobDataMap().get((Object)RESERVEDMAPKEY_ACTIONCLASS).toString()));
            } else if (origJobDetail.getJobDataMap().containsKey((Object)RESERVEDMAPKEY_ACTIONID)) {
                jobParams.put(RESERVEDMAPKEY_ACTIONID, (Serializable)((Object)origJobDetail.getJobDataMap().get((Object)RESERVEDMAPKEY_ACTIONID).toString()));
            }
            if (origJobDetail.getJobDataMap().containsKey((Object)RESERVEDMAPKEY_STREAMPROVIDER)) {
                jobParams.put(RESERVEDMAPKEY_STREAMPROVIDER, (Serializable)origJobDetail.getJobDataMap().get((Object)RESERVEDMAPKEY_STREAMPROVIDER));
            }
            if (origJobDetail.getJobDataMap().containsKey((Object)RESERVEDMAPKEY_UIPASSPARAM)) {
                jobParams.put(RESERVEDMAPKEY_UIPASSPARAM, (Serializable)origJobDetail.getJobDataMap().get((Object)RESERVEDMAPKEY_STREAMPROVIDER));
            }
            JobDetail jobDetail = this.createJobDetails(jobKey, jobParams);
            scheduler.addJob(jobDetail, true);
            if (triggerCalendar != null) {
                scheduler.addCalendar(jobId.toString(), triggerCalendar, true, true);
                quartzTrigger.setCalendarName(jobId.toString());
            }
            scheduler.rescheduleJob(jobId, jobKey.getUserName(), quartzTrigger);
            logger.debug((Object)MessageFormat.format("Scheduling job {0} with trigger {1} and job parameters [ {2} ]", jobId.toString(), trigger, QuartzScheduler.prettyPrintMap(jobParams)));
        }
        catch (org.quartz.SchedulerException e) {
            throw new SchedulerException(Messages.getInstance().getString("QuartzScheduler.ERROR_0001_FAILED_TO_SCHEDULE_JOB", new Object[]{jobKey.getJobName()}), e);
        }
    }

    @Override
    public Map<IScheduleSubject, ComplexJobTrigger> getAvailabilityWindows() {
        return null;
    }

    @Override
    public List<IJobResult> getJobHistory(String jobId) {
        return null;
    }

    @Override
    public void triggerNow(String jobId) throws SchedulerException {
        try {
            QuartzJobKey jobKey = QuartzJobKey.parse(jobId);
            Scheduler scheduler = this.getQuartzScheduler();
            String groupName = jobKey.getUserName();
            for (Trigger trigger : scheduler.getTriggersOfJob(jobId, groupName)) {
                if (trigger instanceof SimpleTrigger) {
                    ((SimpleTrigger)trigger).setPreviousFireTime(new Date());
                } else if (trigger instanceof CronTrigger) {
                    ((CronTrigger)trigger).setPreviousFireTime(new Date());
                }
                scheduler.rescheduleJob(jobId, jobKey.getUserName(), trigger);
            }
            scheduler.triggerJob(jobId, jobKey.getUserName());
        }
        catch (org.quartz.SchedulerException e) {
            throw new SchedulerException(Messages.getInstance().getString("QuartzScheduler.ERROR_0007_FAILED_TO_GET_JOB", new Object[]{jobId}), e);
        }
    }

    @Override
    public Job getJob(String jobId) throws SchedulerException {
        try {
            Scheduler scheduler = this.getQuartzScheduler();
            QuartzJobKey jobKey = QuartzJobKey.parse(jobId);
            String groupName = jobKey.getUserName();
            Trigger[] arr$ = scheduler.getTriggersOfJob(jobId, groupName);
            int len$ = arr$.length;
            int i$ = 0;
            if (i$ < len$) {
                JobDataMap jobDataMap;
                Trigger trigger = arr$[i$];
                Job job = new Job();
                JobDetail jobDetail = scheduler.getJobDetail(jobId, groupName);
                if (jobDetail != null && (jobDataMap = jobDetail.getJobDataMap()) != null) {
                    Map wrappedMap = jobDataMap.getWrappedMap();
                    job.setJobParams(wrappedMap);
                }
                job.setJobId(jobId);
                this.setJobTrigger(scheduler, job, trigger);
                job.setUserName(jobDetail.getGroup());
                return job;
            }
        }
        catch (org.quartz.SchedulerException e) {
            throw new SchedulerException(Messages.getInstance().getString("QuartzScheduler.ERROR_0007_FAILED_TO_GET_JOB", new Object[]{jobId}), e);
        }
        return null;
    }

    @Override
    public List<Job> getJobs(IJobFilter filter) throws SchedulerException {
        ArrayList<Job> jobs = new ArrayList<Job>();
        try {
            Scheduler scheduler = this.getQuartzScheduler();
            for (String groupName : scheduler.getJobGroupNames()) {
                for (String jobId : scheduler.getJobNames(groupName)) {
                    for (Trigger trigger : scheduler.getTriggersOfJob(jobId, groupName)) {
                        Job job = new Job();
                        job.setGroupName(groupName);
                        JobDetail jobDetail = scheduler.getJobDetail(jobId, groupName);
                        if (jobDetail != null) {
                            job.setUserName(jobDetail.getGroup());
                            JobDataMap jobDataMap = jobDetail.getJobDataMap();
                            if (jobDataMap != null) {
                                Map wrappedMap = jobDataMap.getWrappedMap();
                                job.setJobParams(wrappedMap);
                            }
                        }
                        job.setJobId(jobId);
                        this.setJobTrigger(scheduler, job, trigger);
                        job.setJobName(QuartzJobKey.parse(jobId).getJobName());
                        job.setNextRun(trigger.getNextFireTime());
                        job.setLastRun(trigger.getPreviousFireTime());
                        if (filter != null && !filter.accept(job)) continue;
                        jobs.add(job);
                    }
                }
            }
        }
        catch (org.quartz.SchedulerException e) {
            throw new SchedulerException(Messages.getInstance().getString("QuartzScheduler.ERROR_0004_FAILED_TO_LIST_JOBS"), e);
        }
        return jobs;
    }

    private void setJobTrigger(Scheduler scheduler, Job job, Trigger trigger) throws SchedulerException, org.quartz.SchedulerException {
        QuartzJobKey jobKey = QuartzJobKey.parse(job.getJobId());
        String groupName = jobKey.getUserName();
        if (trigger instanceof SimpleTrigger) {
            SimpleTrigger simpleTrigger = (SimpleTrigger)trigger;
            SimpleJobTrigger simpleJobTrigger = new SimpleJobTrigger();
            simpleJobTrigger.setStartTime(simpleTrigger.getStartTime());
            simpleJobTrigger.setEndTime(simpleTrigger.getEndTime());
            simpleJobTrigger.setUiPassParam((String)((Object)job.getJobParams().get(RESERVEDMAPKEY_UIPASSPARAM)));
            long interval = simpleTrigger.getRepeatInterval();
            if (interval > 0L) {
                interval /= 1000L;
            }
            simpleJobTrigger.setRepeatInterval(interval);
            simpleJobTrigger.setRepeatCount(simpleTrigger.getRepeatCount());
            job.setJobTrigger(simpleJobTrigger);
        } else if (trigger instanceof CronTrigger) {
            Calendar calendar;
            CronTrigger cronTrigger = (CronTrigger)trigger;
            ComplexJobTrigger complexJobTrigger = QuartzScheduler.createComplexTrigger(cronTrigger.getCronExpression());
            complexJobTrigger.setUiPassParam((String)((Object)job.getJobParams().get(RESERVEDMAPKEY_UIPASSPARAM)));
            complexJobTrigger.setCronString(((CronTrigger)trigger).getCronExpression());
            job.setJobTrigger(complexJobTrigger);
            if (trigger.getCalendarName() != null && (calendar = scheduler.getCalendar(trigger.getCalendarName())) instanceof QuartzSchedulerAvailability) {
                QuartzSchedulerAvailability quartzSchedulerAvailability = (QuartzSchedulerAvailability)calendar;
                complexJobTrigger.setStartTime(quartzSchedulerAvailability.getStartTime());
                complexJobTrigger.setEndTime(quartzSchedulerAvailability.getEndTime());
            }
            complexJobTrigger.setCronString(((CronTrigger)trigger).getCronExpression());
        }
        int triggerState = scheduler.getTriggerState(job.getJobId(), groupName);
        switch (triggerState) {
            case 0: {
                job.setState(Job.JobState.NORMAL);
                break;
            }
            case 4: {
                job.setState(Job.JobState.BLOCKED);
                break;
            }
            case 2: {
                job.setState(Job.JobState.COMPLETE);
                break;
            }
            case 3: {
                job.setState(Job.JobState.ERROR);
                break;
            }
            case 1: {
                job.setState(Job.JobState.PAUSED);
                break;
            }
            default: {
                job.setState(Job.JobState.UNKNOWN);
            }
        }
        job.setJobName(QuartzJobKey.parse(job.getJobId()).getJobName());
        job.setNextRun(trigger.getNextFireTime());
        job.setLastRun(trigger.getPreviousFireTime());
    }

    @Override
    public Integer getMinScheduleInterval(IScheduleSubject subject) {
        return 0;
    }

    @Override
    public ComplexJobTrigger getSubjectAvailabilityWindow(IScheduleSubject subject) {
        return null;
    }

    @Override
    public void pause() throws SchedulerException {
        try {
            this.getQuartzScheduler().standby();
        }
        catch (org.quartz.SchedulerException e) {
            throw new SchedulerException(e);
        }
    }

    @Override
    public void pauseJob(String jobId) throws SchedulerException {
        try {
            Scheduler scheduler = this.getQuartzScheduler();
            scheduler.pauseJob(jobId, QuartzJobKey.parse(jobId).getUserName());
        }
        catch (org.quartz.SchedulerException e) {
            throw new SchedulerException(Messages.getInstance().getString("QuartzScheduler.ERROR_0005_FAILED_TO_PAUSE_JOBS"), e);
        }
    }

    @Override
    public void removeJob(String jobId) throws SchedulerException {
        try {
            Scheduler scheduler = this.getQuartzScheduler();
            scheduler.deleteJob(jobId, QuartzJobKey.parse(jobId).getUserName());
        }
        catch (org.quartz.SchedulerException e) {
            throw new SchedulerException(Messages.getInstance().getString("QuartzScheduler.ERROR_0005_FAILED_TO_PAUSE_JOBS"), e);
        }
    }

    @Override
    public void start() throws SchedulerException {
        try {
            this.getQuartzScheduler().start();
        }
        catch (org.quartz.SchedulerException e) {
            throw new SchedulerException(e);
        }
    }

    @Override
    public void resumeJob(String jobId) throws SchedulerException {
        try {
            Scheduler scheduler = this.getQuartzScheduler();
            scheduler.resumeJob(jobId, QuartzJobKey.parse(jobId).getUserName());
        }
        catch (org.quartz.SchedulerException e) {
            throw new SchedulerException(Messages.getInstance().getString("QuartzScheduler.ERROR_0005_FAILED_TO_RESUME_JOBS"), e);
        }
    }

    @Override
    public void setAvailabilityWindows(Map<IScheduleSubject, ComplexJobTrigger> availability) {
    }

    @Override
    public void setMinScheduleInterval(IScheduleSubject subject, int intervalInSeconds) {
    }

    @Override
    public void setSubjectAvailabilityWindow(IScheduleSubject subject, ComplexJobTrigger availability) {
    }

    protected String getCurrentUser() {
        IPentahoSession session = PentahoSessionHolder.getSession();
        if (session == null) {
            return null;
        }
        Authentication p = SecurityHelper.getInstance().getAuthentication();
        return p == null ? null : p.getName();
    }

    public static ComplexJobTrigger createComplexTrigger(String cronExpression) {
        ComplexJobTrigger complexJobTrigger = new ComplexJobTrigger();
        complexJobTrigger.setHourlyRecurrence((ITimeRecurrence)null);
        complexJobTrigger.setMinuteRecurrence((ITimeRecurrence)null);
        complexJobTrigger.setSecondRecurrence((ITimeRecurrence)null);
        for (ITimeRecurrence recurrence : QuartzScheduler.parseRecurrence(cronExpression, 6)) {
            complexJobTrigger.addYearlyRecurrence(recurrence);
        }
        for (ITimeRecurrence recurrence : QuartzScheduler.parseRecurrence(cronExpression, 4)) {
            complexJobTrigger.addMonthlyRecurrence(recurrence);
        }
        List<ITimeRecurrence> dayOfWeekRecurrences = QuartzScheduler.parseDayOfWeekRecurrences(cronExpression);
        List<ITimeRecurrence> dayOfMonthRecurrences = QuartzScheduler.parseRecurrence(cronExpression, 3);
        if (dayOfWeekRecurrences.size() > 0 && dayOfMonthRecurrences.size() == 0) {
            for (ITimeRecurrence recurrence : dayOfWeekRecurrences) {
                complexJobTrigger.addDayOfWeekRecurrence(recurrence);
            }
        } else if (dayOfWeekRecurrences.size() == 0 && dayOfMonthRecurrences.size() > 0) {
            for (ITimeRecurrence recurrence : dayOfMonthRecurrences) {
                complexJobTrigger.addDayOfMonthRecurrence(recurrence);
            }
        }
        for (ITimeRecurrence recurrence : QuartzScheduler.parseRecurrence(cronExpression, 2)) {
            complexJobTrigger.addHourlyRecurrence(recurrence);
        }
        for (ITimeRecurrence recurrence : QuartzScheduler.parseRecurrence(cronExpression, 1)) {
            complexJobTrigger.addMinuteRecurrence(recurrence);
        }
        for (ITimeRecurrence recurrence : QuartzScheduler.parseRecurrence(cronExpression, 0)) {
            complexJobTrigger.addSecondRecurrence(recurrence);
        }
        return complexJobTrigger;
    }

    private static List<ITimeRecurrence> parseDayOfWeekRecurrences(String cronExpression) {
        ArrayList<ITimeRecurrence> dayOfWeekRecurrence = new ArrayList<ITimeRecurrence>();
        String delims = "[ ]+";
        String[] tokens = cronExpression.split(delims);
        if (tokens.length >= 6) {
            String dayOfWeekTokens = tokens[5];
            if ((tokens = dayOfWeekTokens.split(",")).length > 1 || !tokens[0].equals("*") && !tokens[0].equals("?")) {
                RecurrenceList dayOfWeekList = null;
                for (String token : tokens) {
                    String[] days;
                    if (listPattern.matcher(token).matches()) {
                        if (dayOfWeekList == null) {
                            dayOfWeekList = new RecurrenceList();
                        }
                        dayOfWeekList.getValues().add(Integer.parseInt(token));
                        continue;
                    }
                    if (dayOfWeekList != null) {
                        dayOfWeekRecurrence.add(dayOfWeekList);
                        dayOfWeekList = null;
                    }
                    if (sequencePattern.matcher(token).matches()) {
                        days = token.split("-");
                        dayOfWeekRecurrence.add(new SequentialRecurrence(Integer.parseInt(days[0]), Integer.parseInt(days[1])));
                        continue;
                    }
                    if (intervalPattern.matcher(token).matches()) {
                        days = token.split("/");
                        dayOfWeekRecurrence.add(new IncrementalRecurrence(Integer.parseInt(days[0]), Integer.parseInt(days[1])));
                        continue;
                    }
                    if (qualifiedDayPattern.matcher(token).matches()) {
                        days = token.split("#");
                        dayOfWeekRecurrence.add(new QualifiedDayOfWeek(Integer.parseInt(days[1]), Integer.parseInt(days[0])));
                        continue;
                    }
                    if (lastDayPattern.matcher(token).matches()) {
                        QualifiedDayOfWeek.DayOfWeek dayOfWeek = QualifiedDayOfWeek.DayOfWeek.values()[(Integer.parseInt(token.substring(0, token.length() - 1)) - 1) % 7];
                        dayOfWeekRecurrence.add(new QualifiedDayOfWeek(QualifiedDayOfWeek.DayOfWeekQualifier.LAST, dayOfWeek));
                        continue;
                    }
                    if (dayOfWeekRangePattern.matcher(token).matches()) {
                        days = token.split("-");
                        int start = QualifiedDayOfWeek.DayOfWeek.valueOf(days[0]).ordinal();
                        int finish = QualifiedDayOfWeek.DayOfWeek.valueOf(days[1]).ordinal();
                        dayOfWeekRecurrence.add(new SequentialRecurrence(start, finish));
                        continue;
                    }
                    dayOfWeekList = new RecurrenceList();
                    dayOfWeekList.getValues().add(QualifiedDayOfWeek.DayOfWeek.valueOf(token).ordinal());
                    dayOfWeekRecurrence.add(dayOfWeekList);
                    dayOfWeekList = null;
                }
                if (dayOfWeekList != null) {
                    dayOfWeekRecurrence.add(dayOfWeekList);
                }
            }
        } else {
            throw new IllegalArgumentException(Messages.getInstance().getErrorString("ComplexJobTrigger.ERROR_0001_InvalidCronExpression"));
        }
        return dayOfWeekRecurrence;
    }

    private static List<ITimeRecurrence> parseRecurrence(String cronExpression, int tokenIndex) {
        ArrayList<ITimeRecurrence> timeRecurrence = new ArrayList<ITimeRecurrence>();
        String delims = "[ ]+";
        String[] tokens = cronExpression.split(delims);
        if (tokens.length > tokenIndex) {
            String timeTokens = tokens[tokenIndex];
            if ((tokens = timeTokens.split(",")).length > 1 || !tokens[0].equals("*") && !tokens[0].equals("?")) {
                RecurrenceList timeList = null;
                for (String token : tokens) {
                    String[] days;
                    if (listPattern.matcher(token).matches()) {
                        if (timeList == null) {
                            timeList = new RecurrenceList();
                        }
                        timeList.getValues().add(Integer.parseInt(token));
                        continue;
                    }
                    if (timeList != null) {
                        timeRecurrence.add(timeList);
                        timeList = null;
                    }
                    if (sequencePattern.matcher(token).matches()) {
                        days = token.split("-");
                        timeRecurrence.add(new SequentialRecurrence(Integer.parseInt(days[0]), Integer.parseInt(days[1])));
                        continue;
                    }
                    if (intervalPattern.matcher(token).matches()) {
                        days = token.split("/");
                        timeRecurrence.add(new IncrementalRecurrence(Integer.parseInt(days[0]), Integer.parseInt(days[1])));
                        continue;
                    }
                    if ("L".equalsIgnoreCase(token)) {
                        timeRecurrence.add(new QualifiedDayOfMonth());
                        continue;
                    }
                    throw new IllegalArgumentException(Messages.getInstance().getErrorString("ComplexJobTrigger.ERROR_0001_InvalidCronExpression"));
                }
                if (timeList != null) {
                    timeRecurrence.add(timeList);
                }
            }
        } else {
            throw new IllegalArgumentException(Messages.getInstance().getErrorString("ComplexJobTrigger.ERROR_0001_InvalidCronExpression"));
        }
        return timeRecurrence;
    }

    @Override
    public IScheduler.SchedulerStatus getStatus() throws SchedulerException {
        IScheduler.SchedulerStatus schedulerStatus = IScheduler.SchedulerStatus.STOPPED;
        try {
            if (this.getQuartzScheduler().isInStandbyMode()) {
                schedulerStatus = IScheduler.SchedulerStatus.PAUSED;
            } else if (this.getQuartzScheduler().isStarted()) {
                schedulerStatus = IScheduler.SchedulerStatus.RUNNING;
            }
        }
        catch (org.quartz.SchedulerException e) {
            throw new SchedulerException(Messages.getInstance().getString("QuartzScheduler.ERROR_0006_FAILED_TO_GET_SCHEDULER_STATUS"), e);
        }
        return schedulerStatus;
    }

    @Override
    public void shutdown() throws SchedulerException {
        try {
            boolean waitForJobsToComplete = true;
            this.getQuartzScheduler().shutdown(waitForJobsToComplete);
        }
        catch (org.quartz.SchedulerException e) {
            throw new SchedulerException(e);
        }
    }

    public static String prettyPrintMap(Map<String, Serializable> map) {
        StringBuilder b = new StringBuilder();
        for (Map.Entry<String, Serializable> entry : map.entrySet()) {
            b.append(entry.getKey());
            b.append("=");
            b.append(entry.getValue());
            b.append("; ");
        }
        return b.toString();
    }

    @Override
    public void addListener(ISchedulerListener listener) {
        this.listeners.add(listener);
    }

    public void setListeners(Collection<ISchedulerListener> listeners) {
        this.listeners.addAll(listeners);
    }

    @Override
    public void fireJobCompleted(IAction actionBean, String actionUser, Map<String, Serializable> params, IBackgroundExecutionStreamProvider streamProvider) {
        for (ISchedulerListener listener : this.listeners) {
            listener.jobCompleted(actionBean, actionUser, params, streamProvider);
        }
    }
}

