/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.scheduler2.versionchecker;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPentahoSystemListener;
import org.pentaho.platform.api.scheduler2.IJobFilter;
import org.pentaho.platform.api.scheduler2.IJobTrigger;
import org.pentaho.platform.api.scheduler2.IScheduler;
import org.pentaho.platform.api.scheduler2.Job;
import org.pentaho.platform.api.scheduler2.SchedulerException;
import org.pentaho.platform.api.scheduler2.SimpleJobTrigger;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.scheduler2.versionchecker.VersionCheckerAction;
import org.pentaho.platform.util.versionchecker.PentahoVersionCheckReflectHelper;

public class EmbeddedVersionCheckSystemListener
implements IPentahoSystemListener {
    private static final Log logger = LogFactory.getLog(EmbeddedVersionCheckSystemListener.class);
    private static final String VERSION_CHECK_JOBNAME = "PentahoSystemVersionCheck";
    private static int MIN_CHECK_INTERVAL = 43200;
    private static int DEFAULT_CHECK_INTERVAL = 86400;
    private int repeatIntervalSeconds = DEFAULT_CHECK_INTERVAL;
    private String requestedReleases = "minor, ga";
    private boolean disableVersionCheck = false;

    public boolean startup(IPentahoSession session) {
        block7: {
            if (this.isVersionCheckAvailable()) {
                try {
                    int repeatSeconds = this.calculateRepeatSeconds();
                    int versionRequestFlags = this.calculateRequestFlags();
                    if (!this.disableVersionCheck) {
                        this.scheduleJob(versionRequestFlags, repeatSeconds);
                        break block7;
                    }
                    this.deleteJobIfNecessary();
                }
                catch (Exception ignoredMainException) {
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)"Exception in VersionCheck", (Throwable)ignoredMainException);
                    }
                    break block7;
                }
            }
            try {
                this.deleteJobIfNecessary();
            }
            catch (SchedulerException ignoredOnPurpose) {
                if (!logger.isTraceEnabled()) break block7;
                logger.trace((Object)"Exception in VersionCheck", (Throwable)ignoredOnPurpose);
            }
        }
        return true;
    }

    public int calculateRepeatSeconds() {
        return Math.max(MIN_CHECK_INTERVAL, this.repeatIntervalSeconds);
    }

    protected int calculateRequestFlags() {
        boolean requestMajorReleases = this.requestedReleases.indexOf("major") >= 0;
        boolean requestMinorReleases = this.requestedReleases.indexOf("minor") >= 0;
        boolean requestRCReleases = this.requestedReleases.indexOf("rc") >= 0;
        boolean requestGAReleases = this.requestedReleases.indexOf("ga") >= 0;
        boolean requestMilestoneReleases = this.requestedReleases.indexOf("milestone") >= 0;
        int versionRequestFlags = (requestMajorReleases ? 4 : 0) + (requestMinorReleases ? 8 : 0) + (requestRCReleases ? 16 : 0) + (requestGAReleases ? 32 : 0) + (requestMilestoneReleases ? 64 : 0);
        return versionRequestFlags;
    }

    protected void scheduleJob(int versionRequestFlags, int repeatSeconds) throws Exception {
        IScheduler scheduler = (IScheduler)PentahoSystem.get(IScheduler.class, (String)"IScheduler2", null);
        this.deleteJobIfNecessary();
        HashMap<String, Serializable> parms = new HashMap<String, Serializable>();
        parms.put("versionRequestFlags", new Integer(versionRequestFlags));
        SimpleJobTrigger trigger = new SimpleJobTrigger(new Date(), null, -1, repeatSeconds);
        scheduler.createJob(VERSION_CHECK_JOBNAME, VersionCheckerAction.class, parms, (IJobTrigger)trigger);
    }

    protected void deleteJobIfNecessary() throws SchedulerException {
        IJobFilter filter;
        IScheduler scheduler = (IScheduler)PentahoSystem.get(IScheduler.class, (String)"IScheduler2", null);
        List<Job> matchingJobs = scheduler.getJobs(filter = new IJobFilter(){

            @Override
            public boolean accept(Job job) {
                return job.getJobName().contains(EmbeddedVersionCheckSystemListener.VERSION_CHECK_JOBNAME);
            }
        });
        if (matchingJobs != null && matchingJobs.size() > 0) {
            for (Job verCkJob : matchingJobs) {
                scheduler.removeJob(verCkJob.getJobId());
            }
        }
    }

    protected boolean isVersionCheckAvailable() {
        return PentahoVersionCheckReflectHelper.isVersionCheckerAvailable();
    }

    public void shutdown() {
    }

    public int getRepeatIntervalSeconds() {
        return this.repeatIntervalSeconds;
    }

    public void setRepeatIntervalSeconds(int repeatIntervalSeconds) {
        this.repeatIntervalSeconds = repeatIntervalSeconds;
    }

    public String getRequestedReleases() {
        return this.requestedReleases;
    }

    public void setRequestedReleases(String requestedReleases) {
        this.requestedReleases = requestedReleases;
    }

    public boolean isDisableVersionCheck() {
        return this.disableVersionCheck;
    }

    public void setDisableVersionCheck(boolean disableVersionCheck) {
        this.disableVersionCheck = disableVersionCheck;
    }
}

