/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.scheduler2.ws;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.scheduler2.Job;
import org.pentaho.platform.api.scheduler2.JobTrigger;
import org.pentaho.platform.scheduler2.ws.JaxBSafeMap;
import org.pentaho.platform.scheduler2.ws.ListParamValue;
import org.pentaho.platform.scheduler2.ws.MapParamValue;
import org.pentaho.platform.scheduler2.ws.ParamValue;
import org.pentaho.platform.scheduler2.ws.StringParamValue;

public class JobAdapter
extends XmlAdapter<JaxbSafeJob, Job> {
    private static final Log logger = LogFactory.getLog(JobAdapter.class);

    public JaxbSafeJob marshal(Job job) throws Exception {
        if (job == null) {
            return null;
        }
        JaxbSafeJob jaxbSafeJob = new JaxbSafeJob();
        try {
            if (!(job.getJobTrigger() instanceof JobTrigger)) {
                throw new IllegalArgumentException();
            }
            jaxbSafeJob.jobTrigger = job.getJobTrigger();
            jaxbSafeJob.jobParams = new JaxBSafeMap(this.toParamValueMap(job.getJobParams()));
            jaxbSafeJob.lastRun = job.getLastRun();
            jaxbSafeJob.nextRun = job.getNextRun();
            jaxbSafeJob.schedulableClass = job.getSchedulableClass();
            jaxbSafeJob.jobId = job.getJobId();
            jaxbSafeJob.userName = job.getUserName();
            jaxbSafeJob.jobName = job.getJobName();
            jaxbSafeJob.state = job.getState();
        }
        catch (Throwable t) {
            logger.error((Object)"Error marshalling job", t);
            return null;
        }
        return jaxbSafeJob;
    }

    private Map<String, ParamValue> toParamValueMap(Map<String, Serializable> unsafeMap) {
        HashMap<String, ParamValue> paramValueMap = new HashMap<String, ParamValue>();
        for (Map.Entry<String, Serializable> entry : unsafeMap.entrySet()) {
            if (entry.getValue() instanceof Map) {
                MapParamValue map = new MapParamValue();
                Map innerMap = (Map)((Object)entry.getValue());
                Set entrySet = innerMap.entrySet();
                for (Map.Entry innerEntry : entrySet) {
                    map.put(innerEntry.getKey().toString(), innerEntry.getValue() == null ? null : innerEntry.getValue().toString());
                }
                paramValueMap.put(entry.getKey(), map);
                continue;
            }
            if (entry.getValue() instanceof List) {
                ListParamValue list = new ListParamValue();
                List innerList = (List)((Object)entry.getValue());
                list.addAll(innerList);
                paramValueMap.put(entry.getKey(), list);
                continue;
            }
            paramValueMap.put(entry.getKey(), new StringParamValue(entry.getValue() == null ? null : entry.getValue().toString()));
        }
        return paramValueMap;
    }

    private Map<String, Serializable> toProperMap(JaxBSafeMap safeMap) {
        HashMap<String, Serializable> unsafeMap = new HashMap<String, Serializable>();
        for (JaxBSafeMap.JaxBSafeEntry safeEntry : safeMap.entry) {
            if (safeEntry.getStringValue() != null) {
                unsafeMap.put(safeEntry.key, (Serializable)((Object)(safeEntry.getStringValue() == null ? null : safeEntry.getStringValue().toString())));
                continue;
            }
            if (safeEntry.getListValue() != null) {
                unsafeMap.put(safeEntry.key, safeEntry.getListValue());
                continue;
            }
            if (safeEntry.getMapValue() == null) continue;
            unsafeMap.put(safeEntry.key, safeEntry.getMapValue());
        }
        return unsafeMap;
    }

    public Job unmarshal(JaxbSafeJob jaxbSafeJob) throws Exception {
        if (jaxbSafeJob == null) {
            return null;
        }
        Job job = new Job();
        try {
            job.setJobTrigger(jaxbSafeJob.jobTrigger);
            job.setJobParams(this.toProperMap(jaxbSafeJob.jobParams));
            job.setLastRun(jaxbSafeJob.lastRun);
            job.setNextRun(jaxbSafeJob.nextRun);
            job.setSchedulableClass(jaxbSafeJob.schedulableClass);
            job.setJobId(jaxbSafeJob.jobId);
            job.setUserName(jaxbSafeJob.userName);
            job.setJobName(jaxbSafeJob.jobName);
            job.setState(jaxbSafeJob.state);
        }
        catch (Throwable t) {
            logger.error((Object)"Error unmarshalling job", t);
            return null;
        }
        return job;
    }

    @XmlRootElement
    public static class JaxbSafeJob {
        public JobTrigger jobTrigger;
        public JaxBSafeMap jobParams;
        public Date lastRun;
        public Date nextRun;
        public String schedulableClass;
        public String jobId;
        public String userName;
        public String jobName;
        public Job.JobState state;
    }
}

