/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.actionsequence.dom;

import org.dom4j.Attribute;
import org.dom4j.Element;
import org.pentaho.actionsequence.dom.AbstractIOElement;
import org.pentaho.actionsequence.dom.ActionSequenceDocument;
import org.pentaho.actionsequence.dom.IActionDefinition;
import org.pentaho.actionsequence.dom.IActionIOElement;
import org.pentaho.actionsequence.dom.actions.ActionDefinition;
import org.pentaho.actionsequence.dom.actions.ActionFactory;
import org.pentaho.actionsequence.dom.actions.IActionParameterMgr;

public abstract class AbstractActionIOElement
extends AbstractIOElement
implements IActionIOElement {
    public AbstractActionIOElement(Element ioElement, IActionParameterMgr actionInputProvider) {
        super(ioElement, actionInputProvider);
    }

    @Override
    public String getMapping() {
        String name = "";
        Attribute attr = this.ioElement.attribute("mapping");
        if (attr != null && (name = attr.getValue().trim()).equals(this.getName())) {
            name = "";
        }
        return name;
    }

    @Override
    public void setMapping(String mapping) {
        if (mapping == null || mapping.trim().length() == 0 || mapping.trim().equals(this.getName())) {
            if (this.ioElement.attribute("mapping") != null) {
                this.ioElement.addAttribute("mapping", null);
                ActionSequenceDocument.fireIoChanged(this);
            }
        } else if (!(mapping = mapping.trim()).equals(this.ioElement.attributeValue("mapping"))) {
            this.ioElement.addAttribute("mapping", mapping);
            ActionSequenceDocument.fireIoChanged(this);
        }
    }

    @Override
    public IActionDefinition getActionDefinition() {
        Element ancestorElement;
        ActionDefinition actionDefinition = null;
        if (this.ioElement != null && (ancestorElement = this.ioElement.getParent()) != null && (ancestorElement = ancestorElement.getParent()) != null && ancestorElement.getName().equals("action-definition")) {
            actionDefinition = ActionFactory.getActionDefinition(ancestorElement, this.actionInputProvider);
        }
        return actionDefinition;
    }
}

