/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.actionsequence.dom.actions;

import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.pentaho.actionsequence.dom.actions.ActionDefinition;
import org.pentaho.actionsequence.dom.actions.IActionParameterMgr;

public class ActionFactory {
    public static LinkedHashMap<String, Class> pluginActions = new LinkedHashMap();
    public static String PLUGIN_XML_FILENAME = "pentaho_platform_plugin.xml";
    public static String PLUGIN_ROOT_NODE = "pentaho-plugin";
    public static String PLUGIN_ACTION_DEFINITION_NODE = "action-definition";
    protected static boolean pluginsLoaded = false;

    protected static synchronized void loadPlugins() {
        if (!pluginsLoaded) {
            try {
                ActionFactory factory = new ActionFactory();
                Enumeration<URL> enumer = factory.getClass().getClassLoader().getResources(PLUGIN_XML_FILENAME);
                while (enumer.hasMoreElements()) {
                    URL url = enumer.nextElement();
                    try {
                        SAXReader reader;
                        Document doc;
                        InputStream is = url.openStream();
                        if (is == null || (doc = (reader = new SAXReader()).read(is)) == null) continue;
                        List nodes = doc.selectNodes(PLUGIN_ROOT_NODE + "/" + PLUGIN_ACTION_DEFINITION_NODE);
                        Iterator it = nodes.iterator();
                        while (it.hasNext()) {
                            try {
                                Element node = (Element)it.next();
                                String className = node.getText();
                                String id = node.attributeValue("id");
                                Class<?> componentClass = Class.forName(className.trim());
                                pluginActions.put(id, componentClass);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            pluginsLoaded = true;
        }
    }

    public static ActionDefinition getActionDefinition(Element actionDefDomElement, IActionParameterMgr actionInputProvider) {
        ActionDefinition actionDefinition = null;
        if (!pluginsLoaded) {
            ActionFactory.loadPlugins();
        }
        for (Class actionClass : pluginActions.values()) {
            try {
                Method acceptElementMethod = actionClass.getMethod("accepts", Element.class);
                if (!Boolean.TRUE.equals(acceptElementMethod.invoke(null, actionDefDomElement))) continue;
                Constructor constructor = actionClass.getConstructor(Element.class, IActionParameterMgr.class);
                actionDefinition = (ActionDefinition)constructor.newInstance(actionDefDomElement, actionInputProvider);
                break;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (actionDefinition == null) {
            actionDefinition = new ActionDefinition(actionDefDomElement, actionInputProvider);
        }
        return actionDefinition;
    }

    public static Class getActionDefinition(String actionId) {
        if (!pluginsLoaded) {
            ActionFactory.loadPlugins();
        }
        return pluginActions.get(actionId);
    }
}

