/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.actionsequence.dom.actions;

import java.util.ArrayList;
import org.dom4j.Element;
import org.pentaho.actionsequence.dom.ActionInput;
import org.pentaho.actionsequence.dom.ActionSequenceValidationError;
import org.pentaho.actionsequence.dom.IActionInput;
import org.pentaho.actionsequence.dom.IActionInputVariable;
import org.pentaho.actionsequence.dom.IActionOutput;
import org.pentaho.actionsequence.dom.IActionSequenceValidationError;
import org.pentaho.actionsequence.dom.actions.ActionDefinition;
import org.pentaho.actionsequence.dom.actions.IActionParameterMgr;

public class CopyParamAction
extends ActionDefinition {
    public static final String COMPONENT_NAME = "org.pentaho.component.UtilityComponent";
    public static final String COPY_FROM_ELEMENT = "copy-from";
    public static final String COPY_TO_ELEMENT = "copy-to";
    public static final String COPY_FROM_XPATH = "copy/from";
    public static final String COPY_RETURN_XPATH = "copy/return";
    public static final String COPY_PARAM_COMMAND = "copy";
    public static final String OUTPUT_COPY = "output-copy";
    protected static final String[] EXPECTED_INPUTS = new String[]{"copy-from"};

    public CopyParamAction(Element actionDefElement, IActionParameterMgr actionInputProvider) {
        super(actionDefElement, actionInputProvider);
    }

    public CopyParamAction() {
        super(COMPONENT_NAME);
    }

    @Override
    protected void initNewActionDefinition() {
        super.initNewActionDefinition();
        this.setComponentDefinition(COPY_FROM_XPATH, COPY_FROM_ELEMENT);
        this.setComponentDefinition(COPY_RETURN_XPATH, COPY_TO_ELEMENT);
    }

    @Override
    public String[] getReservedInputNames() {
        String inputName = this.getComponentDefinitionValue(COPY_FROM_XPATH);
        if (inputName == null || inputName.trim().length() == 0) {
            inputName = COPY_FROM_ELEMENT;
        }
        return new String[]{inputName};
    }

    @Override
    public String[] getReservedOutputNames() {
        String outputName = this.getComponentDefinitionValue(COPY_RETURN_XPATH);
        if (outputName == null || outputName.trim().length() == 0) {
            outputName = COPY_TO_ELEMENT;
        }
        return new String[]{outputName};
    }

    public static boolean accepts(Element element) {
        boolean accepts = false;
        if (ActionDefinition.accepts(element) && CopyParamAction.hasComponentName(element, COMPONENT_NAME)) {
            accepts = element.selectNodes("component-definition/copy").size() == 1 && element.selectSingleNode("component-definition/format") == null && element.selectSingleNode("component-definition/print") == null && element.selectSingleNode("component-definition/getmapvalues") == null;
        }
        return accepts;
    }

    public void setCopyFrom(IActionInputVariable value) {
        if (!COPY_FROM_ELEMENT.equals(this.getComponentDefinitionValue(COPY_FROM_XPATH))) {
            this.setComponentDefinition(COPY_FROM_XPATH, COPY_FROM_ELEMENT, false);
        }
        this.setActionInputValue(COPY_FROM_ELEMENT, value);
        IActionOutput actionOutput = this.getOutputCopy();
        if (actionOutput != null) {
            actionOutput.setType(value.getType());
        }
    }

    public IActionInput getCopyFrom() {
        String copyFromVarName = this.getComponentDefinitionValue(COPY_FROM_XPATH);
        if (copyFromVarName == null || copyFromVarName.trim().length() == 0) {
            copyFromVarName = COPY_FROM_ELEMENT;
        }
        return this.getInput(copyFromVarName);
    }

    public void setOutputCopy(String publicOutputName) {
        ActionInput copyFrom;
        IActionOutput actionOutput;
        String privateName = this.getComponentDefinitionValue(COPY_RETURN_XPATH);
        if (privateName == null || privateName.trim().length() == 0) {
            privateName = COPY_TO_ELEMENT;
        }
        if ((actionOutput = this.setOutput(privateName, publicOutputName, (copyFrom = (ActionInput)this.getCopyFrom()) != null ? copyFrom.getType() : "string")) == null) {
            this.setComponentDefinition(COPY_RETURN_XPATH, (String)null);
        } else {
            this.setComponentDefinition(COPY_RETURN_XPATH, privateName);
        }
    }

    public IActionOutput getOutputCopy() {
        String privateName = this.getComponentDefinitionValue(COPY_RETURN_XPATH);
        if (privateName == null || privateName.trim().length() == 0) {
            privateName = COPY_TO_ELEMENT;
        }
        return this.getOutput(privateName);
    }

    @Override
    public IActionSequenceValidationError[] validate() {
        String privateName;
        String copyFromVarName = this.getComponentDefinitionValue(COPY_FROM_XPATH);
        if (copyFromVarName == null || copyFromVarName.trim().length() == 0) {
            copyFromVarName = COPY_FROM_ELEMENT;
        }
        ArrayList<ActionSequenceValidationError> errors = new ArrayList<ActionSequenceValidationError>();
        ActionSequenceValidationError validationError = this.validateInput(copyFromVarName);
        if (validationError != null) {
            switch (validationError.errorCode) {
                case 1: {
                    validationError.errorMsg = "Missing input parameter to copy from.";
                    break;
                }
                case 2: {
                    validationError.errorMsg = "'Copy from' input parameter references unknown variable.";
                    break;
                }
                case 3: {
                    validationError.errorMsg = "'Copy from' input parameter is uninitialized.";
                }
            }
            errors.add(validationError);
        }
        if ((privateName = this.getComponentDefinitionValue(COPY_RETURN_XPATH)) == null || privateName.trim().length() == 0) {
            privateName = COPY_TO_ELEMENT;
        }
        if ((validationError = this.validateOutput(privateName)) != null) {
            if (validationError.errorCode == 4) {
                validationError.errorMsg = "Missing output parameter to copy to.";
            }
            errors.add(validationError);
        }
        return errors.toArray(new ActionSequenceValidationError[0]);
    }
}

