/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.actionsequence.dom.actions;

import java.util.ArrayList;
import org.dom4j.Element;
import org.pentaho.actionsequence.dom.ActionInput;
import org.pentaho.actionsequence.dom.ActionInputConstant;
import org.pentaho.actionsequence.dom.ActionSequenceValidationError;
import org.pentaho.actionsequence.dom.IActionInput;
import org.pentaho.actionsequence.dom.IActionInputSource;
import org.pentaho.actionsequence.dom.IActionInputVariable;
import org.pentaho.actionsequence.dom.IActionOutput;
import org.pentaho.actionsequence.dom.actions.ActionDefinition;
import org.pentaho.actionsequence.dom.actions.IActionParameterMgr;

public class FormatMsgAction
extends ActionDefinition {
    public static final String COMPONENT_NAME = "org.pentaho.component.UtilityComponent";
    public static final String STRING_FORMAT_ELEMENT = "format-string";
    public static final String OUTPUT_STRING_ELEMENT = "formatted-msg";
    public static final String RETURN_NAME_XPATH = "format/return";
    public static final String ARGUMENT_XPATH = "format/arg";
    public static final String FORMAT_MSG_COMMAND = "format";
    public static final String OUTPUT_STRING = "output-string";
    public static final String MSG_INPUT_PREFIX = "msgInput";
    protected static final String[] EXPECTED_INPUTS = new String[]{"format-string"};

    public FormatMsgAction(Element actionDefElement, IActionParameterMgr actionInputProvider) {
        super(actionDefElement, actionInputProvider);
    }

    public FormatMsgAction() {
        super(COMPONENT_NAME);
    }

    @Override
    protected void initNewActionDefinition() {
        super.initNewActionDefinition();
        this.setComponentDefinition(FORMAT_MSG_COMMAND, "");
    }

    @Override
    public String[] getReservedInputNames() {
        return EXPECTED_INPUTS;
    }

    @Override
    public String[] getReservedOutputNames() {
        String outputName = this.getComponentDefinitionValue(RETURN_NAME_XPATH);
        if (outputName == null || outputName.trim().length() == 0) {
            outputName = OUTPUT_STRING_ELEMENT;
        }
        return new String[]{outputName};
    }

    public static boolean accepts(Element element) {
        boolean accepts = false;
        if (ActionDefinition.accepts(element) && FormatMsgAction.hasComponentName(element, COMPONENT_NAME)) {
            accepts = element.selectNodes("component-definition/format").size() == 1 && element.selectSingleNode("component-definition/copy") == null && element.selectSingleNode("component-definition/print") == null && element.selectSingleNode("component-definition/getmapvalues") == null;
        }
        return accepts;
    }

    public void setFormatString(ActionInputConstant value) {
        String stringValue;
        String string = stringValue = value != null ? value.getStringValue() : null;
        if (stringValue != null) {
            stringValue = "\"" + stringValue + "\"";
        }
        this.setComponentDefinition("format/format-string", value == null ? null : value.getStringValue());
    }

    public ActionInputConstant getFormatString() {
        String formatString = this.getComponentDefinitionValue("format/format-string");
        if (formatString != null && (formatString = formatString.trim()).startsWith("\"") && formatString.endsWith("\"")) {
            if (formatString.length() < 3) {
                formatString = "";
            }
            formatString = formatString.substring(1, formatString.length() - 1);
        }
        return formatString == null ? IActionInput.NULL_INPUT : new ActionInputConstant(formatString, this.actionParameterMgr);
    }

    public void setOutputString(String publicOutputName) {
        IActionOutput actionOutput;
        String privateName = this.getComponentDefinitionValue(RETURN_NAME_XPATH);
        if (privateName == null || privateName.trim().length() == 0) {
            privateName = OUTPUT_STRING_ELEMENT;
        }
        if ((actionOutput = this.setOutput(privateName, publicOutputName, "string")) == null) {
            this.setComponentDefinition(RETURN_NAME_XPATH, (String)null);
        } else {
            this.setComponentDefinition(RETURN_NAME_XPATH, privateName);
        }
    }

    public IActionOutput getOutputString() {
        String privateName = this.getComponentDefinitionValue(RETURN_NAME_XPATH);
        if (privateName == null || privateName.trim().length() == 0) {
            privateName = OUTPUT_STRING_ELEMENT;
        }
        return this.getOutput(privateName);
    }

    public ActionSequenceValidationError[] validate() {
        String privateName;
        ArrayList<ActionSequenceValidationError> errors = new ArrayList<ActionSequenceValidationError>();
        ActionSequenceValidationError validationError = null;
        if (this.getFormatString() == IActionInput.NULL_INPUT) {
            validationError = new ActionSequenceValidationError();
            validationError.actionDefinition = this;
            validationError.errorCode = 1;
            validationError.errorMsg = "Missing format string.";
            validationError.parameterName = STRING_FORMAT_ELEMENT;
            errors.add(validationError);
        }
        if ((privateName = this.getComponentDefinitionValue(RETURN_NAME_XPATH)) == null || privateName.trim().length() == 0) {
            privateName = OUTPUT_STRING_ELEMENT;
        }
        if ((validationError = this.validateOutput(privateName)) != null) {
            if (validationError.errorCode == 4) {
                validationError.errorMsg = "Missing formatted message output parameter.";
            }
            errors.add(validationError);
        }
        return errors.toArray(new ActionSequenceValidationError[0]);
    }

    public IActionInput[] getMsgInputs() {
        ArrayList<IActionInput> msgInputs = new ArrayList<IActionInput>();
        Element[] elements = this.getComponentDefElements(ARGUMENT_XPATH);
        for (int i = 0; i < elements.length; ++i) {
            String msgInputParamName = elements[i].getText();
            IActionInput msgInput = this.getInput(msgInputParamName);
            if (msgInput == IActionInput.NULL_INPUT) continue;
            msgInputs.add(msgInput);
        }
        return msgInputs.toArray(new IActionInput[0]);
    }

    public void addMsgInput(IActionInputSource inputSource) {
        IActionInput[] oldInputs = this.getMsgInputs();
        for (int i = 0; i < oldInputs.length; ++i) {
            if (!(oldInputs[i] instanceof ActionInput)) continue;
            ((ActionInput)oldInputs[i]).delete();
        }
        this.setComponentDefinition(ARGUMENT_XPATH, new String[0]);
        ArrayList<String> msgInputParamNames = new ArrayList<String>();
        for (int i = 0; i < oldInputs.length; ++i) {
            if (oldInputs[i] instanceof ActionInputConstant && oldInputs[i].getValue() != null) {
                String msgInputParamName = this.getUniqueNameParam();
                msgInputParamNames.add(msgInputParamName);
                this.setActionInputValue(msgInputParamName, (ActionInputConstant)oldInputs[i]);
                continue;
            }
            if (!(oldInputs[i] instanceof ActionInput)) continue;
            ActionInput actionInput = (ActionInput)oldInputs[i];
            msgInputParamNames.add(actionInput.getName());
            this.setActionInputValue(actionInput.getName(), actionInput);
        }
        if (inputSource instanceof IActionInputVariable) {
            IActionInputVariable actionVariable = (IActionInputVariable)inputSource;
            msgInputParamNames.add(actionVariable.getVariableName());
            this.setActionInputValue(actionVariable.getVariableName(), actionVariable);
        } else if (inputSource instanceof ActionInputConstant && ((ActionInputConstant)inputSource).getValue() != null) {
            String msgInputParamName = this.getUniqueNameParam();
            msgInputParamNames.add(msgInputParamName);
            this.setActionInputValue(msgInputParamName, (ActionInputConstant)inputSource);
        }
        if (msgInputParamNames.size() > 0) {
            this.setComponentDefinition(ARGUMENT_XPATH, msgInputParamNames.toArray(new String[0]));
        }
    }

    public void setMsgInputs(IActionInput[] values) {
        IActionInput[] oldInputs = this.getMsgInputs();
        for (int i = 0; i < oldInputs.length; ++i) {
            if (!(oldInputs[i] instanceof ActionInput)) continue;
            ((ActionInput)oldInputs[i]).delete();
        }
        this.setComponentDefinition(ARGUMENT_XPATH, new String[0]);
        ArrayList<String> msgInputParamNames = new ArrayList<String>();
        for (int i = 0; i < values.length; ++i) {
            if (values[i] instanceof IActionInputVariable) {
                IActionInputVariable actionVariable = (IActionInputVariable)((Object)values[i]);
                msgInputParamNames.add(actionVariable.getVariableName());
                this.setActionInputValue(actionVariable.getVariableName(), actionVariable);
                continue;
            }
            if (values[i] instanceof ActionInputConstant && values[i].getValue() != null) {
                String msgInputParamName = this.getUniqueNameParam();
                msgInputParamNames.add(msgInputParamName);
                this.setActionInputValue(msgInputParamName, (ActionInputConstant)values[i]);
                continue;
            }
            if (!(values[i] instanceof ActionInput)) continue;
            ActionInput actionInput = (ActionInput)values[i];
            msgInputParamNames.add(actionInput.getName());
            this.setActionInputValue(actionInput.getName(), actionInput);
        }
        if (msgInputParamNames.size() > 0) {
            this.setComponentDefinition(ARGUMENT_XPATH, msgInputParamNames.toArray(new String[0]));
        }
    }

    private String getUniqueNameParam() {
        String name = null;
        boolean isUnique = false;
        int i = 1;
        while (!isUnique) {
            name = MSG_INPUT_PREFIX + i;
            isUnique = this.getInputParam(name) == null && this.getComponentDefElement(name) == null;
            ++i;
        }
        return name;
    }
}

