/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.actionsequence.dom.actions;

import java.io.StringWriter;
import java.io.Writer;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.pentaho.actionsequence.dom.ActionInputConstant;
import org.pentaho.actionsequence.dom.IActionInput;
import org.pentaho.actionsequence.dom.IActionInputSource;
import org.pentaho.actionsequence.dom.IActionOutput;
import org.pentaho.actionsequence.dom.actions.AbstractRelationalDbAction;
import org.pentaho.actionsequence.dom.actions.ActionDefinition;
import org.pentaho.actionsequence.dom.actions.IActionParameterMgr;

public class MQLAction
extends AbstractRelationalDbAction {
    public static final String QUERY_RESULT_OUTPUT_NAME = "query-result";
    public static final String COMPONENT_NAME = "MQLRelationalDataComponent";
    public static final String OUTPUT_NAME_ELEMENT = "output-name";
    public static final String MQL_ELEMENT = "mql";
    public static final String QUERY_RESULT_ELEMENT = "query-result";
    public static final String MAPPED_QUERY_OUTPUT_NAME = "query_result";
    public static final String OUTPUT_RESULT_SET = "output-result-set";
    public static final String DISABLE_DISTINCT_ELEMENT = "DisableDistinct";
    public static final String FORCE_DB_DIALECT_ELEMENT = "ForceDBDialect";
    public static final String MQLQUERY_CLASSNAME = "MQLQueryClassName";
    protected static final String[] EXPECTED_INPUTS = new String[]{"query"};

    public MQLAction(Element actionDefElement, IActionParameterMgr actionInputProvider) {
        super(actionDefElement, actionInputProvider);
    }

    public MQLAction() {
        super(COMPONENT_NAME);
    }

    public static boolean accepts(Element element) {
        return ActionDefinition.accepts(element) && MQLAction.hasComponentName(element, COMPONENT_NAME);
    }

    @Override
    protected void initNewActionDefinition() {
        super.initNewActionDefinition();
        IActionOutput actionOutput = this.setOutput("query-result", "query-result", "result-set");
        actionOutput.setMapping(MAPPED_QUERY_OUTPUT_NAME);
    }

    @Override
    public String[] getReservedInputNames() {
        return EXPECTED_INPUTS;
    }

    @Override
    public String[] getReservedOutputNames() {
        IActionOutput[] actionOutputs;
        String expectedOutput = "query-result";
        String compDefVal = this.getComponentDefinitionValue(OUTPUT_NAME_ELEMENT);
        if (compDefVal != null) {
            expectedOutput = compDefVal;
        } else if (this.getOutput(expectedOutput) == null && (actionOutputs = this.getOutputs("result-set")).length > 0) {
            expectedOutput = actionOutputs[0].getName();
        }
        return new String[]{expectedOutput};
    }

    @Override
    public IActionInput getQuery() {
        Element element;
        IActionInput query = super.getQuery();
        if (query == IActionInput.NULL_INPUT && (element = this.getComponentDefElement(MQL_ELEMENT)) != null) {
            try {
                query = new ActionInputConstant(this.prettyPrint(DocumentHelper.parseText((String)element.asXML())).getRootElement().asXML(), this.actionParameterMgr);
            }
            catch (DocumentException e) {
                query = new ActionInputConstant(element.asXML(), this.actionParameterMgr);
            }
        }
        return query;
    }

    @Override
    public void setQuery(IActionInputSource value) {
        super.setQuery(value);
        Element element = this.getComponentDefElement(MQL_ELEMENT);
        if (element != null) {
            element.detach();
        }
    }

    public void setDisableDistinct(IActionInputSource value) {
        this.setActionInputValue(DISABLE_DISTINCT_ELEMENT, value);
    }

    public IActionInput getDisableDistinct() {
        return this.getInput(DISABLE_DISTINCT_ELEMENT);
    }

    public void setForceDbDialect(IActionInputSource value) {
        this.setActionInputValue(FORCE_DB_DIALECT_ELEMENT, value);
    }

    public IActionInput getForceDbDialect() {
        return this.getInput(FORCE_DB_DIALECT_ELEMENT);
    }

    public void setMqlQueryClassName(IActionInputSource value) {
        this.setActionInputValue(MQLQUERY_CLASSNAME, value);
    }

    public IActionInput getMqlQueryClassName() {
        return this.getInput(MQLQUERY_CLASSNAME);
    }

    private Document prettyPrint(Document document) {
        try {
            OutputFormat format = OutputFormat.createPrettyPrint();
            format.setEncoding(document.getXMLEncoding());
            StringWriter stringWriter = new StringWriter();
            XMLWriter writer = new XMLWriter((Writer)stringWriter, format);
            writer.write(DocumentHelper.parseText((String)document.asXML()));
            writer.close();
            document = DocumentHelper.parseText((String)stringWriter.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return document;
    }
}

