/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda.cache.endpoints;

import java.io.IOException;
import java.io.OutputStream;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.StreamingOutput;
import pt.webdetails.cda.cache.scheduler.CdaCacheScheduler;
import pt.webdetails.cpf.messaging.JsonGeneratorSerializable;
import pt.webdetails.cpf.utils.JsonHelper;

@Path(value="/{plugin}/api/cacheController")
public class CacheControllerEndpoint {
    @GET
    @Path(value="/list")
    @Produces(value={"application/json"})
    public StreamingOutput cacheOverview() {
        JsonGeneratorSerializable result = this.getCacheScheduler().listScheduledQueries();
        return this.toStreamingOutput(result);
    }

    @POST
    @Path(value="/change")
    @Produces(value={"application/json"})
    public StreamingOutput scheduleJob(@FormParam(value="object") String json) {
        JsonGeneratorSerializable result = this.getCacheScheduler().scheduleQueryExecution(json);
        return this.toStreamingOutput(result);
    }

    @DELETE
    @Path(value="/delete")
    @Produces(value={"application/json"})
    public StreamingOutput deleteJob(@FormParam(value="id") String id) {
        JsonGeneratorSerializable result = this.getCacheScheduler().deleteJob(id);
        return this.toStreamingOutput(result);
    }

    @POST
    @Path(value="/execute")
    @Produces(value={"application/json"})
    public StreamingOutput executeJob(@FormParam(value="id") String id) {
        JsonGeneratorSerializable result = this.getCacheScheduler().executeJob(id);
        return this.toStreamingOutput(result);
    }

    private StreamingOutput toStreamingOutput(final JsonGeneratorSerializable json) {
        return new StreamingOutput(){

            public void write(OutputStream out) throws IOException, WebApplicationException {
                JsonHelper.writeJson((JsonGeneratorSerializable)json, (OutputStream)out);
            }
        };
    }

    private CdaCacheScheduler getCacheScheduler() {
        return new CdaCacheScheduler();
    }
}

