/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda.cache.scheduler;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.pentaho.platform.api.action.IVarArgsAction;
import org.pentaho.platform.api.repository2.unified.UnifiedRepositoryAccessDeniedException;
import pt.webdetails.cda.CdaEngine;
import pt.webdetails.cda.query.QueryOptions;
import pt.webdetails.cda.settings.CdaSettings;

public class CdaCacheWarmer
implements IVarArgsAction {
    private static final Log logger = LogFactory.getLog(CdaCacheWarmer.class);
    public static final String QUERY_INFO_PARAM = "cdaQuery";
    private CdaSettings cdaSettings;
    private QueryOptions queryOptions;
    private String jsonStringArg;

    public static CdaSettings getCdaSettings(CdaEngine engine, JSONObject json) throws Exception {
        String cdaFile = json.getString("cdaFile");
        return engine.getSettingsManager().parseSettingsFile(cdaFile);
    }

    public static QueryOptions createQueryOptions(JSONObject json) throws JSONException {
        Object parameters;
        QueryOptions queryOpts = new QueryOptions();
        queryOpts.setDataAccessId(json.getString("dataAccessId"));
        if (json.has("parameters") && (parameters = json.get("parameters")) instanceof JSONArray) {
            JSONArray parametersArray = (JSONArray)parameters;
            for (int i = 0; i < parametersArray.length(); ++i) {
                JSONObject param = parametersArray.getJSONObject(i);
                String name = param.getString("name");
                JSONArray arrayOpt = param.optJSONArray("value");
                if (arrayOpt != null) {
                    String[] values = new String[arrayOpt.length()];
                    for (int j = 0; j < values.length; ++j) {
                        values[i] = arrayOpt.getString(j);
                    }
                    queryOpts.addParameter(name, (Object)values);
                    continue;
                }
                String value = param.getString("value");
                queryOpts.addParameter(name, (Object)value);
            }
        }
        queryOpts.setCacheBypass(true);
        return queryOpts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws Exception {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            if (!this.loadArguments()) {
                logger.error((Object)"Not executed: unable to process arguments.");
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("executing %s:%s\n\t %s", this.cdaSettings.getId(), this.queryOptions.getDataAccessId(), this.jsonStringArg));
            } else {
                logger.info((Object)String.format("executing %s:%s...", this.cdaSettings.getId(), this.queryOptions.getDataAccessId()));
            }
            CdaEngine.getInstance().doQuery(this.cdaSettings, this.queryOptions);
        }
        catch (Exception e) {
            logger.error((Object)"Execution failed.", (Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    public void setVarArgs(Map<String, Object> args) {
        if (!args.containsKey(QUERY_INFO_PARAM)) {
            this.jsonStringArg = null;
        } else {
            try {
                this.jsonStringArg = (String)args.get(QUERY_INFO_PARAM);
            }
            catch (ClassCastException e) {
                logger.error((Object)"Invalid parameter type", (Throwable)e);
            }
        }
    }

    private boolean loadArguments() {
        try {
            JSONObject json = new JSONObject(this.jsonStringArg);
            this.queryOptions = CdaCacheWarmer.createQueryOptions(json);
            this.cdaSettings = CdaCacheWarmer.getCdaSettings(CdaEngine.getInstance(), json);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("setVarArgs: %s = %s ", QUERY_INFO_PARAM, json));
            }
            return true;
        }
        catch (JSONException e) {
            logger.error((Object)"Unable to parse JSON parameter", (Throwable)e);
        }
        catch (UnifiedRepositoryAccessDeniedException e) {
            logger.warn((Object)"Access error, if problem persists check permissions.");
        }
        catch (Exception e) {
            logger.error((Object)"Invalid parameters", (Throwable)e);
        }
        return false;
    }
}

