/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda.connections.mondrian;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IConnectionUserRoleMapper;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.PentahoAccessControlException;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import pt.webdetails.cda.connections.mondrian.IMondrianRoleMapper;

public class MondrianRoleMapper
implements IMondrianRoleMapper {
    private static final Log logger = LogFactory.getLog(MondrianRoleMapper.class);

    protected IPentahoSession getSession() {
        return PentahoSessionHolder.getSession();
    }

    protected IConnectionUserRoleMapper getConnectionUserRoleMapper() {
        return (IConnectionUserRoleMapper)PentahoSystem.get(IConnectionUserRoleMapper.class, (String)"Mondrian-UserRoleMapper", null);
    }

    protected boolean isObjectDefined() {
        return PentahoSystem.getObjectFactory().objectDefined("Mondrian-UserRoleMapper");
    }

    public String getRoles(String catalog) {
        if (this.isObjectDefined()) {
            IConnectionUserRoleMapper mondrianUserRoleMapper = this.getConnectionUserRoleMapper();
            try {
                String[] validMondrianRolesForUser = mondrianUserRoleMapper.mapConnectionRoles(this.getSession(), catalog);
                if (validMondrianRolesForUser != null && validMondrianRolesForUser.length > 0) {
                    StringBuffer buff = new StringBuffer();
                    for (int i = 0; i < validMondrianRolesForUser.length; ++i) {
                        String aRole = validMondrianRolesForUser[i];
                        if (i > 0) {
                            buff.append(",");
                        }
                        buff.append(aRole.replaceAll(",", ",,"));
                    }
                    logger.debug((Object)("Assembled role: " + buff.toString() + " for catalog: " + catalog));
                    return buff.toString();
                }
            }
            catch (PentahoAccessControlException pentahoAccessControlException) {
                // empty catch block
            }
        }
        return "";
    }
}

