/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda.services;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.pentaho.util.messages.LocaleHelper;
import pt.webdetails.cda.services.ProcessedHtmlPage;
import pt.webdetails.cpf.context.api.IUrlProvider;
import pt.webdetails.cpf.packager.origin.PathOrigin;
import pt.webdetails.cpf.packager.origin.StaticSystemOrigin;
import pt.webdetails.cpf.repository.api.IContentAccessFactory;
import pt.webdetails.cpf.utils.Pair;

public class ExtEditor
extends ProcessedHtmlPage {
    private static String EXT_EDITOR = "ext-editor.html";
    private static String MAIN_EDITOR = "editor.html";
    private static String UI_BACKEND_PREFIX = "ExternalEditor.";
    private static String EDITOR_SYS_DIR = "editor";

    public ExtEditor(IUrlProvider urlProvider, IContentAccessFactory access) {
        super(urlProvider, access);
    }

    public String getMainEditor() throws IOException {
        return this.processPage(this.getBaseDir(), MAIN_EDITOR);
    }

    public String getExtEditor() throws IOException {
        return this.processPage(this.getBaseDir(), EXT_EDITOR);
    }

    private PathOrigin getBaseDir() {
        return new StaticSystemOrigin(EDITOR_SYS_DIR);
    }

    @Override
    protected Iterable<Pair<String, String>> getBackendAssignments(IUrlProvider urlProvider) {
        String baseApi = urlProvider.getPluginBaseUrl();
        ArrayList<Pair<String, String>> pairs = new ArrayList<Pair<String, String>>();
        pairs.add(new Pair((Object)(UI_BACKEND_PREFIX + "EXT_EDITOR"), (Object)this.quote(baseApi, "extEditor")));
        pairs.add(new Pair((Object)(UI_BACKEND_PREFIX + "CAN_EDIT_URL"), (Object)this.quote(baseApi, "canEdit")));
        pairs.add(new Pair((Object)(UI_BACKEND_PREFIX + "GET_FILE_URL"), (Object)this.quote(baseApi, "getCdaFile")));
        pairs.add(new Pair((Object)(UI_BACKEND_PREFIX + "SAVE_FILE_URL"), (Object)this.quote(baseApi, "writeCdaFile")));
        pairs.add(new Pair((Object)(UI_BACKEND_PREFIX + "LANG_PATH"), (Object)this.quote(urlProvider.getPluginStaticBaseUrl(), EDITOR_SYS_DIR, "/languages/")));
        pairs.add(new Pair((Object)(UI_BACKEND_PREFIX + "LOCALE"), (Object)this.quote(LocaleHelper.getLocale().toString())));
        pairs.add(new Pair((Object)(UI_BACKEND_PREFIX + "STATUS.OK"), (Object)"true"));
        return pairs;
    }

    private String quote(String ... text) {
        return '\"' + StringUtils.join((Object[])text) + '\"';
    }
}

