/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.table.TableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.map.ObjectMapper;
import org.pentaho.reporting.engine.classic.core.util.TypedTableModel;
import pt.webdetails.cda.utils.TableModelUtils;
import pt.webdetails.cpf.PluginEnvironment;
import pt.webdetails.cpf.plugin.CorePlugin;
import pt.webdetails.cpf.plugincall.api.IPluginCall;
import pt.webdetails.cpf.plugincall.base.CallParameters;

public class InterPluginUtils {
    private static final Log logger = LogFactory.getLog(TableModelUtils.class);
    private static InterPluginUtils _instance;

    public static synchronized InterPluginUtils getInstance() {
        if (_instance == null) {
            _instance = new InterPluginUtils();
        }
        return _instance;
    }

    public static TableModel getTableModelFromJsonPluginCall(String plugin, String method) {
        return InterPluginUtils.getTableModelFromJsonPluginCall(plugin, method, new HashMap<String, Object>());
    }

    public static TableModel getTableModelFromJsonPluginCall(String plugin, String method, Map<String, Object> params) {
        CallParameters parameters = InterPluginUtils.getCallParameters(params);
        IPluginCall pluginCall = PluginEnvironment.env().getPluginCall(new CorePlugin(plugin).getId(), null, method);
        String returnVal = null;
        try {
            returnVal = pluginCall.call(parameters.getParameters());
        }
        catch (Exception e) {
            logger.error((Object)"Error trying to call a plugin");
        }
        return InterPluginUtils.getInstance().getTableModelFromJSONArray(returnVal, params);
    }

    private static CallParameters getCallParameters(Map<String, Object> params) {
        CallParameters parameters = new CallParameters();
        for (String key : params.keySet()) {
            ArrayList<String> arrayList;
            Object value = params.get(key);
            if (value instanceof String[]) {
                parameters.setParameter(key, (String[])value);
                continue;
            }
            if (value instanceof LinkedList) {
                arrayList = new ArrayList<String>();
                for (Object str : (LinkedList)value) {
                    arrayList.add(str.toString());
                }
                parameters.setParameter(key, arrayList.toArray(new String[0]));
                continue;
            }
            if (value instanceof Object[]) {
                arrayList = new ArrayList();
                for (Object str : (Object[])value) {
                    arrayList.add(str.toString());
                }
                parameters.setParameter(key, arrayList.toArray(new String[0]));
                continue;
            }
            parameters.put(key, value.toString());
        }
        return parameters;
    }

    public TableModel getTableModelFromJSONArray(String json, Map<String, Object> params) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            LinkedHashMap columnOutputs;
            List list = (List)mapper.readValue(json, List.class);
            LinkedHashMap cols = new LinkedHashMap();
            for (Map map : list) {
                for (Object key : map.keySet()) {
                    if (cols.containsKey(key)) continue;
                    cols.put(key, key.getClass());
                }
            }
            if (params != null && params.containsKey("columns")) {
                String[] columns = (String[])params.get("columns");
                columnOutputs = new LinkedHashMap();
                for (int i = 0; i < columns.length; ++i) {
                    String column = columns[i];
                    if (cols.containsKey(column)) {
                        columnOutputs.put(column, (Class<Object>)cols.get(column));
                        continue;
                    }
                    columnOutputs.put(column, String.class);
                }
            } else {
                columnOutputs = cols;
            }
            TypedTableModel tm = new TypedTableModel(columnOutputs.keySet().toArray(new String[0]), columnOutputs.values().toArray(new Class[0]), list.size());
            logger.debug((Object)("Done. columnOutputs has " + columnOutputs.size() + " entries"));
            for (int i = 0; i < list.size(); ++i) {
                Map map = (Map)list.get(i);
                Object[] keyset = columnOutputs.keySet().toArray();
                for (int j = 0; j < keyset.length; ++j) {
                    Object key = keyset[j];
                    if (!map.containsKey(key)) continue;
                    tm.setValueAt(map.get(key), i, j);
                }
            }
            return tm;
        }
        catch (IOException ex) {
            logger.error((Object)("Error parsing json: " + json), (Throwable)ex);
            return null;
        }
    }
}

