/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cpk;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.map.ObjectMapper;
import org.dom4j.DocumentException;
import pt.webdetails.cpf.RestRequestHandler;
import pt.webdetails.cpf.Router;
import pt.webdetails.cpk.CpkEngine;
import pt.webdetails.cpk.ICpkEnvironment;
import pt.webdetails.cpk.cache.ICache;
import pt.webdetails.cpk.elements.IElement;
import pt.webdetails.cpk.elements.impl.KettleResult;
import pt.webdetails.cpk.elements.impl.KettleResultKey;
import pt.webdetails.cpk.security.IAccessControl;
import pt.webdetails.cpk.utils.CpkUtils;

public class CpkCoreService {
    private static final Log logger = LogFactory.getLog(CpkCoreService.class);
    private static final String ENCODING = "UTF-8";
    private CpkEngine engine;

    public CpkEngine getEngine() {
        return this.engine;
    }

    public CpkCoreService setEngine(CpkEngine engine) {
        this.engine = engine;
        return this;
    }

    public CpkCoreService(ICpkEnvironment environment) {
        this.setEngine(CpkEngine.getInstance());
        this.getEngine().init(environment);
    }

    public void createContent(Map<String, Map<String, Object>> bloatedMap) throws Exception {
        IAccessControl accessControl = this.getEngine().getEnvironment().getAccessControl();
        HttpServletResponse response = (HttpServletResponse)bloatedMap.get("path").get("httpresponse");
        logger.debug((Object)"Creating content");
        String path = (String)bloatedMap.get("path").get("path");
        IElement element = null;
        if ((path == null || path.equals("/")) && (element = this.getEngine().getDefaultElement()) != null) {
            String url = element.getId();
            if (path == null) {
                url = this.getEngine().getEnvironment().getPluginName() + "/" + url;
            }
            CpkUtils.redirect(response, url);
        }
        if (path != null) {
            element = this.getEngine().getElement(path.substring(1).toLowerCase());
        }
        if (element != null) {
            if (accessControl.isAllowed(element)) {
                element.processRequest(bloatedMap);
            } else {
                accessControl.throwAccessDenied(response);
            }
        } else {
            logger.debug((Object)("Unable to get element: " + path + ". This is probably a call to a control CPK operation (reload, status)"));
            throw new Exception("Unable to get element!");
        }
    }

    public void reload(OutputStream out, Map<String, Map<String, Object>> bloatedMap) throws DocumentException, IOException {
        this.refresh(out, bloatedMap);
    }

    public void refresh(OutputStream out, Map<String, Map<String, Object>> bloatedMap) throws DocumentException, IOException {
        IAccessControl accessControl = this.getEngine().getEnvironment().getAccessControl();
        if (accessControl.isAdmin()) {
            logger.info((Object)("Refreshing CPK plugin " + this.getEngine().getEnvironment().getPluginName()));
            this.getEngine().reload();
            this.status(out, bloatedMap);
        } else {
            accessControl.throwAccessDenied((HttpServletResponse)bloatedMap.get("path").get("httpresponse"));
        }
    }

    public void clearKettleResultsCache() {
        ICache<KettleResultKey, KettleResult> cache = this.getEngine().getKettleResultCache();
        if (cache != null) {
            cache.clear();
        }
    }

    public void status(OutputStream out, Map<String, Map<String, Object>> bloatedMap) throws DocumentException, IOException {
        HttpServletResponse response = (HttpServletResponse)bloatedMap.get("path").get("httpresponse");
        logger.debug((Object)"## status ##");
        logger.info((Object)("Showing status for CPK plugin " + this.getEngine().getEnvironment().getPluginName()));
        if (response != null) {
            CpkUtils.setResponseHeaders(response, "text/plain");
        }
        this.writeMessage(out, this.getEngine().getStatus().getStatus());
    }

    public void statusJson(OutputStream out, HttpServletResponse response) throws DocumentException, IOException {
        logger.info((Object)("Showing status for CPK plugin " + this.getEngine().getEnvironment().getPluginName()));
        if (response != null) {
            CpkUtils.setResponseHeaders(response, "text/plain");
        }
        this.writeMessage(out, this.getEngine().getStatus().getStatusJson());
    }

    public boolean hasElement(String elementId) {
        Map<String, IElement> elementsMap = this.getEngine().getElementsMap();
        return elementsMap.containsKey(elementId.toLowerCase());
    }

    public Collection<IElement> getElements() {
        return this.getEngine().getElements();
    }

    public void getElementsList(OutputStream out, Map<String, Map<String, Object>> bloatedMap) {
        logger.debug((Object)"## getElementsList ##");
        ObjectMapper mapper = new ObjectMapper();
        String json = null;
        try {
            json = mapper.writeValueAsString(this.getEngine().getElements());
            this.writeMessage(out, json);
        }
        catch (IOException ex) {
            logger.error((Object)"Error getting json elements", (Throwable)ex);
        }
    }

    public IElement getDefaultElement() {
        return this.getEngine().getDefaultElement();
    }

    private void writeMessage(OutputStream out, String message) {
        try {
            out.write(message.getBytes(ENCODING));
            out.flush();
        }
        catch (IOException ex) {
            logger.error((Object)"Error writing message", (Throwable)ex);
        }
    }

    public RestRequestHandler getRequestHandler() {
        return Router.getBaseRouter();
    }
}

