/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cpk;

import java.io.IOException;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.ObjectMapper;
import pt.webdetails.cpk.ICpkEnvironment;
import pt.webdetails.cpk.elements.IElement;
import pt.webdetails.cpk.security.IAccessControl;

public class Status {
    private TreeMap<String, IElement> elementsMap;
    private String defaultElementName;
    private ICpkEnvironment cpkEnv;

    private Status() {
    }

    public Status(TreeMap<String, IElement> elementsMap, String defaultElementName, ICpkEnvironment cpkEnv) {
        this.init(elementsMap, defaultElementName, cpkEnv);
    }

    private void init(TreeMap<String, IElement> elementsMap, String defaultElementName, ICpkEnvironment cpkEnv) {
        this.setCpkEnv(cpkEnv);
        this.setDefaultElementName(defaultElementName);
        this.setElementsMap(elementsMap);
    }

    public void setCpkEnv(ICpkEnvironment cpkEnv) {
        this.cpkEnv = cpkEnv;
    }

    @JsonIgnore
    public String getStatusJson() {
        ObjectMapper mapper = new ObjectMapper();
        String json = null;
        try {
            json = mapper.writeValueAsString((Object)this);
        }
        catch (IOException ex) {
            Logger.getLogger(Status.class.getName()).log(Level.SEVERE, null, ex);
            json = "{\"error\":\"There was a problem creating the Status JSON\"}";
        }
        return json;
    }

    @JsonIgnore
    public String getStatus() {
        IAccessControl accessControl = this.cpkEnv.getAccessControl();
        StringBuilder out = new StringBuilder();
        out.append("--------------------------------\n");
        out.append("   ").append(this.cpkEnv.getPluginName()).append(" Status\n");
        out.append("--------------------------------\n");
        out.append("\n");
        out.append("End Points\n");
        for (String key : this.elementsMap.keySet()) {
            IElement myElement = this.elementsMap.get(key);
            if (!accessControl.isAllowed(myElement)) continue;
            out.append("   [").append(key).append("]: \t").append(myElement.toString()).append("\n\n");
        }
        return out.toString();
    }

    @JsonProperty(value="pluginName")
    public String getPluginName() {
        return this.cpkEnv.getPluginName();
    }

    @JsonProperty(value="elements")
    public TreeMap<String, IElement> getElementsMap() {
        return this.elementsMap;
    }

    @JsonIgnore
    public void setElementsMap(TreeMap<String, IElement> elementsMap) {
        this.elementsMap = elementsMap;
    }

    @JsonProperty(value="elementsCount")
    public int getNrElements() {
        return this.getElementsMap().size();
    }

    @JsonProperty(value="defaultElement")
    public String getDefaultElementName() {
        return this.defaultElementName;
    }

    @JsonIgnore
    public void setDefaultElementName(String defaultElementName) {
        this.defaultElementName = defaultElementName;
    }

    @JsonIgnore
    public String toString() {
        return null;
    }
}

