/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cpk.elements;

import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import pt.webdetails.cpk.elements.IElement;

public abstract class Element
implements IElement {
    protected Log logger = LogFactory.getLog(this.getClass());
    private String pluginId;
    private String id;
    private String type;
    private String name;
    private String filePath;
    private boolean adminOnly;

    protected Element() {
    }

    public boolean init(String pluginId, String id, String type, String filePath, boolean adminOnly) {
        this.pluginId = pluginId;
        this.id = id;
        this.type = type;
        this.name = FilenameUtils.getBaseName((String)filePath);
        this.filePath = filePath;
        this.adminOnly = adminOnly;
        return true;
    }

    @Override
    public String getPluginId() {
        return this.pluginId;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getLocation() {
        return this.filePath;
    }

    @Override
    public boolean isAdminOnly() {
        return this.adminOnly;
    }

    @Override
    public boolean isRenderable() {
        return false;
    }

    public String toString() {
        return "{pluginId=" + this.getPluginId() + ", id=" + this.getId() + ", type=" + this.getType() + ", name=" + this.getName() + ", filePath=" + this.getLocation() + ", adminOnly=" + this.isAdminOnly() + "}";
    }

    public int hashCode() {
        int hash = 3;
        hash = 11 * hash + (this.id != null ? this.id.hashCode() : 0);
        hash = 11 * hash + (this.type != null ? this.type.hashCode() : 0);
        hash = 11 * hash + (this.filePath != null ? this.filePath.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Element other = (Element)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
            return false;
        }
        return !(this.filePath == null ? other.filePath != null : !this.filePath.equals(other.filePath));
    }
}

