/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cpk.elements.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.pentaho.di.core.parameters.NamedParams;
import org.pentaho.di.core.parameters.UnknownParamException;
import pt.webdetails.cpk.cache.ICache;
import pt.webdetails.cpk.elements.Element;
import pt.webdetails.cpk.elements.IDataSourceProvider;
import pt.webdetails.cpk.elements.IKettleElement;
import pt.webdetails.cpk.elements.impl.KettleElementHelper;
import pt.webdetails.cpk.elements.impl.KettleResult;
import pt.webdetails.cpk.elements.impl.KettleResultKey;
import pt.webdetails.cpk.elements.impl.kettleoutputs.InferedKettleOutput;
import pt.webdetails.cpk.elements.impl.kettleoutputs.JsonKettleOutput;
import pt.webdetails.cpk.elements.impl.kettleoutputs.KettleOutput;
import pt.webdetails.cpk.elements.impl.kettleoutputs.ResultFilesKettleOutput;
import pt.webdetails.cpk.elements.impl.kettleoutputs.ResultOnlyKettleOutput;
import pt.webdetails.cpk.elements.impl.kettleoutputs.SingleCellKettleOutput;

public abstract class KettleElement<TMeta extends NamedParams>
extends Element
implements IDataSourceProvider,
IKettleElement {
    protected static final String OUTPUT_NAME_PREFIX = "OUTPUT";
    private ICache<KettleResultKey, KettleResult> cache;
    private boolean isResultsCacheEnabled;
    private int timeToLive;
    protected TMeta meta;
    private KettleOutput.Configuration defaultOutputConfiguration;
    private String defaultOutputName;

    public String getDefaultOutputName() {
        return this.defaultOutputName;
    }

    public KettleElement<TMeta> setDefaultOutputName(String defaultOutputName) {
        this.defaultOutputName = defaultOutputName;
        return this;
    }

    public int getTimeToLive() {
        return this.timeToLive;
    }

    public KettleElement<TMeta> setTimeToLive(int timeToLive) {
        this.timeToLive = timeToLive;
        return this;
    }

    public boolean isResultsCacheEnabled() {
        return this.cache != null && this.isResultsCacheEnabled;
    }

    public KettleElement<TMeta> setResultsCacheEnabled(boolean enabled) {
        this.isResultsCacheEnabled = enabled;
        return this;
    }

    public KettleOutput.Configuration getDefaultOutputConfiguration() {
        return this.defaultOutputConfiguration;
    }

    public KettleElement<TMeta> setDefaultOutputConfiguration(KettleOutput.Configuration configuration) {
        this.defaultOutputConfiguration = configuration;
        return this;
    }

    @Override
    @JsonIgnore
    public ICache<KettleResultKey, KettleResult> getCache() {
        return this.cache;
    }

    @Override
    public KettleElement setCache(ICache<KettleResultKey, KettleResult> cache) {
        int timeToLive;
        String timeToLiveStr = null;
        if (this.meta != null) {
            this.logger.debug((Object)"Setting cache while job/transform meta is not set. Unable to load default values from ktr/kjb.");
            timeToLiveStr = KettleParameter.CACHE_TIME_TO_LIVE_SECONDS.metaDefaultValue((NamedParams)this.meta);
        }
        if (timeToLiveStr != null) {
            try {
                timeToLive = Integer.parseInt(timeToLiveStr);
            }
            catch (NumberFormatException e) {
                timeToLive = cache.getTimeToLiveSeconds().intValue();
            }
        } else {
            timeToLive = cache.getTimeToLiveSeconds().intValue();
        }
        this.setTimeToLive(timeToLive);
        this.cache = cache;
        return this;
    }

    public boolean isExecuteAtStart() {
        String isExecuteAtStartStr = KettleParameter.EXECUTE_AT_START.metaDefaultValue((NamedParams)this.meta);
        return Boolean.parseBoolean(isExecuteAtStartStr);
    }

    @Override
    public boolean init(String pluginId, String id, String type, String filePath, boolean adminOnly) {
        this.logger.debug((Object)("Creating Kettle Element from '" + filePath + "'"));
        if (!super.init(pluginId, id, type, filePath, adminOnly)) {
            return false;
        }
        this.meta = this.loadMeta(filePath);
        if (this.meta == null) {
            this.logger.error((Object)("Failed to retrieve '" + this.getLocation() + "'"));
            return false;
        }
        this.initializeKettleParameters();
        if (this.isExecuteAtStart()) {
            this.processRequest(this.getInjectedParameters(), null);
        }
        return true;
    }

    private void initializeKettleParameters() {
        String isCacheEnabledStr = KettleParameter.CACHE_IS_ENABLED.defaultValue((NamedParams)this.meta);
        boolean isResultsCacheEnabled = Boolean.parseBoolean(isCacheEnabledStr);
        String defaultOutputName = this.getDefaultOutputName(KettleParameter.RESULT_STEP_NAME.metaDefaultValue((NamedParams)this.meta), KettleParameter.RESULT_STEP_NAME.hardCodedDefaultValue());
        KettleOutput.Configuration outputConfiguration = this.getOutputConfiguration();
        this.setResultsCacheEnabled(isResultsCacheEnabled).setDefaultOutputName(defaultOutputName).setDefaultOutputConfiguration(outputConfiguration);
    }

    private String getDefaultOutputName(String metaOutputName, String hardCodedDefaultOutputName) {
        Collection<String> existingOutputNames = this.getOutputNames();
        String defaultOutputName = existingOutputNames.contains(metaOutputName) ? metaOutputName : (existingOutputNames.contains(hardCodedDefaultOutputName) ? hardCodedDefaultOutputName : (!existingOutputNames.isEmpty() ? existingOutputNames.iterator().next() : null));
        return defaultOutputName;
    }

    private KettleOutput.Configuration getOutputConfiguration() {
        String mimeType = KettleParameter.RESPONSE_MIME_TYPE.defaultValue((NamedParams)this.meta);
        String attachmentName = KettleParameter.RESPONSE_ATTACHMENT_NAME.defaultValue((NamedParams)this.meta);
        String downloadStr = KettleParameter.RESPONSE_DOWNLOAD.defaultValue((NamedParams)this.meta);
        boolean download = Boolean.parseBoolean(downloadStr);
        String outputType = KettleParameter.RESPONSE_OUTPUT_TYPE.defaultValue((NamedParams)this.meta);
        KettleOutput.Configuration configuration = new KettleOutput.Configuration();
        configuration.setMimeType(mimeType).setAttachmentName(attachmentName).setSendResultAsAttachment(download).setOutputType(outputType);
        return configuration;
    }

    protected final KettleOutput inferResult(String kettleOutputType) {
        if (kettleOutputType == null || kettleOutputType.isEmpty()) {
            kettleOutputType = "Infered";
        }
        KettleOutput kettleOutput = kettleOutputType.equalsIgnoreCase("Json") ? new JsonKettleOutput() : (kettleOutputType.equalsIgnoreCase("ResultFiles") ? new ResultFilesKettleOutput() : (kettleOutputType.equalsIgnoreCase("ResultOnly") ? new ResultOnlyKettleOutput() : (kettleOutputType.equalsIgnoreCase("SingleCell") ? new SingleCellKettleOutput() : new InferedKettleOutput())));
        return kettleOutput;
    }

    @Override
    public final void processRequest(Map<String, Map<String, Object>> bloatedMap) {
        Map<String, Object> request = bloatedMap.get("request");
        String stepName = (String)request.get("stepName");
        String kettleOutputType = this.getStringParameter((String)request.get("kettleOutput"), this.getDefaultOutputConfiguration().getOutputType(), KettleParameter.RESPONSE_OUTPUT_TYPE.hardCodedDefaultValue());
        String downloadStr = (String)request.get("download");
        boolean download = downloadStr != null ? Boolean.parseBoolean(downloadStr) : this.getDefaultOutputConfiguration().getSendResultAsAttachment();
        String bypassCacheStr = (String)request.get("bypassCache");
        boolean bypassCache = Boolean.parseBoolean(bypassCacheStr != null ? bypassCacheStr : "false");
        HttpServletResponse httpResponse = (HttpServletResponse)bloatedMap.get("path").get("httpresponse");
        Map<String, String> kettleParameters = KettleElementHelper.getKettleParameters(request);
        this.processRequest(kettleParameters, kettleOutputType, stepName, download, bypassCache, httpResponse);
    }

    private void processRequest(Map<String, String> kettleParameters, String outputType, String outputStepName, boolean download, boolean bypassCache, HttpServletResponse httpResponse) {
        KettleResult result = this.processRequest(kettleParameters, outputStepName, bypassCache);
        if (result != null) {
            KettleOutput.Configuration configuration = this.getDefaultOutputConfiguration().clone();
            configuration.setSendResultAsAttachment(download);
            KettleOutput kettleOutput = this.inferResult(outputType);
            kettleOutput.setConfiguration(configuration).setResponse(httpResponse);
            kettleOutput.processResult(result);
            this.logger.info((Object)("[ " + result + " ]"));
        }
    }

    @Override
    public final KettleResult processRequest(Map<String, String> kettleParameters, String outputStepName, boolean bypassCache) {
        Map<String, String> filteredKettleParameters = this.sanitizeKettleParameters(kettleParameters);
        filteredKettleParameters.putAll(this.getInjectedParameters());
        KettleResult result = this.isResultsCacheEnabled() ? this.processRequestCached(filteredKettleParameters, outputStepName, bypassCache) : this.processRequest(filteredKettleParameters, outputStepName);
        return result;
    }

    private Map<String, String> sanitizeKettleParameters(Map<String, String> kettleParameters) {
        HashMap<String, String> sanitizedParameters = new HashMap<String, String>();
        for (Map.Entry<String, String> parameter : kettleParameters.entrySet()) {
            if (KettleParameter.isReservedName(parameter.getKey())) continue;
            sanitizedParameters.put(parameter.getKey(), parameter.getValue());
        }
        return sanitizedParameters;
    }

    private KettleResult processRequestCached(Map<String, String> kettleParameters, String outputStepName, boolean bypassCache) {
        KettleResult result;
        KettleResultKey cacheKey = new KettleResultKey(this.getPluginId(), this.getId(), outputStepName, kettleParameters);
        if (!bypassCache && (result = this.getCache().get(cacheKey)) != null) {
            return result;
        }
        result = this.processRequest(kettleParameters, outputStepName);
        this.getCache().put(cacheKey, result, this.getTimeToLive());
        return result;
    }

    private Map<String, String> getInjectedParameters() {
        return KettleElementHelper.getInjectedParameters(this.meta);
    }

    protected boolean isValidOutputName(String Name) {
        return Name != null && Name.startsWith(OUTPUT_NAME_PREFIX);
    }

    private String getStringParameter(String requestParameter, String configParameter, String hardcodedParameter) {
        return requestParameter != null ? requestParameter : (configParameter != null ? configParameter : hardcodedParameter);
    }

    protected abstract KettleResult processRequest(Map<String, String> var1, String var2);

    protected abstract TMeta loadMeta(String var1);

    protected abstract Collection<String> getOutputNames();

    private static class RequestParameterName {
        public static final String STEP_NAME = "stepName";
        public static final String KETTLE_OUTPUT = "kettleOutput";
        public static final String DOWNLOAD = "download";
        public static final String BYPASS_CACHE = "bypassCache";

        private RequestParameterName() {
        }
    }

    public static enum KettleParameter {
        CACHE_IS_ENABLED("cpk.cache.isEnabled", "false"),
        CACHE_TIME_TO_LIVE_SECONDS("cpk.cache.timeToLiveSeconds", "0"),
        RESPONSE_MIME_TYPE("cpk.response.mimeType", null),
        RESPONSE_ATTACHMENT_NAME("cpk.response.attachmentName", null),
        RESPONSE_DOWNLOAD("cpk.response.download", "false"),
        RESPONSE_OUTPUT_TYPE("cpk.response.kettleOutput", "Infered"),
        RESULT_STEP_NAME("cpk.result.stepName", "OUTPUT"),
        EXECUTE_AT_START("cpk.executeAtStart", "false");

        public static final Collection<String> reservedNamePrefixes;
        private final String name;
        private final String defaultValue;

        public static boolean isReservedName(String name) {
            for (String prefix : reservedNamePrefixes) {
                if (!name.startsWith(prefix)) continue;
                return true;
            }
            return false;
        }

        public String parameterName() {
            return this.name;
        }

        public String hardCodedDefaultValue() {
            return this.defaultValue;
        }

        public String metaDefaultValue(NamedParams params) {
            String value = null;
            try {
                value = params.getParameterDefault(this.name);
            }
            catch (UnknownParamException unknownParamException) {
                // empty catch block
            }
            return value;
        }

        public String defaultValue(NamedParams params) {
            String metaDefaultValue = this.metaDefaultValue(params);
            return metaDefaultValue != null ? metaDefaultValue : this.hardCodedDefaultValue();
        }

        private KettleParameter(String name, String defaultValue) {
            this.name = name;
            this.defaultValue = defaultValue;
        }

        static {
            ArrayList<String> prefixes = new ArrayList<String>(Arrays.asList("_", "cpk."));
            reservedNamePrefixes = Collections.unmodifiableCollection(prefixes);
        }
    }
}

