/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cpk.elements.impl;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.pentaho.di.core.parameters.NamedParams;
import org.pentaho.di.core.parameters.UnknownParamException;
import org.pentaho.di.core.variables.VariableSpace;
import pt.webdetails.cpf.session.IUserSession;
import pt.webdetails.cpk.CpkEngine;

public final class KettleElementHelper {
    private static final Log logger = LogFactory.getLog(KettleElementHelper.class);
    private static final String CPK_PLUGIN_ID = "cpk.plugin.id";
    private static final String CPK_SOLUTION_SYSTEM_DIR = "cpk.solution.system.dir";
    private static final String CPK_PLUGIN_DIR = "cpk.plugin.dir";
    private static final String CPK_PLUGIN_SYSTEM_DIR = "cpk.plugin.system.dir";
    private static final String CPK_WEBAPP_DIR = "cpk.webapp.dir";
    private static final String CPK_SESSION_PARAM_PREFIX = "cpk.session.";
    private static final String CPK_SESSION_USERNAME = "cpk.session.username";
    private static final String CPK_SESSION_ROLES = "cpk.session.roles";
    private static final String ROLES_TAG = "roles";
    private static final Collection<String> INJECTED_PARAM_SET = new ArrayList<String>(Arrays.asList("cpk.plugin.id", "cpk.solution.system.dir", "cpk.plugin.dir", "cpk.plugin.system.dir", "cpk.webapp.dir", "cpk.session.username", "cpk.session.roles"));
    private static final String REQUEST_PARAM_PREFIX = "param";
    private static HashMap<String, String> parameterCache;

    public static boolean hasParameter(NamedParams params, String paramName) {
        for (String name : params.listParameters()) {
            if (!name.equals(paramName)) continue;
            return true;
        }
        return false;
    }

    public static boolean setParameterValue(NamedParams params, String paramName, String paramValue) {
        if (!KettleElementHelper.hasParameter(params, paramName)) {
            logger.warn((Object)("Param '" + paramName + "' doesn't exist in the Kettle job/transformation"));
            return false;
        }
        try {
            params.setParameterValue(paramName, paramValue);
            logger.debug((Object)("Set param '" + paramName + "' = '" + paramValue + "'"));
            return true;
        }
        catch (UnknownParamException e) {
            return false;
        }
    }

    public static String getParameterDefaultValue(NamedParams params, String paramName) {
        String value = null;
        try {
            value = params.getParameterDefault(paramName);
        }
        catch (UnknownParamException unknownParamException) {
            // empty catch block
        }
        return value;
    }

    public static String getParameterValue(NamedParams params, String paramName) {
        String value = null;
        try {
            value = params.getParameterValue(paramName);
        }
        catch (UnknownParamException unknownParamException) {
            // empty catch block
        }
        return value;
    }

    private static String arrayToJson(String fieldName, String[] array) {
        if (array != null) {
            JsonFactory factory = new JsonFactory();
            StringWriter writer = new StringWriter();
            JsonGenerator generator = null;
            try {
                generator = factory.createJsonGenerator((Writer)writer);
                generator.writeStartObject();
                generator.writeFieldName(fieldName);
                generator.writeStartArray();
                for (String element : array) {
                    generator.writeString(element);
                }
                generator.writeEndArray();
                generator.writeEndObject();
                generator.close();
                return writer.toString();
            }
            catch (IOException e) {
                logger.error((Object)("Failed to convert array that contains '" + fieldName + "' to JSON"));
            }
        }
        return null;
    }

    private static String getCurrentValue(String paramName) {
        IUserSession userSession;
        if (paramName.startsWith(CPK_SESSION_PARAM_PREFIX) && (userSession = CpkEngine.getInstance().getEnvironment().getSessionUtils().getCurrentSession()) != null) {
            if (paramName.equals(CPK_SESSION_USERNAME)) {
                return userSession.getUserName();
            }
            if (paramName.equals(CPK_SESSION_ROLES)) {
                String[] roles = userSession.getAuthorities();
                return KettleElementHelper.arrayToJson(ROLES_TAG, roles);
            }
            String varName = paramName.substring(CPK_SESSION_PARAM_PREFIX.length());
            logger.debug((Object)("Getting session variable '" + varName + "'"));
            return userSession.getStringParameter(varName);
        }
        return parameterCache.get(paramName);
    }

    public static Map<String, String> getInjectedParameters(NamedParams params) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        for (String paramName : params.listParameters()) {
            if (!INJECTED_PARAM_SET.contains(paramName) && !paramName.startsWith(CPK_SESSION_PARAM_PREFIX)) continue;
            parameters.put(paramName, KettleElementHelper.getCurrentValue(paramName));
        }
        return parameters;
    }

    public static Collection<String> setKettleParameterValues(NamedParams params, Map<String, String> kettleParams) {
        if (kettleParams == null) {
            return Collections.emptySet();
        }
        LinkedList<String> setValueParamNames = new LinkedList<String>();
        for (Map.Entry<String, String> parameter : kettleParams.entrySet()) {
            if (!KettleElementHelper.setParameterValue(params, parameter.getKey(), parameter.getValue())) continue;
            setValueParamNames.add(parameter.getKey());
        }
        return setValueParamNames;
    }

    public static Map<String, String> getKettleParameters(Map<String, Object> requestParams) {
        if (requestParams == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : requestParams.entrySet()) {
            if (!entry.getKey().startsWith(REQUEST_PARAM_PREFIX)) continue;
            String paramName = entry.getKey().substring(REQUEST_PARAM_PREFIX.length());
            String paramValue = entry.getValue().toString();
            parameters.put(paramName, paramValue);
        }
        return parameters;
    }

    public static void clearParameters(NamedParams params, Collection<String> paramNames) {
        if (paramNames == null) {
            return;
        }
        for (String paramName : paramNames) {
            KettleElementHelper.setParameterValue(params, paramName, null);
            logger.debug((Object)("Cleared request param '" + paramName + "'"));
        }
    }

    public static void dump(NamedParams params, VariableSpace vars, String desc, boolean show) {
        logger.debug((Object)(desc + " has " + params.listParameters().length + " param(s) and " + vars.listVariables().length + " var(s)"));
        if (show) {
            Object[] parameters = params.listParameters();
            Arrays.sort(parameters);
            for (Object param : parameters) {
                logger.debug((Object)("  param " + (String)param + " = " + KettleElementHelper.getParameterValue(params, (String)param)));
            }
            Object[] variables = vars.listVariables();
            Arrays.sort(variables);
            for (Object var : variables) {
                logger.debug((Object)("  var " + (String)var + " = " + vars.getVariable((String)var)));
            }
        }
    }

    static {
        File pluginDir = CpkEngine.getInstance().getEnvironment().getPluginUtils().getPluginDirectory();
        parameterCache = new HashMap();
        parameterCache.put(CPK_PLUGIN_ID, CpkEngine.getInstance().getEnvironment().getPluginName());
        parameterCache.put(CPK_PLUGIN_DIR, pluginDir.getAbsolutePath());
        parameterCache.put(CPK_PLUGIN_SYSTEM_DIR, pluginDir.getAbsolutePath() + File.separator + "system");
        parameterCache.put(CPK_SOLUTION_SYSTEM_DIR, pluginDir.getParentFile().getAbsolutePath());
        parameterCache.put(CPK_WEBAPP_DIR, CpkEngine.getInstance().getEnvironment().getWebAppDir());
    }
}

