/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cpk.elements.impl.kettleoutputs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.codehaus.jackson.map.ObjectMapper;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.row.RowMetaInterface;
import pt.webdetails.cpk.elements.impl.KettleResult;
import pt.webdetails.cpk.elements.impl.kettleoutputs.KettleOutput;
import pt.webdetails.cpk.elements.impl.kettleoutputs.RowsJson;
import pt.webdetails.cpk.utils.CpkUtils;

public class JsonKettleOutput
extends KettleOutput {
    @Override
    public JsonKettleOutput setConfiguration(KettleOutput.Configuration configuration) {
        configuration.setMimeType("application/json");
        super.setConfiguration(configuration);
        return this;
    }

    @Override
    public void processResult(KettleResult result) {
        this.logger.debug((Object)"Process Json");
        RowMetaInterface rowMeta = result.getRows().size() > 0 ? result.getRows().get(0).getRowMeta() : null;
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        if (rowMeta != null) {
            int rowSize = rowMeta.size();
            for (RowMetaAndData row : result.getRows()) {
                rows.add(Arrays.copyOfRange(row.getData(), 0, rowSize));
            }
        }
        RowsJson rowsJson = new RowsJson(rows, rowMeta);
        try {
            CpkUtils.setResponseHeaders(this.getResponse(), this.getConfiguration().getMimeType());
            ObjectMapper mapper = new ObjectMapper();
            mapper.writeValue(this.getOut(), (Object)rowsJson);
        }
        catch (IOException ex) {
            this.logger.error((Object)"IO Error processing Json kettle output.", (Throwable)ex);
        }
    }
}

