/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cpk.elements.impl.kettleoutputs;

import java.io.IOException;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.ObjectMapper;
import pt.webdetails.cpk.elements.impl.KettleResult;
import pt.webdetails.cpk.elements.impl.kettleoutputs.KettleOutput;
import pt.webdetails.cpk.utils.CpkUtils;

public class ResultOnlyKettleOutput
extends KettleOutput {
    @Override
    public ResultOnlyKettleOutput setConfiguration(KettleOutput.Configuration configuration) {
        configuration.setMimeType("application/json");
        super.setConfiguration(configuration);
        return this;
    }

    @Override
    public void processResult(KettleResult result) {
        this.logger.debug((Object)"Process Result Only");
        ResultStruct resultStruct = new ResultStruct(result);
        try {
            CpkUtils.setResponseHeaders(this.getResponse(), this.getConfiguration().getMimeType());
            ObjectMapper mapper = new ObjectMapper();
            mapper.writeValue(this.getOut(), (Object)resultStruct);
        }
        catch (IOException ex) {
            this.logger.fatal(null, (Throwable)ex);
        }
    }

    public static final class ResultStruct {
        boolean result;
        int exitStatus;
        int nrRows;
        long nrErrors;

        public ResultStruct(KettleResult result) {
            this.result = result.wasExecutedSuccessfully();
            this.exitStatus = result.getExitStatus();
            this.nrRows = result.getRows() == null ? 0 : result.getRows().size();
            this.nrErrors = result.getNumberOfErrors();
        }

        @JsonProperty(value="result")
        public boolean isResult() {
            return this.result;
        }

        @JsonProperty(value="exitStatus")
        public int getExitStatus() {
            return this.exitStatus;
        }

        @JsonProperty(value="nrRows")
        public int getNrRows() {
            return this.nrRows;
        }

        @JsonProperty(value="nrErrors")
        public long getNrErrors() {
            return this.nrErrors;
        }
    }
}

