/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.oozie.BaseEngineException;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorActionInfo;
import org.apache.oozie.CoordinatorEngine;
import org.apache.oozie.CoordinatorEngineException;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.CoordinatorJobInfo;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.CoordinatorJob;
import org.apache.oozie.client.OozieClient;
import org.apache.oozie.client.OozieClientException;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.coord.CoordRerunXCommand;
import org.apache.oozie.util.XConfiguration;

public class LocalOozieClientCoord
extends OozieClient {
    private final CoordinatorEngine coordEngine;

    public LocalOozieClientCoord(CoordinatorEngine coordEngine) {
        this.coordEngine = coordEngine;
    }

    public String getOozieUrl() {
        return "localoozie";
    }

    public String getProtocolUrl() throws OozieClientException {
        return "localoozie";
    }

    public synchronized void validateWSVersion() throws OozieClientException {
    }

    public Properties createConfiguration() {
        Properties conf = new Properties();
        if (this.coordEngine != null) {
            conf.setProperty("user.name", this.coordEngine.getUser());
        }
        conf.setProperty("group.name", "users");
        return conf;
    }

    public void setHeader(String name, String value) {
    }

    public String getHeader(String name) {
        return null;
    }

    public void removeHeader(String name) {
    }

    public Iterator<String> getHeaderNames() {
        return Collections.EMPTY_SET.iterator();
    }

    public String submit(Properties conf) throws OozieClientException {
        try {
            return this.coordEngine.submitJob(new XConfiguration(conf), false);
        }
        catch (CoordinatorEngineException ex) {
            throw new OozieClientException(ex.getErrorCode().toString(), (Throwable)ex);
        }
    }

    @Deprecated
    public void start(String jobId) throws OozieClientException {
        try {
            this.coordEngine.start(jobId);
        }
        catch (CoordinatorEngineException ex) {
            throw new OozieClientException(ex.getErrorCode().toString(), (Throwable)ex);
        }
        catch (BaseEngineException bex) {
            throw new OozieClientException(bex.getErrorCode().toString(), (Throwable)bex);
        }
    }

    public String run(Properties conf) throws OozieClientException {
        try {
            return this.coordEngine.submitJob(new XConfiguration(conf), true);
        }
        catch (CoordinatorEngineException ex) {
            throw new OozieClientException(ex.getErrorCode().toString(), (Throwable)ex);
        }
    }

    @Deprecated
    public void reRun(String jobId, Properties conf) throws OozieClientException {
        throw new OozieClientException(ErrorCode.E0301.toString(), "no-op");
    }

    public List<CoordinatorAction> reRunCoord(String jobId, String rerunType, String scope, boolean refresh, boolean noCleanup) throws OozieClientException {
        try {
            if (!rerunType.equals("date") && !rerunType.equals("action")) {
                throw new CommandException(ErrorCode.E1018, "date or action expected.");
            }
            CoordinatorActionInfo coordInfo = this.coordEngine.reRun(jobId, rerunType, scope, refresh, noCleanup);
            List<CoordinatorActionBean> actionBeans = coordInfo != null ? coordInfo.getCoordActions() : CoordRerunXCommand.getCoordActions(rerunType, jobId, scope);
            ArrayList<CoordinatorAction> actions = new ArrayList<CoordinatorAction>();
            for (CoordinatorActionBean actionBean : actionBeans) {
                actions.add(actionBean);
            }
            return actions;
        }
        catch (CommandException ce) {
            throw new OozieClientException(ce.getErrorCode().toString(), (Throwable)ce);
        }
        catch (BaseEngineException ex) {
            throw new OozieClientException(ex.getErrorCode().toString(), (Throwable)ex);
        }
    }

    public void suspend(String jobId) throws OozieClientException {
        try {
            this.coordEngine.suspend(jobId);
        }
        catch (CoordinatorEngineException ex) {
            throw new OozieClientException(ex.getErrorCode().toString(), (Throwable)ex);
        }
    }

    public void resume(String jobId) throws OozieClientException {
        try {
            this.coordEngine.resume(jobId);
        }
        catch (CoordinatorEngineException ex) {
            throw new OozieClientException(ex.getErrorCode().toString(), (Throwable)ex);
        }
    }

    public void kill(String jobId) throws OozieClientException {
        try {
            this.coordEngine.kill(jobId);
        }
        catch (CoordinatorEngineException ex) {
            throw new OozieClientException(ex.getErrorCode().toString(), (Throwable)ex);
        }
    }

    @Deprecated
    public WorkflowJob getJobInfo(String jobId) throws OozieClientException {
        throw new OozieClientException(ErrorCode.E0301.toString(), "no-op");
    }

    public CoordinatorJob getCoordJobInfo(String jobId) throws OozieClientException {
        try {
            return this.coordEngine.getCoordJob(jobId);
        }
        catch (CoordinatorEngineException ex) {
            throw new OozieClientException(ex.getErrorCode().toString(), (Throwable)ex);
        }
        catch (BaseEngineException bex) {
            throw new OozieClientException(bex.getErrorCode().toString(), (Throwable)bex);
        }
    }

    public CoordinatorAction getCoordActionInfo(String actionId) throws OozieClientException {
        try {
            return this.coordEngine.getCoordAction(actionId);
        }
        catch (CoordinatorEngineException ex) {
            throw new OozieClientException(ex.getErrorCode().toString(), (Throwable)ex);
        }
        catch (BaseEngineException bex) {
            throw new OozieClientException(bex.getErrorCode().toString(), (Throwable)bex);
        }
    }

    @Deprecated
    public List<WorkflowJob> getJobsInfo(String filter, int start, int len) throws OozieClientException {
        throw new OozieClientException(ErrorCode.E0301.toString(), "no-op");
    }

    public List<CoordinatorJob> getCoordJobsInfo(String filter, int start, int len) throws OozieClientException {
        try {
            CoordinatorJobInfo info = this.coordEngine.getCoordJobs(filter, start, len);
            ArrayList<CoordinatorJob> jobs = new ArrayList<CoordinatorJob>();
            List<CoordinatorJobBean> jobBeans = info.getCoordJobs();
            for (CoordinatorJobBean jobBean : jobBeans) {
                jobs.add(jobBean);
            }
            return jobs;
        }
        catch (CoordinatorEngineException ex) {
            throw new OozieClientException(ex.getErrorCode().toString(), (Throwable)ex);
        }
    }

    @Deprecated
    public List<WorkflowJob> getJobsInfo(String filter) throws OozieClientException {
        throw new OozieClientException(ErrorCode.E0301.toString(), "no-op");
    }
}

