/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.oozie.BulkResponseInfo;
import org.apache.oozie.BundleJobBean;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.Job;
import org.apache.oozie.client.rest.BulkResponseImpl;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.util.DateUtils;
import org.apache.oozie.util.ParamChecker;

public class BulkJPAExecutor
implements JPAExecutor<BulkResponseInfo> {
    private Map<String, List<String>> bulkFilter;
    private int start = 1;
    private int len = 50;

    public BulkJPAExecutor(Map<String, List<String>> bulkFilter, int start, int len) {
        ParamChecker.notNull(bulkFilter, "bulkFilter");
        this.bulkFilter = bulkFilter;
        this.start = start;
        this.len = len;
    }

    @Override
    public String getName() {
        return "BulkJPAExecutor";
    }

    @Override
    public BulkResponseInfo execute(EntityManager em) throws JPAExecutorException {
        ArrayList<BulkResponseImpl> responseList = new ArrayList<BulkResponseImpl>();
        HashMap<String, Timestamp> actionTimes = new HashMap<String, Timestamp>();
        try {
            BundleJobBean bundleBean = this.bundleQuery(em);
            String conditions = this.actionQuery(em, bundleBean, actionTimes, responseList);
            long total = this.countQuery(conditions, em, bundleBean, actionTimes);
            BulkResponseInfo bulk = new BulkResponseInfo(responseList, this.start, this.len, total);
            return bulk;
        }
        catch (Exception e) {
            throw new JPAExecutorException(ErrorCode.E0603, e.getMessage(), e);
        }
    }

    private BundleJobBean bundleQuery(EntityManager em) throws JPAExecutorException {
        BundleJobBean bundleBean = new BundleJobBean();
        String bundleName = this.bulkFilter.get("bundle").get(0);
        Query q = em.createNamedQuery("BULK_MONITOR_BUNDLE_QUERY");
        q.setParameter("appName", (Object)bundleName);
        List bundles = q.getResultList();
        if (bundles.isEmpty()) {
            throw new JPAExecutorException(ErrorCode.E0603, "No bundle entries found for bundle name: " + bundleName);
        }
        if (bundles.size() > 1) {
            throw new JPAExecutorException(ErrorCode.E0603, "Non-unique bundles present for same bundle name: " + bundleName);
        }
        bundleBean = this.getBeanForBundleJob((Object[])bundles.get(0), bundleName);
        return bundleBean;
    }

    private String actionQuery(EntityManager em, BundleJobBean bundleBean, Map<String, Timestamp> times, List<BulkResponseImpl> responseList) throws ParseException {
        Query q = em.createNamedQuery("BULK_MONITOR_ACTIONS_QUERY");
        StringBuilder getActions = new StringBuilder(q.toString());
        StringBuilder conditionClause = new StringBuilder();
        conditionClause.append((CharSequence)this.coordNamesClause(this.bulkFilter.get("coordinators")));
        conditionClause.append((CharSequence)this.statusClause(this.bulkFilter.get("actionstatus")));
        int offset = getActions.indexOf("ORDER");
        getActions.insert(offset - 1, conditionClause);
        this.timesClause(getActions, offset, times);
        q = em.createQuery(getActions.toString());
        for (Map.Entry<String, Timestamp> time : times.entrySet()) {
            q.setParameter(time.getKey(), (Object)time.getValue());
        }
        q.setParameter("bundleId", (Object)bundleBean.getId());
        q.setFirstResult(this.start - 1);
        q.setMaxResults(this.len);
        List response = q.getResultList();
        for (Object[] r : response) {
            BulkResponseImpl br = this.getResponseFromObject(bundleBean, r);
            responseList.add(br);
        }
        return q.toString();
    }

    private long countQuery(String clause, EntityManager em, BundleJobBean bundleBean, Map<String, Timestamp> times) {
        Query q = em.createNamedQuery("BULK_MONITOR_COUNT_QUERY");
        StringBuilder getTotal = new StringBuilder(q.toString() + " ");
        getTotal.append(clause.substring(clause.indexOf("WHERE"), clause.indexOf("ORDER")));
        q = em.createQuery(getTotal.toString());
        q.setParameter("bundleId", (Object)bundleBean.getId());
        for (Map.Entry<String, Timestamp> time : times.entrySet()) {
            q.setParameter(time.getKey(), (Object)time.getValue());
        }
        long total = (Long)q.getSingleResult();
        return total;
    }

    private StringBuilder coordNamesClause(List<String> coordNames) {
        StringBuilder sb = new StringBuilder();
        boolean firstVal = true;
        for (String name : BulkJPAExecutor.nullToEmpty(coordNames)) {
            if (firstVal) {
                sb.append(" AND c.appName IN ('" + name + "'");
                firstVal = false;
                continue;
            }
            sb.append(",'" + name + "'");
        }
        if (!firstVal) {
            sb.append(") ");
        }
        return sb;
    }

    private StringBuilder statusClause(List<String> statuses) {
        StringBuilder sb = new StringBuilder();
        boolean firstVal = true;
        for (String status : BulkJPAExecutor.nullToEmpty(statuses)) {
            if (firstVal) {
                sb.append(" AND a.status IN ('" + status + "'");
                firstVal = false;
                continue;
            }
            sb.append(",'" + status + "'");
        }
        if (!firstVal) {
            sb.append(") ");
        } else {
            sb.append(" AND a.status IN ('KILLED', 'FAILED') ");
        }
        return sb;
    }

    private void timesClause(StringBuilder sb, int offset, Map<String, Timestamp> eachTime) throws ParseException {
        Timestamp ts = null;
        List<String> times = this.bulkFilter.get("startcreatedtime");
        if (times != null) {
            ts = new Timestamp(DateUtils.parseDateUTC(times.get(0)).getTime());
            sb.insert(offset - 1, " AND a.createdTimestamp >= :startCreated");
            eachTime.put("startCreated", ts);
        }
        if ((times = this.bulkFilter.get("endcreatedtime")) != null) {
            ts = new Timestamp(DateUtils.parseDateUTC(times.get(0)).getTime());
            sb.insert(offset - 1, " AND a.createdTimestamp <= :endCreated");
            eachTime.put("endCreated", ts);
        }
        if ((times = this.bulkFilter.get("startscheduledtime")) != null) {
            ts = new Timestamp(DateUtils.parseDateUTC(times.get(0)).getTime());
            sb.insert(offset - 1, " AND a.nominalTimestamp >= :startNominal");
            eachTime.put("startNominal", ts);
        }
        if ((times = this.bulkFilter.get("endscheduledtime")) != null) {
            ts = new Timestamp(DateUtils.parseDateUTC(times.get(0)).getTime());
            sb.insert(offset - 1, " AND a.nominalTimestamp <= :endNominal");
            eachTime.put("endNominal", ts);
        }
    }

    private BulkResponseImpl getResponseFromObject(BundleJobBean bundleBean, Object[] arr) {
        BulkResponseImpl bean = new BulkResponseImpl();
        CoordinatorJobBean coordBean = new CoordinatorJobBean();
        CoordinatorActionBean actionBean = new CoordinatorActionBean();
        if (arr[0] != null) {
            actionBean.setId((String)arr[0]);
        }
        if (arr[1] != null) {
            actionBean.setActionNumber((Integer)arr[1]);
        }
        if (arr[2] != null) {
            actionBean.setErrorCode((String)arr[2]);
        }
        if (arr[3] != null) {
            actionBean.setErrorMessage((String)arr[3]);
        }
        if (arr[4] != null) {
            actionBean.setExternalId((String)arr[4]);
        }
        if (arr[5] != null) {
            actionBean.setExternalStatus((String)arr[5]);
        }
        if (arr[6] != null) {
            actionBean.setStatus(CoordinatorAction.Status.valueOf((String)((String)arr[6])));
        }
        if (arr[7] != null) {
            actionBean.setCreatedTime(DateUtils.toDate((Timestamp)arr[7]));
        }
        if (arr[8] != null) {
            actionBean.setNominalTime(DateUtils.toDate((Timestamp)arr[8]));
        }
        if (arr[9] != null) {
            actionBean.setMissingDependencies((String)arr[9]);
        }
        if (arr[10] != null) {
            coordBean.setId((String)arr[10]);
            actionBean.setJobId((String)arr[10]);
        }
        if (arr[11] != null) {
            coordBean.setAppName((String)arr[11]);
        }
        if (arr[12] != null) {
            coordBean.setStatus(Job.Status.valueOf((String)((String)arr[12])));
        }
        bean.setBundle(bundleBean);
        bean.setCoordinator(coordBean);
        bean.setAction(actionBean);
        return bean;
    }

    private BundleJobBean getBeanForBundleJob(Object[] barr, String name) throws JPAExecutorException {
        BundleJobBean bean = new BundleJobBean();
        if (barr[0] == null) {
            throw new JPAExecutorException(ErrorCode.E0603, "bundleId returned by query is null - cannot retrieve bulk results");
        }
        bean.setId((String)barr[0]);
        bean.setAppName(name);
        if (barr[1] != null) {
            bean.setStatus(Job.Status.valueOf((String)((String)barr[1])));
        }
        if (barr[2] != null) {
            bean.setUser((String)barr[2]);
        }
        return bean;
    }

    public static List<String> nullToEmpty(List<String> input) {
        return input == null ? Collections.emptyList() : input;
    }
}

