/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import java.sql.Timestamp;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.util.DateUtils;
import org.apache.oozie.util.ParamChecker;

public class CoordActionGetForTimeoutJPAExecutor
implements JPAExecutor<CoordinatorActionBean> {
    private String coordActionId = null;

    public CoordActionGetForTimeoutJPAExecutor(String coordActionId) {
        ParamChecker.notNull(coordActionId, "coordActionId");
        this.coordActionId = coordActionId;
    }

    @Override
    public String getName() {
        return "CoordActionGetForTimeoutJPAExecutor";
    }

    @Override
    public CoordinatorActionBean execute(EntityManager em) throws JPAExecutorException {
        try {
            Query q = em.createNamedQuery("GET_COORD_ACTION_FOR_TIMEOUT");
            q.setParameter("id", (Object)this.coordActionId);
            Object[] obj = (Object[])q.getSingleResult();
            CoordinatorActionBean caBean = this.getBeanForRunningCoordAction(obj);
            return caBean;
        }
        catch (Exception e) {
            throw new JPAExecutorException(ErrorCode.E0603, e.getMessage(), e);
        }
    }

    private CoordinatorActionBean getBeanForRunningCoordAction(Object[] arr) {
        CoordinatorActionBean bean = new CoordinatorActionBean();
        if (arr[0] != null) {
            bean.setId((String)arr[0]);
        }
        if (arr[1] != null) {
            bean.setJobId((String)arr[1]);
        }
        if (arr[2] != null) {
            bean.setStatus(CoordinatorAction.Status.valueOf((String)((String)arr[2])));
        }
        if (arr[3] != null) {
            bean.setRunConf((String)arr[3]);
        }
        if (arr[4] != null) {
            bean.setPending((Integer)arr[4]);
        }
        if (arr[5] != null) {
            bean.setNominalTime(DateUtils.toDate((Timestamp)arr[5]));
        }
        if (arr[6] != null) {
            bean.setCreatedTime(DateUtils.toDate((Timestamp)arr[6]));
        }
        return bean;
    }
}

