/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.serialization.types;

import com.orientechnologies.common.directmemory.ODirectMemory;
import com.orientechnologies.common.serialization.types.OBinarySerializer;

public class OByteSerializer
implements OBinarySerializer<Byte> {
    public static final int BYTE_SIZE = 1;
    public static OByteSerializer INSTANCE = new OByteSerializer();
    public static final byte ID = 2;

    @Override
    public int getObjectSize(Byte object) {
        return 1;
    }

    @Override
    public void serialize(Byte object, byte[] stream, int startPosition) {
        stream[startPosition] = object;
    }

    @Override
    public Byte deserialize(byte[] stream, int startPosition) {
        return stream[startPosition];
    }

    @Override
    public int getObjectSize(byte[] stream, int startPosition) {
        return 1;
    }

    @Override
    public byte getId() {
        return 2;
    }

    @Override
    public int getObjectSizeNative(byte[] stream, int startPosition) {
        return this.getObjectSize(stream, startPosition);
    }

    @Override
    public void serializeNative(Byte object, byte[] stream, int startPosition) {
        this.serialize(object, stream, startPosition);
    }

    @Override
    public Byte deserializeNative(byte[] stream, int startPosition) {
        return this.deserialize(stream, startPosition);
    }

    @Override
    public void serializeInDirectMemory(Byte object, ODirectMemory memory, long pointer) {
        memory.setByte(pointer, object);
    }

    @Override
    public Byte deserializeFromDirectMemory(ODirectMemory memory, long pointer) {
        return memory.getByte(pointer);
    }

    @Override
    public int getObjectSizeInDirectMemory(ODirectMemory memory, long pointer) {
        return 1;
    }

    @Override
    public boolean isFixedLength() {
        return true;
    }

    @Override
    public int getFixedLength() {
        return 1;
    }
}

