/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.serialization.types;

import com.orientechnologies.common.directmemory.ODirectMemory;
import com.orientechnologies.common.serialization.OBinaryConverter;
import com.orientechnologies.common.serialization.OBinaryConverterFactory;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import java.nio.ByteOrder;

public class OCharSerializer
implements OBinarySerializer<Character> {
    private static final OBinaryConverter BINARY_CONVERTER = OBinaryConverterFactory.getConverter();
    public static final int CHAR_SIZE = 2;
    public static OCharSerializer INSTANCE = new OCharSerializer();
    public static final byte ID = 3;

    @Override
    public int getObjectSize(Character object) {
        return 2;
    }

    @Override
    public void serialize(Character object, byte[] stream, int startPosition) {
        stream[startPosition] = (byte)(object.charValue() >>> 8);
        stream[startPosition + 1] = (byte)object.charValue();
    }

    @Override
    public Character deserialize(byte[] stream, int startPosition) {
        return Character.valueOf((char)(((stream[startPosition] & 0xFF) << 8) + (stream[startPosition + 1] & 0xFF)));
    }

    @Override
    public int getObjectSize(byte[] stream, int startPosition) {
        return 2;
    }

    @Override
    public byte getId() {
        return 3;
    }

    @Override
    public int getObjectSizeNative(byte[] stream, int startPosition) {
        return 2;
    }

    @Override
    public void serializeNative(Character object, byte[] stream, int startPosition) {
        BINARY_CONVERTER.putChar(stream, startPosition, object.charValue(), ByteOrder.nativeOrder());
    }

    @Override
    public Character deserializeNative(byte[] stream, int startPosition) {
        return Character.valueOf(BINARY_CONVERTER.getChar(stream, startPosition, ByteOrder.nativeOrder()));
    }

    @Override
    public void serializeInDirectMemory(Character object, ODirectMemory memory, long pointer) {
        memory.setChar(pointer, object.charValue());
    }

    @Override
    public Character deserializeFromDirectMemory(ODirectMemory memory, long pointer) {
        return Character.valueOf(memory.getChar(pointer));
    }

    @Override
    public int getObjectSizeInDirectMemory(ODirectMemory memory, long pointer) {
        return 2;
    }

    @Override
    public boolean isFixedLength() {
        return true;
    }

    @Override
    public int getFixedLength() {
        return 2;
    }
}

