/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.rules.java;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.AbstractList;
import java.util.Collections;
import java.util.List;
import net.hydromatic.linq4j.expressions.Expression;
import net.hydromatic.linq4j.expressions.ExpressionType;
import net.hydromatic.linq4j.expressions.Expressions;
import net.hydromatic.linq4j.expressions.MemberExpression;
import net.hydromatic.linq4j.expressions.PseudoField;
import net.hydromatic.linq4j.expressions.Types;
import net.hydromatic.linq4j.expressions.UnaryExpression;
import net.hydromatic.optiq.BuiltinMethod;
import net.hydromatic.optiq.impl.java.JavaTypeFactory;
import net.hydromatic.optiq.rules.java.RexToLixTranslator;
import net.hydromatic.optiq.runtime.FlatLists;
import net.hydromatic.optiq.runtime.Unit;
import org.eigenbase.reltype.RelDataType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum JavaRowFormat {
    CUSTOM{

        @Override
        Type javaRowClass(JavaTypeFactory typeFactory, RelDataType type) {
            assert (type.getFieldCount() > 1);
            return typeFactory.getJavaClass(type);
        }

        @Override
        public Expression record(Type javaRowClass, List<Expression> expressions) {
            switch (expressions.size()) {
                case 0: {
                    assert (javaRowClass == Unit.class);
                    return Expressions.field(null, (Type)javaRowClass, (String)"INSTANCE");
                }
            }
            return Expressions.new_((Type)javaRowClass, expressions);
        }

        public MemberExpression field(Expression expression, int field, Class fieldType) {
            Type type = expression.getType();
            if (type instanceof Types.RecordType) {
                Types.RecordType recordType = (Types.RecordType)type;
                Types.RecordField recordField = (Types.RecordField)recordType.getRecordFields().get(field);
                return Expressions.field((Expression)expression, (Type)recordField.getDeclaringClass(), (String)recordField.getName());
            }
            return Expressions.field((Expression)expression, (PseudoField)Types.nthField((int)field, (Type)type));
        }
    }
    ,
    SCALAR{

        @Override
        Type javaRowClass(JavaTypeFactory typeFactory, RelDataType type) {
            assert (type.getFieldCount() == 1);
            return typeFactory.getJavaClass(type.getFieldList().get(0).getType());
        }

        @Override
        public Expression record(Type javaRowClass, List<Expression> expressions) {
            assert (expressions.size() == 1);
            return expressions.get(0);
        }

        @Override
        public Expression field(Expression expression, int field, Class fieldType) {
            assert (field == 0);
            return expression;
        }
    }
    ,
    LIST{

        @Override
        Type javaRowClass(JavaTypeFactory typeFactory, RelDataType type) {
            return FlatLists.ComparableList.class;
        }

        @Override
        public Expression record(Type javaRowClass, List<Expression> expressions) {
            switch (expressions.size()) {
                case 0: {
                    return Expressions.field(null, Collections.class, (String)"EMPTY_LIST");
                }
                case 2: {
                    return Expressions.convert_((Expression)Expressions.call(List.class, null, (Method)BuiltinMethod.LIST2.method, expressions), List.class);
                }
                case 3: {
                    return Expressions.convert_((Expression)Expressions.call(List.class, null, (Method)BuiltinMethod.LIST3.method, expressions), List.class);
                }
            }
            return Expressions.convert_((Expression)Expressions.call(List.class, null, (Method)BuiltinMethod.ARRAYS_AS_LIST.method, (Expression[])new Expression[]{Expressions.newArrayInit(Object.class, expressions)}), List.class);
        }

        @Override
        public Expression field(Expression expression, int field, Class fieldType) {
            return RexToLixTranslator.convert((Expression)Expressions.call((Expression)expression, (Method)BuiltinMethod.LIST_GET.method, (Expression[])new Expression[]{Expressions.constant((Object)field)}), fieldType);
        }
    }
    ,
    ARRAY{

        @Override
        Type javaRowClass(JavaTypeFactory typeFactory, RelDataType type) {
            assert (type.getFieldCount() > 1);
            return Object[].class;
        }

        @Override
        public Expression record(Type javaRowClass, List<Expression> expressions) {
            return Expressions.newArrayInit(Object.class, (Iterable)JavaRowFormat.stripCasts(expressions));
        }

        @Override
        public Expression comparer() {
            return Expressions.call(null, (Method)BuiltinMethod.ARRAY_COMPARER.method, (Expression[])new Expression[0]);
        }

        @Override
        public Expression field(Expression expression, int field, Class fieldType) {
            return RexToLixTranslator.convert((Expression)Expressions.arrayIndex((Expression)expression, (Expression)Expressions.constant((Object)field)), fieldType);
        }
    };


    public JavaRowFormat optimize(RelDataType rowType) {
        switch (rowType.getFieldCount()) {
            case 0: {
                return LIST;
            }
            case 1: {
                return SCALAR;
            }
        }
        if (this == SCALAR) {
            return LIST;
        }
        return this;
    }

    abstract Type javaRowClass(JavaTypeFactory var1, RelDataType var2);

    public abstract Expression record(Type var1, List<Expression> var2);

    private static List<Expression> stripCasts(final List<Expression> expressions) {
        return new AbstractList<Expression>(){

            @Override
            public Expression get(int index) {
                Expression expression = (Expression)expressions.get(index);
                while (expression.getNodeType() == ExpressionType.Convert) {
                    expression = ((UnaryExpression)expression).expression;
                }
                return expression;
            }

            @Override
            public int size() {
                return expressions.size();
            }
        };
    }

    public Expression comparer() {
        return null;
    }

    public abstract Expression field(Expression var1, int var2, Class var3);
}

