/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rel.rules;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.eigenbase.rel.ProjectRel;
import org.eigenbase.rel.RelCollation;
import org.eigenbase.rel.RelFieldCollation;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.SortRel;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelOptRule;
import org.eigenbase.relopt.RelOptRuleCall;
import org.eigenbase.relopt.RelOptRuleOperand;
import org.eigenbase.relopt.RelOptUtil;
import org.eigenbase.relopt.RelTrait;
import org.eigenbase.rex.RexUtil;
import org.eigenbase.util.mapping.Mappings;

public class PushSortPastProjectRule
extends RelOptRule {
    public static final PushSortPastProjectRule INSTANCE = new PushSortPastProjectRule();

    private PushSortPastProjectRule() {
        super(PushSortPastProjectRule.operand(SortRel.class, PushSortPastProjectRule.operand(ProjectRel.class, PushSortPastProjectRule.any()), new RelOptRuleOperand[0]));
    }

    public void onMatch(RelOptRuleCall call) {
        SortRel sort = (SortRel)call.rel(0);
        ProjectRel project = (ProjectRel)call.rel(1);
        RelOptCluster cluster = project.getCluster();
        if (sort.getConvention() != project.getConvention()) {
            return;
        }
        Mappings.TargetMapping map = RelOptUtil.permutation(project.getProjects(), project.getChild().getRowType());
        for (RelFieldCollation fc : sort.getCollation().getFieldCollations()) {
            if (map.getTargetOpt(fc.getFieldIndex()) >= 0) continue;
            return;
        }
        RelCollation newCollation = cluster.traitSetOf(new RelTrait[0]).canonize(RexUtil.apply(map, sort.getCollation()));
        SortRel newSort = sort.copy(sort.getTraitSet().replace(newCollation), project.getChild(), newCollation, sort.offset, sort.fetch);
        RelNode newProject = project.copy(sort.getTraitSet(), (List<RelNode>)ImmutableList.of((Object)newSort));
        ImmutableMap equiv = sort.offset == null && sort.fetch == null ? ImmutableMap.of((Object)newSort, (Object)project.getChild()) : ImmutableMap.of();
        call.transformTo(newProject, (Map<RelNode, RelNode>)equiv);
    }
}

